/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.ActionContext;
import docking.ComponentPlaceholder;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockingDialog;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import help.HelpService;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.KeyStroke;

public class HelpAction
extends DockingAction {
    private boolean infoOnly;

    public HelpAction(boolean infoOnly, KeyStroke keybinding) {
        super(infoOnly ? "HelpInfo" : "Help", "DockingWindows", false);
        this.createReservedKeyBinding(keybinding);
        this.setEnabled(true);
        this.infoOnly = infoOnly;
        DockingWindowManager.getHelpService().excludeFromHelp((Object)this);
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        return true;
    }

    @Override
    public void actionPerformed(ActionContext context) {
        DockingActionIf mouseOverAction = DockingWindowManager.getMouseOverAction();
        if (mouseOverAction != null) {
            this.showHelp(mouseOverAction);
            return;
        }
        Object mouseOverObject = DockingWindowManager.getMouseOverObject();
        Object helpObject = this.getFirstAvailableObjectThatHasHelp(mouseOverObject);
        if (helpObject != null) {
            this.showHelp(helpObject);
            return;
        }
        Object eventSource = context.getSourceObject();
        helpObject = this.getFirstAvailableObjectThatHasHelp(eventSource);
        if (helpObject != null) {
            this.showHelp(helpObject);
            return;
        }
        DialogComponentProvider dialogProvider = this.findDialogComponentProvider();
        if (dialogProvider != null) {
            this.showHelp(dialogProvider.getComponent());
            return;
        }
        DockingWindowManager windowManager = DockingWindowManager.getActiveInstance();
        ComponentPlaceholder info = windowManager.getFocusedComponent();
        if (info != null) {
            ComponentProvider componentProvider = info.getProvider();
            this.showHelp(componentProvider);
            return;
        }
    }

    private void showHelp(Object helpObject) {
        SystemUtilities.runSwingLater(() -> {
            DockingWindowManager windowManager = DockingWindowManager.getActiveInstance();
            Component component = windowManager.getActiveComponent();
            DockingWindowManager.getHelpService().showHelp(helpObject, this.infoOnly, component);
        });
    }

    private DialogComponentProvider findDialogComponentProvider() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window activeWindow = keyboardFocusManager.getActiveWindow();
        if (activeWindow instanceof DockingDialog) {
            DockingDialog dockingDialog = (DockingDialog)activeWindow;
            return dockingDialog.getDialogComponent();
        }
        return null;
    }

    private Object getFirstAvailableObjectThatHasHelp(Object startingHelpObject) {
        if (startingHelpObject == null) {
            return null;
        }
        HelpService helpService = DockingWindowManager.getHelpService();
        HelpLocation helpLocation = helpService.getHelpLocation(startingHelpObject);
        if (helpLocation != null) {
            return startingHelpObject;
        }
        if (!(startingHelpObject instanceof Component)) {
            return null;
        }
        return this.getFirstAvailableComponentThatHasHelp((Component)startingHelpObject);
    }

    private Component getFirstAvailableComponentThatHasHelp(Component component) {
        HelpService helpService = DockingWindowManager.getHelpService();
        HelpLocation helpLocation = helpService.getHelpLocation((Object)component);
        if (helpLocation != null) {
            return component;
        }
        Container parent = component.getParent();
        if (parent == null) {
            return null;
        }
        return this.getFirstAvailableComponentThatHasHelp(parent);
    }
}

