/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.ActionContext;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import ghidra.util.ReservedKeyBindings;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import javax.swing.JFrame;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShowFocusCycleAction
extends DockingAction {
    static final Logger log = LogManager.getLogger(ShowFocusCycleAction.class);

    public ShowFocusCycleAction() {
        super("Show Focus Cycle", "DockingWindows", false);
        this.createReservedKeyBinding(ReservedKeyBindings.FOCUS_CYCLE_INFO_KEY);
        this.setEnabled(true);
        DockingWindowManager.getHelpService().excludeFromHelp((Object)this);
    }

    @Override
    public void actionPerformed(ActionContext context) {
        log.trace("====================================");
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = kfm.getFocusOwner();
        if (focusOwner != null) {
            Component nextComponent;
            Container focusRoot = focusOwner.getFocusCycleRootAncestor();
            FocusTraversalPolicy policy = focusRoot.getFocusTraversalPolicy();
            log.trace("FocusCycleRoot: " + focusRoot);
            log.trace("FocusTraversalPolicy: " + policy.getClass().getName() + ": " + System.identityHashCode(policy));
            Component firstComponent = nextComponent = policy.getFirstComponent(focusRoot);
            log.trace("\tfirst component: " + this.printComp(nextComponent));
            while ((nextComponent = policy.getComponentAfter(focusRoot, nextComponent)) != firstComponent) {
                log.trace("\tcomponent: " + this.printComp(nextComponent));
            }
        } else {
            log.trace("No focus Owner");
        }
        log.trace("");
    }

    private String printComp(Component comp) {
        if (comp == null) {
            return null;
        }
        if (comp instanceof JFrame) {
            JFrame frame = (JFrame)comp;
            return "Window (" + frame.getTitle() + "): " + System.identityHashCode(frame);
        }
        return comp.getClass().getName() + ": " + System.identityHashCode(comp);
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        return true;
    }
}

