/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.combobox.GComboBox;
import docking.widgets.label.GDLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.IntStream;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FontPropertyEditor
extends PropertyEditorSupport {
    private Font font;
    private static final String SAMPLE_STRING = "ABCabc \u00a9\u00ab\u00a7\u0429\u05d1\u062c\u4eb9";
    private JButton previewButton = new JButton("ABCabc \u00a9\u00ab\u00a7\u0429\u05d1\u062c\u4eb9");

    public FontPropertyEditor() {
        this.previewButton.addActionListener(e -> {
            this.showDialog();
            this.previewButton.setFont(this.font);
        });
    }

    public void showDialog() {
        EditorProvider provider = new EditorProvider(new FontPanel());
        DockingWindowManager.showDialog(this.previewButton, provider);
        this.previewButton.repaint();
    }

    @Override
    public void setValue(Object o) {
        this.font = (Font)o;
        this.previewButton.setFont(this.font);
    }

    @Override
    public Object getValue() {
        return this.font;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this.previewButton;
    }

    class EditorProvider
    extends DialogComponentProvider {
        private Font originalFont;

        EditorProvider(JPanel contentPanel) {
            super("Font Editor", true);
            this.originalFont = FontPropertyEditor.this.font;
            this.addWorkPanel(contentPanel);
            this.addOKButton();
            this.addCancelButton();
        }

        @Override
        protected void okCallback() {
            this.close();
        }

        @Override
        protected void cancelCallback() {
            FontPropertyEditor.this.font = this.originalFont;
            super.cancelCallback();
        }
    }

    private class FontPanel
    extends JPanel
    implements ActionListener {
        JLabel fontLabel;
        JLabel sizeLabel;
        JLabel styleLabel;
        JLabel fontStringLabel;
        JComboBox<FontWrapper> fonts;
        JComboBox<Integer> sizes;
        JComboBox<String> styles;
        int styleChoice;
        int sizeChoice;

        FontPanel() {
            this.init();
        }

        public void init() {
            this.setLayout(new BorderLayout());
            JPanel topPanel = new JPanel();
            JPanel fontPanel = new JPanel();
            JPanel sizePanel = new JPanel();
            JPanel stylePanel = new JPanel();
            JPanel sizeAndStylePanel = new JPanel();
            topPanel.setLayout(new BorderLayout());
            fontPanel.setLayout(new GridLayout(2, 1));
            sizePanel.setLayout(new GridLayout(2, 1));
            stylePanel.setLayout(new GridLayout(2, 1));
            sizeAndStylePanel.setLayout(new BorderLayout());
            topPanel.add("West", fontPanel);
            sizeAndStylePanel.add("West", sizePanel);
            sizeAndStylePanel.add("Center", stylePanel);
            topPanel.add("Center", sizeAndStylePanel);
            this.fontStringLabel = new GDLabel(FontPropertyEditor.SAMPLE_STRING);
            this.fontStringLabel.setPreferredSize(new Dimension(350, 50));
            this.fontStringLabel.setHorizontalAlignment(0);
            this.fontStringLabel.setFont(FontPropertyEditor.this.font);
            topPanel.add("South", this.fontStringLabel);
            this.add("North", topPanel);
            this.fontLabel = new GDLabel("Fonts");
            Font newFont = this.getFont().deriveFont(1);
            this.fontLabel.setFont(newFont);
            this.fontLabel.setHorizontalAlignment(0);
            fontPanel.add(this.fontLabel);
            this.sizeLabel = new GDLabel("Sizes");
            this.sizeLabel.setFont(newFont);
            this.sizeLabel.setHorizontalAlignment(0);
            sizePanel.add(this.sizeLabel);
            this.styleLabel = new GDLabel("Styles");
            this.styleLabel.setFont(newFont);
            this.styleLabel.setHorizontalAlignment(0);
            stylePanel.add(this.styleLabel);
            GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] envfonts = gEnv.getAvailableFontFamilyNames();
            ArrayList<FontWrapper> list = new ArrayList<FontWrapper>(envfonts.length);
            for (String envfont : envfonts) {
                list.add(new FontWrapper(envfont));
            }
            Collections.sort(list);
            this.fonts = new GComboBox<FontWrapper>(list.toArray(new FontWrapper[envfonts.length]));
            this.fonts.setMaximumRowCount(9);
            FontWrapper fontWrapper = new FontWrapper(FontPropertyEditor.this.font.getName());
            fontPanel.add(this.fonts);
            this.fonts.setSelectedItem(fontWrapper);
            this.sizes = new GComboBox<Integer>((Integer[])IntStream.rangeClosed(1, 72).boxed().toArray(Integer[]::new));
            this.sizes.setMaximumRowCount(9);
            sizePanel.add(this.sizes);
            this.sizeChoice = FontPropertyEditor.this.font.getSize();
            this.sizes.setSelectedItem(this.sizeChoice);
            this.sizes.setMaximumRowCount(9);
            this.styles = new GComboBox<String>(new String[]{"PLAIN", "BOLD", "ITALIC", "BOLD & ITALIC"});
            this.styles.setMaximumRowCount(9);
            stylePanel.add(this.styles);
            this.styleChoice = FontPropertyEditor.this.font.getStyle();
            this.styles.setSelectedIndex(this.styleChoice);
            this.fonts.addActionListener(this);
            this.styles.addActionListener(this);
            this.sizes.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object list = event.getSource();
            String fontNameChoice = FontPropertyEditor.this.font.getName();
            if (list == this.fonts) {
                FontWrapper fontWrapper = (FontWrapper)this.fonts.getSelectedItem();
                fontNameChoice = fontWrapper.getFontName();
            } else if (list == this.styles) {
                this.styleChoice = this.styles.getSelectedIndex();
            } else {
                this.sizeChoice = (Integer)this.sizes.getSelectedItem();
            }
            FontPropertyEditor.this.font = new Font(fontNameChoice, this.styleChoice, this.sizeChoice);
            this.fontStringLabel.setFont(FontPropertyEditor.this.font);
            FontMetrics fm = this.fontStringLabel.getFontMetrics(FontPropertyEditor.this.font);
            int height = fm.getHeight();
            Dimension d = this.fontStringLabel.getSize();
            if (d.height < height) {
                d = new Dimension(d.width, height);
                this.fontStringLabel.setPreferredSize(d);
            }
            this.fontStringLabel.invalidate();
            FontPropertyEditor.this.setValue(FontPropertyEditor.this.font);
            FontPropertyEditor.this.firePropertyChange();
        }
    }

    private class FontWrapper
    implements Comparable<FontWrapper> {
        private final String fontName;

        private FontWrapper(String fontName) {
            this.fontName = fontName;
        }

        private String getFontName() {
            return this.fontName;
        }

        public String toString() {
            return this.fontName;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            FontWrapper otherWrapper = (FontWrapper)obj;
            return this.fontName.toLowerCase().equals(otherWrapper.fontName.toLowerCase());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fontName == null ? 0 : this.fontName.toLowerCase().hashCode());
            return result;
        }

        @Override
        public int compareTo(FontWrapper otherWrapper) {
            return this.fontName.compareToIgnoreCase(otherWrapper.fontName);
        }
    }
}

