/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.ColumnSortState;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicColumnTableModel;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.MappedTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.TableSortState;
import docking.widgets.table.VariableColumnTableModel;
import docking.widgets.table.sort.ColumnRenderedValueBackupComparator;
import docking.widgets.table.sort.DefaultColumnComparator;
import docking.widgets.table.sort.RowBasedColumnComparator;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.docking.settings.SettingsImpl;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import util.CollectionUtils;
import utilities.util.reflection.ReflectionUtilities;

public abstract class GDynamicColumnTableModel<ROW_TYPE, DATA_SOURCE>
extends AbstractSortedTableModel<ROW_TYPE>
implements ChangeListener,
VariableColumnTableModel,
DynamicColumnTableModel<ROW_TYPE> {
    protected ServiceProvider serviceProvider;
    private TableColumnDescriptor<ROW_TYPE> columnDescriptor;
    protected List<DynamicTableColumn<ROW_TYPE, ?, ?>> tableColumns = new ArrayList();
    private List<DynamicTableColumn<ROW_TYPE, ?, ?>> defaultTableColumns = new ArrayList();
    protected Map<DynamicTableColumn<ROW_TYPE, ?, ?>, Settings> columnSettings = new HashMap();
    private boolean ignoreSettingChanges = false;

    public GDynamicColumnTableModel(ServiceProvider serviceProvider) {
        SystemUtilities.assertTrue((serviceProvider != null ? 1 : 0) != 0, (String)"ServiceProvider cannot be null");
        this.serviceProvider = serviceProvider;
        this.reloadColumns();
    }

    protected abstract TableColumnDescriptor<ROW_TYPE> createTableColumnDescriptor();

    @Override
    public boolean isSortable(int columnIndex) {
        return true;
    }

    protected void loadDiscoveredTableColumns() {
        Class<?> implementationClass = this.getClass();
        List templateClasses = ReflectionUtilities.getTypeArguments(GDynamicColumnTableModel.class, implementationClass);
        Class runtimeRowObject = (Class)templateClasses.get(0);
        Collection columns = DiscoverableTableUtils.getDynamicTableColumns(runtimeRowObject);
        for (DynamicTableColumn column : columns) {
            if (this.tableColumns.contains(column)) continue;
            this.tableColumns.add(column);
        }
    }

    private void loadDefaultTableColumns() {
        TableColumnDescriptor<ROW_TYPE> descriptor = this.getTableColumnDescriptor();
        List<DynamicTableColumn<ROW_TYPE, ?, ?>> defaultColumns = descriptor.getDefaultVisibleColumns();
        this.defaultTableColumns.addAll(defaultColumns);
        List<DynamicTableColumn<ROW_TYPE, ?, ?>> allColumns = descriptor.getAllColumns();
        this.tableColumns.addAll(allColumns);
        TableSortState sortState = descriptor.getDefaultTableSortState(this);
        if (sortState.getSortedColumnCount() == 0) {
            sortState = TableSortState.createDefaultSortState(0);
        }
        this.setDefaultTableSortState(sortState);
    }

    protected void reloadColumns() {
        this.columnDescriptor = null;
        this.tableColumns.clear();
        this.defaultTableColumns.clear();
        this.loadDefaultTableColumns();
        this.loadDiscoveredTableColumns();
        this.columnSettings.clear();
        for (DynamicTableColumn<ROW_TYPE, ?, ?> column : this.tableColumns) {
            this.columnSettings.put(column, new SettingsImpl(this, column));
        }
    }

    private TableColumnDescriptor<ROW_TYPE> getTableColumnDescriptor() {
        if (this.columnDescriptor == null) {
            this.columnDescriptor = this.createTableColumnDescriptor();
        }
        return this.columnDescriptor;
    }

    private DynamicTableColumn<ROW_TYPE, ?, ?> getColumnForDefaultColumnIdentifier(Class<?> clazz) {
        List matching = this.tableColumns.stream().filter(c -> this.isColumnClassMatch((DynamicTableColumn<ROW_TYPE, ?, ?>)c, clazz)).collect(Collectors.toList());
        if (matching.size() > 1) {
            Msg.warn((Object)this, (Object)("More than one column found matching class '" + clazz + "'"));
        }
        return (DynamicTableColumn)CollectionUtils.any(matching);
    }

    private boolean isColumnClassMatch(DynamicTableColumn<ROW_TYPE, ?, ?> column, Class<?> clazz) {
        MappedTableColumn mappedColumn;
        Class<?> columnClass;
        if (clazz.equals(column.getClass())) {
            return true;
        }
        return column instanceof MappedTableColumn && clazz.equals(columnClass = (mappedColumn = (MappedTableColumn)column).getMappedColumnClass());
    }

    @Override
    protected Comparator<ROW_TYPE> createSortComparator(int columnIndex) {
        Comparator<Object> columnComparator = this.createSortComparatorForColumn(columnIndex);
        if (columnComparator != null) {
            return new RowBasedColumnComparator(this, columnIndex, columnComparator);
        }
        return new RowBasedColumnComparator(this, columnIndex, new DefaultColumnComparator(), new ColumnRenderedValueBackupComparator(this, columnIndex));
    }

    protected Comparator<Object> createSortComparatorForColumn(int columnIndex) {
        DynamicTableColumn<ROW_TYPE, ?, ?> column = this.getColumn(columnIndex);
        Comparator<Object> comparator = column.getComparator(this, columnIndex);
        return comparator;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.ignoreSettingChanges) {
            return;
        }
        if (this.resortIfNeeded(e)) {
            return;
        }
        this.fireTableDataChanged();
    }

    private boolean resortIfNeeded(ChangeEvent e) {
        if (e == null) {
            return false;
        }
        Object source = e.getSource();
        TableSortState tableSortState = this.getTableSortState();
        for (ColumnSortState columnSortState : tableSortState) {
            int columnIndex = columnSortState.getColumnModelIndex();
            DynamicTableColumn<ROW_TYPE, ?, ?> column = this.tableColumns.get(columnIndex);
            if (column != source) continue;
            this.reSort();
            return true;
        }
        return false;
    }

    protected void addTableColumn(DynamicTableColumn<ROW_TYPE, ?, ?> column) {
        this.addTableColumns(CollectionUtils.asSet((Object[])new DynamicTableColumn[]{column}));
    }

    protected void addTableColumns(Set<DynamicTableColumn<ROW_TYPE, ?, ?>> columns) {
        for (DynamicTableColumn<ROW_TYPE, ?, ?> column : columns) {
            this.doAddTableColumn(column, this.getDefaultTableColumns().size(), true);
        }
        this.fireTableStructureChanged();
    }

    protected void addTableColumn(DynamicTableColumn<ROW_TYPE, ?, ?> column, int index, boolean isDefault) {
        this.doAddTableColumn(column, index, isDefault);
        this.fireTableStructureChanged();
    }

    private void doAddTableColumn(DynamicTableColumn<ROW_TYPE, ?, ?> column, int index, boolean isDefault) {
        if (index < 0 || index > this.tableColumns.size()) {
            index = this.getDefaultTableColumns().size();
        }
        this.tableColumns.add(index, column);
        this.columnSettings.put(column, new SettingsImpl(this, column));
        if (isDefault) {
            List<DynamicTableColumn<ROW_TYPE, ?, ?>> defaultColumns = this.getDefaultTableColumns();
            defaultColumns.add(index, column);
        }
    }

    protected void removeTableColumn(DynamicTableColumn<ROW_TYPE, ?, ?> column) {
        this.removeTableColumns(CollectionUtils.asSet((Object[])new DynamicTableColumn[]{column}));
    }

    protected void removeTableColumns(Set<DynamicTableColumn<ROW_TYPE, ?, ?>> columns) {
        for (DynamicTableColumn<ROW_TYPE, ?, ?> column : columns) {
            List<DynamicTableColumn<ROW_TYPE, ?, ?>> defaultColumns = this.getDefaultTableColumns();
            defaultColumns.remove(column);
            this.tableColumns.remove(column);
            this.columnSettings.remove(column);
        }
        this.fireTableStructureChanged();
    }

    @Override
    public int getDefaultColumnCount() {
        return this.getDefaultTableColumns().size();
    }

    private List<DynamicTableColumn<ROW_TYPE, ?, ?>> getDefaultTableColumns() {
        return this.defaultTableColumns;
    }

    @Override
    public boolean isVisibleByDefault(int modelIndex) {
        if (modelIndex < 0 || modelIndex >= this.tableColumns.size()) {
            return false;
        }
        DynamicTableColumn<ROW_TYPE, ?, ?> column = this.tableColumns.get(modelIndex);
        List<DynamicTableColumn<ROW_TYPE, ?, ?>> defaultColumns = this.getDefaultTableColumns();
        return defaultColumns.contains(column);
    }

    @Override
    public boolean isDefaultColumn(int modelIndex) {
        if (modelIndex < 0 || modelIndex >= this.tableColumns.size()) {
            return false;
        }
        DynamicTableColumn<ROW_TYPE, ?, ?> column = this.tableColumns.get(modelIndex);
        List<DynamicTableColumn<ROW_TYPE, ?, ?>> defaultColumns = this.getDefaultTableColumns();
        if (defaultColumns.contains(column)) {
            return true;
        }
        TableColumnDescriptor<ROW_TYPE> descriptor = this.getTableColumnDescriptor();
        List<DynamicTableColumn<ROW_TYPE, ?, ?>> modelSpecifiedColumns = descriptor.getAllColumns();
        return modelSpecifiedColumns.contains(column);
    }

    @Override
    public final int getColumnCount() {
        return this.tableColumns.size();
    }

    @Override
    public final Class<?> getColumnClass(int column) {
        if (column < 0 || column >= this.tableColumns.size()) {
            return null;
        }
        return this.tableColumns.get(column).getColumnClass();
    }

    @Override
    public final String getColumnName(int column) {
        return this.tableColumns.get(column).getColumnName();
    }

    @Override
    public int getPreferredColumnWidth(int column) {
        if (column < 0 || column >= this.tableColumns.size()) {
            return -1;
        }
        return this.tableColumns.get(column).getColumnPreferredWidth();
    }

    @Override
    public String getColumnDisplayName(int columnIndex) {
        DynamicTableColumn<ROW_TYPE, ?, ?> column = this.tableColumns.get(columnIndex);
        return column.getColumnDisplayName(this.columnSettings.get(column));
    }

    @Override
    public String getColumnDescription(int column) {
        return this.tableColumns.get(column).getColumnDescription();
    }

    @Override
    public String getUniqueIdentifier(int column) {
        return this.tableColumns.get(column).getUniqueIdentifier();
    }

    @Override
    public final Object getColumnValueForRow(ROW_TYPE t, int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.tableColumns.size()) {
            return null;
        }
        DATA_SOURCE dataSource = this.getDataSource();
        DynamicTableColumn<ROW_TYPE, ?, ?> column = this.tableColumns.get(columnIndex);
        if (t == null) {
            return null;
        }
        return column.getValue(t, this.columnSettings.get(column), dataSource, this.serviceProvider);
    }

    public abstract DATA_SOURCE getDataSource();

    public int getColumnIndex(Class<?> columnClass) {
        DynamicTableColumn<ROW_TYPE, ?, ?> column = this.getColumnForDefaultColumnIdentifier(columnClass);
        return this.tableColumns.indexOf(column);
    }

    @Override
    public int getColumnIndex(DynamicTableColumn<ROW_TYPE, ?, ?> identifier) {
        int count = this.tableColumns.size();
        for (int listIndex = 0; listIndex < count; ++listIndex) {
            DynamicTableColumn<ROW_TYPE, ?, ?> tableField = this.tableColumns.get(listIndex);
            if (!tableField.equals(identifier)) continue;
            return listIndex;
        }
        return -1;
    }

    @Override
    public DynamicTableColumn<ROW_TYPE, ?, ?> getColumn(int index) {
        return this.tableColumns.get(index);
    }

    @Override
    public SettingsDefinition[] getColumnSettingsDefinitions(int index) {
        return this.tableColumns.get(index).getSettingsDefinitions();
    }

    @Override
    public Settings getColumnSettings(int index) {
        DynamicTableColumn<ROW_TYPE, ?, ?> column = this.tableColumns.get(index);
        return this.columnSettings.get(column);
    }

    private void applySettings(int index, Settings newSettings) {
        DynamicTableColumn<ROW_TYPE, ?, ?> column = this.tableColumns.get(index);
        Settings settings = this.columnSettings.get(column);
        settings.clearAllSettings();
        for (String name : newSettings.getNames()) {
            settings.setValue(name, newSettings.getValue(name));
        }
    }

    @Override
    public synchronized void setAllColumnSettings(Settings[] newSettings) {
        this.ignoreSettingChanges = true;
        for (int modelIndex = 0; modelIndex < newSettings.length; ++modelIndex) {
            this.applySettings(modelIndex, newSettings[modelIndex]);
        }
        this.ignoreSettingChanges = false;
        this.stateChanged(new ChangeEvent(this));
    }

    @Override
    public TableCellRenderer getRenderer(int index) {
        return this.tableColumns.get(index).getColumnRenderer();
    }

    @Override
    public TableCellRenderer getHeaderRenderer(int index) {
        return this.tableColumns.get(index).getHeaderRenderer();
    }

    @Override
    public int getMaxLines(int index) {
        if (index < 0 || index >= this.tableColumns.size()) {
            return 1;
        }
        DynamicTableColumn<ROW_TYPE, ?, ?> column = this.tableColumns.get(index);
        return column.getMaxLines(this.columnSettings.get(column));
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposeDynamicColumnData();
    }

    protected void disposeDynamicColumnData() {
        this.tableColumns.clear();
        this.defaultTableColumns.clear();
        this.columnSettings.clear();
    }
}

