/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree;

import docking.widgets.filter.FilterOptions;
import docking.widgets.filter.TermSplitter;
import docking.widgets.filter.TextFilter;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.InvertedTreeFilter;
import docking.widgets.tree.MultiTextFilterTreeFilter;
import docking.widgets.tree.TreeTextFilter;
import docking.widgets.tree.support.GTreeFilter;
import ghidra.util.FilterTransformer;
import java.util.ArrayList;
import javax.swing.Icon;

public class GTreeFilterFactory {
    private FilterOptions filterOptions;

    public GTreeFilterFactory() {
        this(new FilterOptions());
    }

    public GTreeFilterFactory(FilterOptions filterOptions) {
        this.filterOptions = filterOptions;
    }

    public FilterOptions getFilterOptions() {
        return this.filterOptions;
    }

    public GTreeFilter getTreeFilter(String text, FilterTransformer<GTreeNode> transformer) {
        GTreeFilter treeFilter = this.getBaseFilter(text, transformer);
        if (this.filterOptions.isInverted() && treeFilter != null) {
            treeFilter = new InvertedTreeFilter(treeFilter);
        }
        return treeFilter;
    }

    private GTreeFilter getBaseFilter(String text, FilterTransformer<GTreeNode> transformer) {
        if (this.filterOptions.isMultiterm() && text.trim().length() > 0) {
            return this.getMultiWordTableFilter(text, transformer);
        }
        TextFilter textFilter = this.filterOptions.getTextFilterFactory().getTextFilter(text);
        if (textFilter != null) {
            return new TreeTextFilter(textFilter, transformer);
        }
        return null;
    }

    private GTreeFilter getMultiWordTableFilter(String text, FilterTransformer<GTreeNode> transformer) {
        ArrayList<TextFilter> filters = new ArrayList<TextFilter>();
        TermSplitter splitter = this.filterOptions.getTermSplitter();
        for (String term : splitter.split(text)) {
            TextFilter textFilter = this.filterOptions.getTextFilterFactory().getTextFilter(term);
            if (textFilter == null) continue;
            filters.add(textFilter);
        }
        return new MultiTextFilterTreeFilter(filters, transformer, this.filterOptions.getMultitermEvaluationMode());
    }

    public Icon getFilterStateIcon() {
        return this.filterOptions.getFilterStateIcon();
    }
}

