/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.impl;

import agent.frida.frida.FridaModuleInfo;
import agent.frida.manager.FridaCause;
import agent.frida.manager.FridaModule;
import agent.frida.manager.FridaProcess;
import agent.frida.manager.FridaSession;
import agent.frida.manager.FridaThread;
import agent.frida.model.iface2.FridaModelTargetModule;
import agent.frida.model.iface2.FridaModelTargetModuleContainer;
import agent.frida.model.iface2.FridaModelTargetSession;
import agent.frida.model.impl.FridaModelImpl;
import agent.frida.model.impl.FridaModelTargetModuleImpl;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import agent.frida.model.methods.FridaModelTargetModuleInitImpl;
import agent.frida.model.methods.FridaModelTargetModuleInterceptorImpl;
import agent.frida.model.methods.FridaModelTargetModuleLoadImpl;
import agent.frida.model.methods.FridaModelTargetUnloadScriptImpl;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetModule;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.Msg;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="ModuleContainer", elements={@TargetElementType(type=FridaModelTargetModuleImpl.class)}, elementResync=TargetObjectSchema.ResyncMode.ONCE, attributes={@TargetAttributeType(type=Object.class)}, canonicalContainer=true)
public class FridaModelTargetModuleContainerImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetModuleContainer {
    protected final FridaModelTargetSession targetSession;
    protected final FridaSession session;
    private FridaModelTargetModuleLoadImpl load;
    private FridaModelTargetModuleInitImpl init;
    private FridaModelTargetModuleInterceptorImpl intercept;
    private FridaModelTargetUnloadScriptImpl unload;

    public FridaModelTargetModuleContainerImpl(FridaModelTargetSession session) {
        super(session.getModel(), (TargetObject)session, "Modules", "ModuleContainer");
        this.targetSession = session;
        this.session = (FridaSession)session.getModelObject();
        this.load = new FridaModelTargetModuleLoadImpl(this);
        this.init = new FridaModelTargetModuleInitImpl(this);
        this.intercept = new FridaModelTargetModuleInterceptorImpl(this);
        this.unload = new FridaModelTargetUnloadScriptImpl(this, this.intercept.getName());
        this.changeAttributes(List.of(), List.of(this.load, this.init, this.intercept, this.unload), Map.of(), "Initialized");
        this.getManager().addEventsListener(this);
        this.requestElements(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moduleLoaded(FridaProcess proc, FridaModuleInfo info, int index, FridaCause cause) {
        FridaModelTargetModule targetModule;
        FridaModule module = info.getModule(index);
        FridaModelTargetModuleContainerImpl fridaModelTargetModuleContainerImpl = this;
        synchronized (fridaModelTargetModuleContainerImpl) {
            targetModule = this.getTargetModule(module);
        }
        if (targetModule == null) {
            Msg.error((Object)this, (Object)("Module " + info.getModuleName(index) + " not found!"));
            return;
        }
        FridaThread thread = this.getManager().getCurrentThread();
        TargetThread eventThread = (TargetThread)this.getModel().getModelObject(thread);
        this.changeElements(List.of(), List.of(targetModule), Map.of(), "Loaded");
        ((DebuggerModelListener)this.getListeners().fire).event((TargetObject)this.getProxy(), eventThread, TargetEventScope.TargetEventType.MODULE_LOADED, "Library " + info.getModuleName(index) + " loaded", List.of(targetModule));
    }

    @Override
    public void moduleReplaced(FridaProcess proc, FridaModuleInfo info, int index, FridaCause cause) {
        FridaModule module = info.getModule(index);
        this.changeElements(List.of(), List.of(this.getTargetModule(module)), Map.of(), "Replaced");
        FridaModelTargetModule targetModule = this.getTargetModule(module);
        this.changeElements(List.of(), List.of(targetModule), Map.of(), "Replaced");
    }

    @Override
    public void moduleUnloaded(FridaProcess proc, FridaModuleInfo info, int index, FridaCause cause) {
        FridaModelTargetModule targetModule = this.getTargetModule(info.getModule(index));
        if (targetModule != null) {
            FridaThread thread = this.getManager().getCurrentThread();
            TargetThread eventThread = (TargetThread)this.getModel().getModelObject(thread);
            ((DebuggerModelListener)this.getListeners().fire).event((TargetObject)this.getProxy(), eventThread, TargetEventScope.TargetEventType.MODULE_UNLOADED, "Library " + info.getModuleName(index) + " unloaded", List.of(targetModule));
            FridaModelImpl impl = (FridaModelImpl)this.model;
            impl.deleteModelObject(targetModule.getModule());
        }
        this.changeElements(List.of(info.getModuleName(index)), List.of(), Map.of(), "Unloaded");
    }

    public boolean supportsSyntheticModules() {
        return false;
    }

    @Override
    public CompletableFuture<? extends TargetModule> addSyntheticModule(String name) {
        throw new UnsupportedOperationException("frida does not support synthetic modules");
    }

    public CompletableFuture<Void> requestElements(boolean refresh) {
        if (refresh) {
            ((DebuggerModelListener)this.listeners.fire).invalidateCacheRequested((TargetObject)this);
        }
        return this.getManager().listModules(this.session.getProcess());
    }

    @Override
    public FridaModelTargetModule getTargetModule(FridaModule module) {
        TargetObject targetObject = this.getMapObject(module);
        if (targetObject != null) {
            FridaModelTargetModule targetModule = (FridaModelTargetModule)targetObject;
            targetModule.setModelObject(module);
            return targetModule;
        }
        return new FridaModelTargetModuleImpl(this, module);
    }
}

