/*
 * Decompiled with CFR 0.152.
 */
package agent.frida.model.methods;

import agent.frida.manager.FridaThread;
import agent.frida.model.iface1.FridaModelTargetMethod;
import agent.frida.model.iface2.FridaModelTargetThreadContainer;
import agent.frida.model.impl.FridaModelTargetObjectImpl;
import agent.frida.model.impl.FridaModelTargetThreadImpl;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="ThreadStalk", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(type=Object.class)}, canonicalContainer=true)
public class FridaModelTargetThreadStalkImpl
extends FridaModelTargetObjectImpl
implements FridaModelTargetMethod {
    protected final TargetMethod.TargetParameterMap paramDescs;
    private boolean useCurrentThread;

    public FridaModelTargetThreadStalkImpl(FridaModelTargetThreadContainer threads) {
        super(threads.getModel(), (TargetObject)threads, "stalk", "ThreadStalk");
        this.useCurrentThread = true;
        this.paramDescs = TargetMethod.TargetParameterMap.copyOf(this.computeParameters());
        this.changeAttributes(List.of(), List.of(), Map.of("_parameters", this.paramDescs), "Initialized");
    }

    public FridaModelTargetThreadStalkImpl(FridaModelTargetThreadImpl thread) {
        super(thread.getModel(), (TargetObject)thread, "stalk", "ThreadStalk");
        this.useCurrentThread = false;
        this.paramDescs = TargetMethod.TargetParameterMap.copyOf(this.computeParameters());
        this.changeAttributes(List.of(), List.of(), Map.of("_parameters", this.paramDescs), "Initialized");
    }

    public String getTid() {
        Long tid = 0L;
        if (this.useCurrentThread) {
            FridaThread currentThread = this.getManager().getCurrentThread();
            if (currentThread != null) {
                tid = currentThread.getTid();
            }
        } else {
            tid = ((FridaThread)this.getModelObject()).getTid();
        }
        return Long.toString(tid);
    }

    public Map<String, TargetMethod.ParameterDescription<?>> computeParameters() {
        HashMap map = new HashMap();
        TargetMethod.ParameterDescription e_calls = TargetMethod.ParameterDescription.create(Boolean.class, (String)"EventCall", (boolean)true, (Object)true, (String)"event=call", (String)"CALL instruction");
        TargetMethod.ParameterDescription e_ret = TargetMethod.ParameterDescription.create(Boolean.class, (String)"EventRet", (boolean)true, (Object)false, (String)"event=ret", (String)"RET  instructions");
        TargetMethod.ParameterDescription e_exec = TargetMethod.ParameterDescription.create(Boolean.class, (String)"EventExec", (boolean)true, (Object)false, (String)"event=exec", (String)"all instructions (not recommended)");
        TargetMethod.ParameterDescription e_block = TargetMethod.ParameterDescription.create(Boolean.class, (String)"EventBlock", (boolean)true, (Object)false, (String)"event=block", (String)"block executed");
        TargetMethod.ParameterDescription e_compile = TargetMethod.ParameterDescription.create(Boolean.class, (String)"EventCompile", (boolean)true, (Object)false, (String)"event=compile", (String)"block compiled");
        TargetMethod.ParameterDescription onReceive = TargetMethod.ParameterDescription.create(String.class, (String)"OnReceive", (boolean)false, (Object)"", (String)"onRecv file", (String)"JS file with onReceive implemenation");
        TargetMethod.ParameterDescription onCallSummary = TargetMethod.ParameterDescription.create(String.class, (String)"OnCallSummary", (boolean)false, (Object)"", (String)"onCall file", (String)"JS file with onCallSummary implementation");
        TargetMethod.ParameterDescription name = TargetMethod.ParameterDescription.create(String.class, (String)"Name", (boolean)false, (Object)"stalk", (String)"name", (String)"name for future unload");
        TargetMethod.ParameterDescription script = TargetMethod.ParameterDescription.create(String.class, (String)"Script", (boolean)false, (Object)"", (String)"script", (String)"script to execute on result");
        map.put("EventCall", e_calls);
        map.put("EventRet", e_ret);
        map.put("EventExec", e_exec);
        map.put("EventBlock", e_block);
        map.put("EventCompile", e_compile);
        map.put("OnReceive", onReceive);
        map.put("OnCallSummary", onCallSummary);
        map.put("Name", name);
        map.put("Script", script);
        return map;
    }

    public CompletableFuture<Object> invoke(Map<String, ?> arguments) {
        this.getManager().stalkThread(this.getTid(), arguments);
        return CompletableFuture.completedFuture(null);
    }
}

