/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfRelocationTable;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.ARM_ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.exception.NotFoundException;
import java.util.Map;

public class ARM_ElfRelocationHandler
extends ElfRelocationHandler {
    public ARM_ElfRelocationContext createRelocationContext(ElfLoadHelper loadHelper, ElfRelocationTable relocationTable, Map<ElfSymbol, Address> symbolMap) {
        return new ARM_ElfRelocationContext(this, loadHelper, relocationTable, symbolMap);
    }

    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 40;
    }

    public int getRelrRelocationType() {
        return 23;
    }

    public void relocate(ElfRelocationContext context, ElfRelocation relocation, Address relocationAddress) throws MemoryAccessException, NotFoundException {
        ElfHeader elf = context.getElfHeader();
        if (elf.e_machine() != 40 || !(context instanceof ARM_ElfRelocationContext)) {
            return;
        }
        ARM_ElfRelocationContext elfRelocationContext = (ARM_ElfRelocationContext)context;
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        boolean instructionBigEndian = program.getLanguage().getLanguageDescription().getInstructionEndian().isBigEndian();
        int type = relocation.getType();
        if (type == 0) {
            return;
        }
        int symbolIndex = relocation.getSymbolIndex();
        long addend = relocation.getAddend();
        ElfSymbol sym = elfRelocationContext.getSymbol(symbolIndex);
        String symbolName = elfRelocationContext.getSymbolName(symbolIndex);
        boolean isThumb = this.isThumb(sym);
        long offset = (int)relocationAddress.getOffset();
        Address symbolAddr = elfRelocationContext.getSymbolAddress(sym);
        long symbolValue = elfRelocationContext.getSymbolValue(sym);
        int newValue = 0;
        switch (type) {
            case 1: {
                int oldValue = memory.getInt(relocationAddress, instructionBigEndian);
                if (elfRelocationContext.extractAddend()) {
                    addend = oldValue << 8 >> 6;
                }
                newValue = (int)(symbolValue + addend);
                newValue = (int)((long)newValue - (offset + (long)elfRelocationContext.getPcBias(false)));
                newValue = (oldValue & 0xF0000000) == -268435456 ? oldValue & 0xFE000000 | (newValue >> 1 & 1) << 24 | newValue >> 2 & 0xFFFFFF : oldValue & 0xFF000000 | newValue >> 2 & 0xFFFFFF;
                memory.setInt(relocationAddress, newValue, instructionBigEndian);
                break;
            }
            case 2: {
                if (elfRelocationContext.extractAddend()) {
                    addend = memory.getInt(relocationAddress);
                }
                newValue = (int)(symbolValue + addend);
                if (isThumb) {
                    newValue |= 1;
                }
                memory.setInt(relocationAddress, newValue);
                if (addend == 0L) break;
                ARM_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)elfRelocationContext.getLog());
                ARM_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case 3: {
                if (elfRelocationContext.extractAddend()) {
                    addend = memory.getInt(relocationAddress);
                }
                newValue = (int)(symbolValue + addend);
                newValue = (int)((long)newValue - offset);
                if (isThumb) {
                    newValue |= 1;
                }
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 42: {
                int oldValue = memory.getInt(relocationAddress);
                if (elfRelocationContext.extractAddend()) {
                    addend = oldValue << 1 >> 1;
                }
                newValue = (int)(symbolValue + addend);
                newValue = (int)((long)newValue - offset);
                if (isThumb) {
                    newValue |= 1;
                }
                newValue = (newValue & Integer.MAX_VALUE) + (oldValue & Integer.MIN_VALUE);
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 4: {
                int oldValue = memory.getInt(relocationAddress, instructionBigEndian);
                newValue = (int)(symbolValue + addend);
                newValue = (int)((long)newValue - (offset + (long)elfRelocationContext.getPcBias(false)));
                newValue = oldValue & 0xFF7FF000 | (~(newValue >> 31) & 1) << 23 | newValue >> 2 & 0xFFF;
                memory.setInt(relocationAddress, newValue, instructionBigEndian);
                break;
            }
            case 5: {
                short sValue = (short)(symbolValue + addend);
                memory.setShort(relocationAddress, sValue);
                break;
            }
            case 6: {
                int oldValue = memory.getInt(relocationAddress, instructionBigEndian);
                newValue = (int)(symbolValue + addend);
                newValue = oldValue & 0xFFFFF000 | newValue & 0xFFF;
                memory.setInt(relocationAddress, newValue, instructionBigEndian);
                break;
            }
            case 8: {
                byte bValue = (byte)(symbolValue + addend);
                memory.setByte(relocationAddress, bValue);
                break;
            }
            case 10: 
            case 30: {
                newValue = (int)(symbolValue + addend);
                newValue = (int)((long)newValue - offset);
                short oldValueH = memory.getShort(relocationAddress, instructionBigEndian);
                short oldValueL = memory.getShort(relocationAddress.add(2L), instructionBigEndian);
                boolean isBLX = (oldValueL & 0x1000) == 0;
                int s = (oldValueH & 0x400) >> 10;
                int upper = oldValueH & 0x3FF;
                int lower = oldValueL & 0x7FF;
                int j1 = (oldValueL & 0x2000) >> 13;
                int j2 = (oldValueL & 0x800) >> 11;
                int i1 = j1 != s ? 0 : 1;
                int i2 = j2 != s ? 0 : 1;
                int origaddend = i1 << 23 | i2 << 22 | upper << 12 | lower << 1;
                origaddend = (origaddend | (s ^ 1) << 24) - 0x1000000;
                newValue += origaddend;
                short newValueH = (short)(oldValueH & 0xF800 | (newValue >>= 1) >> 11 & 0x7FF);
                short newValueL = (short)(oldValueL & 0xF800 | newValue & 0x7FF);
                if (isBLX) {
                    newValueL = (short)(newValueL & 0xFFFE);
                }
                memory.setShort(relocationAddress, newValueH, instructionBigEndian);
                memory.setShort(relocationAddress.add(2L), newValueL, instructionBigEndian);
                break;
            }
            case 11: {
                short oldValue = memory.getShort(relocationAddress, instructionBigEndian);
                newValue = (int)(symbolValue + addend);
                newValue = (int)((long)newValue - (offset + (long)elfRelocationContext.getPcBias(true)));
                short sValue = (short)(oldValue & 0xFF00 | (newValue >>= 1) & 0xFF);
                memory.setShort(relocationAddress, sValue, instructionBigEndian);
                break;
            }
            case 21: {
                if (elfRelocationContext.extractAddend()) {
                    addend = memory.getInt(relocationAddress);
                }
                newValue = (int)(symbolValue + addend);
                if (isThumb) {
                    newValue |= 1;
                }
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 22: {
                Function extFunction;
                boolean isExternalSym;
                Address symAddress = elfRelocationContext.getSymbolAddress(sym);
                MemoryBlock block = memory.getBlock(symAddress);
                boolean isPltSym = block != null && block.getName().startsWith(".plt");
                boolean bl = isExternalSym = block != null && "EXTERNAL".equals(block.getName());
                if (!isPltSym) {
                    memory.setInt(relocationAddress, (int)symAddress.getOffset());
                }
                if (!isPltSym && !isExternalSym || (extFunction = elfRelocationContext.getLoadHelper().createExternalFunctionLinkage(symbolName, symAddress, null)) != null) break;
                ARM_ElfRelocationHandler.markAsError((Program)program, (Address)relocationAddress, (String)"R_ARM_JUMP_SLOT", (String)symbolName, (String)"Failed to create R_ARM_JUMP_SLOT external function", (MessageLog)elfRelocationContext.getLog());
                return;
            }
            case 23: {
                if (elfRelocationContext.extractAddend()) {
                    addend = memory.getInt(relocationAddress);
                }
                newValue = (int)elfRelocationContext.getImageBaseWordAdjustmentOffset() + (int)addend;
                memory.setInt(relocationAddress, newValue);
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                int oldValue = memory.getInt(relocationAddress, instructionBigEndian);
                if (elfRelocationContext.extractAddend()) {
                    addend = oldValue << 8 >> 6;
                }
                newValue = (int)(symbolValue + addend);
                newValue = (int)((long)newValue - (offset + (long)elfRelocationContext.getPcBias(false)));
                newValue = (oldValue & 0xFF000000) == -83886080 ? oldValue & 0xFE000000 | (newValue >> 1 & 1) << 24 | newValue >> 2 & 0xFFFFFF : oldValue & 0xFF000000 | newValue >> 2 & 0xFFFFFF;
                memory.setInt(relocationAddress, newValue, instructionBigEndian);
                break;
            }
            case 43: 
            case 44: {
                int oldValue;
                newValue = oldValue = memory.getInt(relocationAddress, instructionBigEndian);
                oldValue = (oldValue & 0xF0000) >> 4 | oldValue & 0xFFF;
                oldValue = (oldValue ^ 0x8000) - 32768;
                oldValue = (int)((long)oldValue + symbolValue);
                if (type == 44) {
                    oldValue >>= 16;
                }
                newValue &= 0xFFF0F000;
                memory.setInt(relocationAddress, newValue |= (oldValue & 0xF000) << 4 | oldValue & 0xFFF, instructionBigEndian);
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 87: 
            case 88: 
            case 89: {
                int oldValue = memory.getShort(relocationAddress, instructionBigEndian) << 16;
                oldValue |= memory.getShort(relocationAddress.add(2L), instructionBigEndian);
                if (elfRelocationContext.extractAddend()) {
                    addend = oldValue >> 4 & 0xF000;
                    addend |= (long)(oldValue >> 15 & 0x800);
                    addend |= (long)(oldValue >> 4 & 0x700);
                    addend |= (long)(oldValue & 0xFF);
                    addend = (addend ^ 0x8000L) - 32768L;
                }
                int value = (int)(symbolValue + addend);
                if (type == 49 || type == 50) {
                    value = (int)((long)value - (offset + (long)elfRelocationContext.getPcBias(true)));
                }
                if (type == 48 || type == 50 || type == 88) {
                    value >>= 16;
                }
                newValue = oldValue & 0xFBF08F00;
                newValue |= (value & 0xF000) << 4;
                newValue |= (value & 0x800) << 15;
                newValue |= (value & 0x700) << 4;
                memory.setShort(relocationAddress, (short)((newValue |= value & 0xFF) >> 16), instructionBigEndian);
                memory.setShort(relocationAddress.add(2L), (short)newValue, instructionBigEndian);
                break;
            }
            case 102: {
                short oldValue = memory.getShort(relocationAddress, instructionBigEndian);
                if (elfRelocationContext.extractAddend()) {
                    addend = oldValue << 21 >> 20;
                }
                newValue = (int)(symbolValue + addend);
                newValue = (int)((long)newValue - (offset + (long)elfRelocationContext.getPcBias(true)));
                newValue = oldValue & 0xF800 | newValue >> 1 & 0x7FF;
                memory.setShort(relocationAddress, (short)newValue, instructionBigEndian);
                break;
            }
            case 103: {
                short oldValue = memory.getShort(relocationAddress, instructionBigEndian);
                if (elfRelocationContext.extractAddend()) {
                    addend = oldValue << 24 >> 23;
                }
                newValue = (int)(symbolValue + addend);
                newValue = (int)((long)newValue - (offset + (long)elfRelocationContext.getPcBias(true)));
                newValue = oldValue & 0xFF00 | newValue >> 1 & 0xFF;
                memory.setShort(relocationAddress, (short)newValue, instructionBigEndian);
                break;
            }
            case 20: {
                ARM_ElfRelocationHandler.markAsWarning((Program)program, (Address)relocationAddress, (String)"R_ARM_COPY", (String)symbolName, (long)symbolIndex, (String)"Runtime copy not supported", (MessageLog)elfRelocationContext.getLog());
                break;
            }
            default: {
                ARM_ElfRelocationHandler.markAsUnhandled((Program)program, (Address)relocationAddress, (long)type, (long)symbolIndex, (String)symbolName, (MessageLog)elfRelocationContext.getLog());
            }
        }
    }

    private boolean isThumb(ElfSymbol symbol) {
        return symbol != null && symbol.isFunction() && symbol.getValue() % 1L == 1L;
    }
}

