/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.cmd;

import SWIG.SBTarget;
import agent.lldb.manager.LldbCause;
import agent.lldb.manager.cmd.AbstractLldbCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.impl.LldbManagerImpl;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class LldbListSessionsCommand
extends AbstractLldbCommand<Map<String, SBTarget>> {
    private Map<String, SBTarget> updatedSessions;

    public LldbListSessionsCommand(LldbManagerImpl manager) {
        super(manager);
    }

    @Override
    public Map<String, SBTarget> complete(LldbPendingCommand<?> pending) {
        Map<String, SBTarget> allSessions = this.manager.getKnownSessions();
        Set<String> cur = allSessions.keySet();
        for (String id : this.updatedSessions.keySet()) {
            if (cur.contains(id)) continue;
            this.manager.addSessionIfAbsent(this.updatedSessions.get(id));
        }
        for (String id : new ArrayList<String>(cur)) {
            if (this.updatedSessions.containsKey(id)) continue;
            this.manager.removeSession(id, LldbCause.Causes.UNCLAIMED);
        }
        return allSessions;
    }

    @Override
    public void invoke() {
        this.updatedSessions = this.manager.getClient().listSessions();
    }
}

