/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.debughost;

import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.debughost.DebugHostContext;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostMemoryInternal;
import agent.dbgmodel.jna.dbgmodel.DbgModelNative;
import agent.dbgmodel.jna.dbgmodel.debughost.IDebugHostMemory1;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public class DebugHostMemoryImpl1
implements DebugHostMemoryInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IDebugHostMemory1 jnaData;

    public DebugHostMemoryImpl1(IDebugHostMemory1 jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    @Override
    public long readBytes(DebugHostContext context, DbgModelNative.LOCATION location, ByteBuffer buffer, long bufferSize) {
        if (bufferSize > (long)buffer.remaining()) {
            throw new BufferOverflowException();
        }
        Pointer pContext = context.getPointer();
        WinDef.ULONGLONG pulBufferSize = new WinDef.ULONGLONG(bufferSize);
        WinDef.ULONGLONGByReference pulBytesRead = new WinDef.ULONGLONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.ReadBytes(pContext, location, buffer, pulBufferSize, pulBytesRead));
        long read = pulBytesRead.getValue().longValue();
        buffer.position((int)(read + (long)buffer.position()));
        return read;
    }

    @Override
    public long writeBytes(DebugHostContext context, DbgModelNative.LOCATION location, ByteBuffer buffer, long bufferSize) {
        if (bufferSize > (long)buffer.remaining()) {
            throw new BufferOverflowException();
        }
        Pointer pContext = context.getPointer();
        WinDef.ULONGLONG pulBufferSize = new WinDef.ULONGLONG(bufferSize);
        WinDef.ULONGLONGByReference pulBytesWritten = new WinDef.ULONGLONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.WriteBytes(pContext, location, buffer, pulBufferSize, pulBytesWritten));
        long written = pulBytesWritten.getValue().longValue();
        buffer.position((int)(written + (long)buffer.position()));
        return written;
    }

    @Override
    public WinDef.ULONGLONGByReference readPointers(DebugHostContext context, DbgModelNative.LOCATION location, long count) {
        Pointer pContext = context.getPointer();
        WinDef.ULONGLONG pCount = new WinDef.ULONGLONG(count);
        WinDef.ULONGLONGByReference pPointers = new WinDef.ULONGLONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.ReadPointers(pContext, location, pCount, pPointers));
        return pPointers;
    }

    @Override
    public WinDef.ULONGLONGByReference writePointers(DebugHostContext context, DbgModelNative.LOCATION location, long count) {
        Pointer pContext = context.getPointer();
        WinDef.ULONGLONG pCount = new WinDef.ULONGLONG(count);
        WinDef.ULONGLONGByReference pPointers = new WinDef.ULONGLONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.WritePointers(pContext, location, pCount, pPointers));
        return pPointers;
    }

    @Override
    public String GetDisplayStringForLocation(DebugHostContext context, DbgModelNative.LOCATION location, boolean verbose) {
        Pointer pContext = context.getPointer();
        WinDef.BOOL bVerbose = new WinDef.BOOL(verbose);
        WTypes.BSTRByReference bref = new WTypes.BSTRByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetDisplayStringForLocation(pContext, location, bVerbose, bref));
        WTypes.BSTR bstr = bref.getValue();
        String locationName = bstr.getValue();
        OleAuto.INSTANCE.SysFreeString(bstr);
        return locationName;
    }
}

