/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.main;

import agent.dbgmodel.dbgmodel.COMUtilsExtra;
import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.UnknownEx;
import agent.dbgmodel.dbgmodel.concept.Concept;
import agent.dbgmodel.dbgmodel.concept.IndexableConcept;
import agent.dbgmodel.dbgmodel.concept.IterableConcept;
import agent.dbgmodel.dbgmodel.concept.StringDisplayableConcept;
import agent.dbgmodel.dbgmodel.datamodel.DataModelManager1;
import agent.dbgmodel.dbgmodel.debughost.DebugHostContext;
import agent.dbgmodel.dbgmodel.debughost.DebugHostType1;
import agent.dbgmodel.dbgmodel.main.KeyEnumerator;
import agent.dbgmodel.dbgmodel.main.KeyStore;
import agent.dbgmodel.dbgmodel.main.ModelIterator;
import agent.dbgmodel.dbgmodel.main.ModelMethod;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.dbgmodel.main.RawEnumerator;
import agent.dbgmodel.impl.dbgmodel.UnknownExImpl;
import agent.dbgmodel.impl.dbgmodel.UnknownExInternal;
import agent.dbgmodel.impl.dbgmodel.concept.ComparableConceptInternal;
import agent.dbgmodel.impl.dbgmodel.concept.DataModelConceptInternal;
import agent.dbgmodel.impl.dbgmodel.concept.DynamicConceptProviderConceptInternal;
import agent.dbgmodel.impl.dbgmodel.concept.DynamicKeyProviderConceptInternal;
import agent.dbgmodel.impl.dbgmodel.concept.EquatableConceptInternal;
import agent.dbgmodel.impl.dbgmodel.concept.IndexableConceptInternal;
import agent.dbgmodel.impl.dbgmodel.concept.IterableConceptInternal;
import agent.dbgmodel.impl.dbgmodel.concept.PreferredRuntimeTypeConceptInternal;
import agent.dbgmodel.impl.dbgmodel.concept.StringDisplayableConceptInternal;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostContextInternal;
import agent.dbgmodel.impl.dbgmodel.debughost.DebugHostTypeInternal;
import agent.dbgmodel.impl.dbgmodel.main.KeyEnumeratorInternal;
import agent.dbgmodel.impl.dbgmodel.main.KeyStoreInternal;
import agent.dbgmodel.impl.dbgmodel.main.ModelMethodInternal;
import agent.dbgmodel.impl.dbgmodel.main.ModelObjectInternal;
import agent.dbgmodel.impl.dbgmodel.main.RawEnumeratorInternal;
import agent.dbgmodel.jna.dbgmodel.DbgModelNative;
import agent.dbgmodel.jna.dbgmodel.IUnknownEx;
import agent.dbgmodel.jna.dbgmodel.UnknownWithUtils;
import agent.dbgmodel.jna.dbgmodel.WrapIUnknownEx;
import agent.dbgmodel.jna.dbgmodel.concept.IComparableConcept;
import agent.dbgmodel.jna.dbgmodel.concept.IDataModelConcept;
import agent.dbgmodel.jna.dbgmodel.concept.IDynamicConceptProviderConcept;
import agent.dbgmodel.jna.dbgmodel.concept.IDynamicKeyProviderConcept;
import agent.dbgmodel.jna.dbgmodel.concept.IEquatableConcept;
import agent.dbgmodel.jna.dbgmodel.concept.IIndexableConcept;
import agent.dbgmodel.jna.dbgmodel.concept.IIterableConcept;
import agent.dbgmodel.jna.dbgmodel.concept.IPreferredRuntimeTypeConcept;
import agent.dbgmodel.jna.dbgmodel.concept.IStringDisplayableConcept;
import agent.dbgmodel.jna.dbgmodel.concept.WrapIComparableConcept;
import agent.dbgmodel.jna.dbgmodel.concept.WrapIDataModelConcept;
import agent.dbgmodel.jna.dbgmodel.concept.WrapIDynamicConceptProviderConcept;
import agent.dbgmodel.jna.dbgmodel.concept.WrapIDynamicKeyProviderConcept;
import agent.dbgmodel.jna.dbgmodel.concept.WrapIEquatableConcept;
import agent.dbgmodel.jna.dbgmodel.concept.WrapIIndexableConcept;
import agent.dbgmodel.jna.dbgmodel.concept.WrapIIterableConcept;
import agent.dbgmodel.jna.dbgmodel.concept.WrapIPreferredRuntimeTypeConcept;
import agent.dbgmodel.jna.dbgmodel.concept.WrapIStringDisplayableConcept;
import agent.dbgmodel.jna.dbgmodel.debughost.WrapIDebugHostContext;
import agent.dbgmodel.jna.dbgmodel.debughost.WrapIDebugHostType1;
import agent.dbgmodel.jna.dbgmodel.main.IModelObject;
import agent.dbgmodel.jna.dbgmodel.main.WrapIKeyEnumerator;
import agent.dbgmodel.jna.dbgmodel.main.WrapIKeyStore;
import agent.dbgmodel.jna.dbgmodel.main.WrapIModelObject;
import agent.dbgmodel.jna.dbgmodel.main.WrapIRawEnumerator;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ModelObjectImpl
implements ModelObjectInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IModelObject jnaData;
    private KeyStore metadata;
    private ModelObject contextObject;
    private DbgModelNative.LOCATION targetLocation;
    private ModelObject indexer;
    private String key;

    public ModelObjectImpl(IModelObject jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public IModelObject getJnaData() {
        return this.jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostContext getContext() {
        PointerByReference ppContext = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetContext(ppContext));
        Pointer value = ppContext.getValue();
        if (value == null) {
            return null;
        }
        WrapIDebugHostContext wrap = new WrapIDebugHostContext(value);
        try {
            DebugHostContextInternal debugHostContextInternal = DebugHostContextInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostContextInternal;
        }
        finally {
            wrap.Release();
        }
    }

    @Override
    public DbgModelNative.ModelObjectKind getKind() {
        try {
            WinDef.ULONGByReference pulKind = new WinDef.ULONGByReference();
            COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetKind(pulKind));
            int i = pulKind.getValue().intValue();
            return DbgModelNative.ModelObjectKind.values()[i];
        }
        catch (Exception e) {
            System.err.println("GetKind error " + this.getSearchKey() + ":" + e);
            return DbgModelNative.ModelObjectKind.OBJECT_ERROR;
        }
    }

    @Override
    public Object getIntrinsicValue() {
        Variant.VARIANT.ByReference pIntrinsicData = new Variant.VARIANT.ByReference();
        WinNT.HRESULT hr = this.jnaData.GetIntrinsicValue(pIntrinsicData);
        if (hr.equals((Object)COMUtilsExtra.E_FAIL)) {
            return null;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        return pIntrinsicData.getValue();
    }

    @Override
    public Variant.VARIANT getIntrinsicValueAs(WTypes.VARTYPE vt) {
        Variant.VARIANT.ByReference pIntrinsicData = new Variant.VARIANT.ByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetIntrinsicValueAs(vt, pIntrinsicData));
        return (Variant.VARIANT)pIntrinsicData.getValue();
    }

    @Override
    public ModelObject getKeyValue(String searchKey) {
        PointerByReference ppObject = new PointerByReference();
        PointerByReference ppMetadata = new PointerByReference();
        WinNT.HRESULT hr = this.jnaData.GetKeyValue(new WString(searchKey), ppObject, ppMetadata);
        if (!hr.equals((Object)new WinNT.HRESULT(0)) && (searchKey.equals("Parameters") || searchKey.equals("LocalVariables"))) {
            return null;
        }
        if (hr.equals((Object)COMUtilsExtra.E_FAIL)) {
            System.err.println(searchKey + " failed");
            return null;
        }
        if (hr.equals((Object)COMUtilsExtra.E_BOUNDS)) {
            System.err.println(searchKey + " out of bounds");
            return null;
        }
        if (hr.equals((Object)COMUtilsExtra.E_INVALID_PARAM)) {
            Msg.debug((Object)this, (Object)(searchKey + " invalid param"));
            return null;
        }
        if (hr.equals((Object)COMUtilsExtra.E_SCOPE_NOT_FOUND)) {
            Msg.debug((Object)this, (Object)(searchKey + " scope not found"));
            return null;
        }
        if (hr.equals((Object)COMUtilsExtra.E_CANNOT_READ)) {
            Msg.debug((Object)this, (Object)(searchKey + " cannot be read"));
            return null;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        ModelObject retval = ModelObjectImpl.getObjectWithMetadata(ppObject, ppMetadata);
        retval.setSearchKey(searchKey);
        return retval;
    }

    @Override
    public void setKeyValue(WString key, ModelObject object) {
        Pointer pObject = object.getPointer();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.SetKeyValue(key, pObject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyEnumerator enumerateKeyValues() {
        PointerByReference ppEnumerator = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.EnumerateKeyValues(ppEnumerator));
        WrapIKeyEnumerator wrap = new WrapIKeyEnumerator(ppEnumerator.getValue());
        try {
            KeyEnumeratorInternal keyEnumeratorInternal = KeyEnumeratorInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return keyEnumeratorInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelObject getRawValue(int kind, WString name, int searchFlags) {
        WinDef.ULONG ulKind = new WinDef.ULONG((long)kind);
        WinDef.ULONG ulSearchFlags = new WinDef.ULONG((long)searchFlags);
        PointerByReference ppObject = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetRawValue(ulKind, name, ulSearchFlags, ppObject));
        WrapIModelObject wrap = new WrapIModelObject(ppObject.getValue());
        try {
            ModelObjectInternal modelObjectInternal = ModelObjectInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return modelObjectInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawEnumerator enumerateRawValues(int kind, int searchFlags) {
        WinDef.ULONG ulKind = new WinDef.ULONG((long)kind);
        WinDef.ULONG ulSearchFlags = new WinDef.ULONG((long)searchFlags);
        PointerByReference ppEnumerator = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.EnumerateRawValues(ulKind, ulSearchFlags, ppEnumerator));
        WrapIRawEnumerator wrap = new WrapIRawEnumerator(ppEnumerator.getValue());
        try {
            RawEnumeratorInternal rawEnumeratorInternal = RawEnumeratorInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return rawEnumeratorInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelObject dereference() {
        PointerByReference ppObject = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.Dereference(ppObject));
        WrapIModelObject wrap = new WrapIModelObject(ppObject.getValue());
        try {
            ModelObjectInternal modelObjectInternal = ModelObjectInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return modelObjectInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelObject tryCastToRuntimeType() {
        PointerByReference ppRuntimeTypedObject = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.TryCastToRuntimeType(ppRuntimeTypedObject));
        WrapIModelObject wrap = new WrapIModelObject(ppRuntimeTypedObject.getValue());
        try {
            ModelObjectInternal modelObjectInternal = ModelObjectInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return modelObjectInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Concept getConcept(Guid.REFIID conceptId) {
        UnknownWithUtils wrap;
        PointerByReference ppConceptInterface = new PointerByReference();
        PointerByReference ppConceptMetadata = new PointerByReference();
        WinNT.HRESULT hr = this.jnaData.GetConcept(conceptId, ppConceptInterface, ppConceptMetadata);
        if (hr.equals((Object)COMUtilsExtra.E_NOINTERFACE)) {
            return null;
        }
        COMUtils.checkRC((WinNT.HRESULT)hr);
        Concept object = null;
        KeyStoreInternal mdata = null;
        Pointer value = ppConceptMetadata.getValue();
        if (value != null) {
            WrapIKeyStore wrap1 = new WrapIKeyStore(value);
            try {
                mdata = KeyStoreInternal.tryPreferredInterfaces(wrap1::QueryInterface);
            }
            finally {
                wrap1.Release();
            }
        }
        if (conceptId.getValue().equals((Object)IStringDisplayableConcept.IID_ISTRING_DISPLAYABLE_CONCEPT)) {
            wrap = new WrapIStringDisplayableConcept(ppConceptInterface.getValue());
            try {
                object = StringDisplayableConceptInternal.tryPreferredInterfaces(((WrapIStringDisplayableConcept)wrap)::QueryInterface);
            }
            finally {
                wrap.Release();
            }
        }
        if (conceptId.getValue().equals((Object)IPreferredRuntimeTypeConcept.IID_IPREFERRED_RUNTIME_TYPE_CONCEPT)) {
            wrap = new WrapIPreferredRuntimeTypeConcept(ppConceptInterface.getValue());
            try {
                object = PreferredRuntimeTypeConceptInternal.tryPreferredInterfaces(((WrapIPreferredRuntimeTypeConcept)wrap)::QueryInterface);
            }
            finally {
                wrap.Release();
            }
        }
        if (conceptId.getValue().equals((Object)IIterableConcept.IID_IITERABLE_CONCEPT)) {
            wrap = new WrapIIterableConcept(ppConceptInterface.getValue());
            try {
                object = IterableConceptInternal.tryPreferredInterfaces(((WrapIIterableConcept)wrap)::QueryInterface);
            }
            finally {
                wrap.Release();
            }
        }
        if (conceptId.getValue().equals((Object)IIndexableConcept.IID_IINDEXABLE_CONCEPT)) {
            wrap = new WrapIIndexableConcept(ppConceptInterface.getValue());
            try {
                object = IndexableConceptInternal.tryPreferredInterfaces(((WrapIIndexableConcept)wrap)::QueryInterface);
            }
            finally {
                wrap.Release();
            }
        }
        if (conceptId.getValue().equals((Object)IEquatableConcept.IID_IEQUATABLE_CONCEPT)) {
            wrap = new WrapIEquatableConcept(ppConceptInterface.getValue());
            try {
                object = EquatableConceptInternal.tryPreferredInterfaces(((WrapIEquatableConcept)wrap)::QueryInterface);
            }
            finally {
                wrap.Release();
            }
        }
        if (conceptId.getValue().equals((Object)IDynamicKeyProviderConcept.IID_IDYNAMIC_KEY_PROVIDER_CONCEPT)) {
            wrap = new WrapIDynamicKeyProviderConcept(ppConceptInterface.getValue());
            try {
                object = DynamicKeyProviderConceptInternal.tryPreferredInterfaces(((WrapIDynamicKeyProviderConcept)wrap)::QueryInterface);
            }
            finally {
                wrap.Release();
            }
        }
        if (conceptId.getValue().equals((Object)IDynamicConceptProviderConcept.IID_IDYNAMIC_CONCEPT_PROVIDER_CONCEPT)) {
            wrap = new WrapIDynamicConceptProviderConcept(ppConceptInterface.getValue());
            try {
                object = DynamicConceptProviderConceptInternal.tryPreferredInterfaces(((WrapIDynamicConceptProviderConcept)wrap)::QueryInterface);
            }
            finally {
                wrap.Release();
            }
        }
        if (conceptId.getValue().equals((Object)IDataModelConcept.IID_IDATA_MODEL_CONCEPT)) {
            wrap = new WrapIDataModelConcept(ppConceptInterface.getValue());
            try {
                object = DataModelConceptInternal.tryPreferredInterfaces(((WrapIDataModelConcept)wrap)::QueryInterface);
            }
            finally {
                wrap.Release();
            }
        }
        if (conceptId.getValue().equals((Object)IComparableConcept.IID_ICOMPARABLE_CONCEPT)) {
            wrap = new WrapIComparableConcept(ppConceptInterface.getValue());
            try {
                object = ComparableConceptInternal.tryPreferredInterfaces(((WrapIComparableConcept)wrap)::QueryInterface);
            }
            finally {
                wrap.Release();
            }
        }
        if (object != null && mdata != null) {
            object.setMetadata(mdata);
        }
        return object;
    }

    @Override
    public DbgModelNative.LOCATION getLocation() {
        DbgModelNative.LOCATION.ByReference pLocation = new DbgModelNative.LOCATION.ByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetLocation(pLocation));
        return new DbgModelNative.LOCATION(pLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostType1 getTypeInfo() {
        PointerByReference ppType = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetTypeInfo(ppType));
        Pointer value = ppType.getValue();
        if (value == null) {
            return null;
        }
        WrapIDebugHostType1 wrap = new WrapIDebugHostType1(value);
        try {
            DebugHostTypeInternal debugHostTypeInternal = DebugHostTypeInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostTypeInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugHostType1 getTargetInfo() {
        DbgModelNative.LOCATION.ByReference pLocation = new DbgModelNative.LOCATION.ByReference();
        PointerByReference ppType = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetTargetInfo(pLocation, ppType));
        this.targetLocation = new DbgModelNative.LOCATION(pLocation);
        Pointer value = ppType.getValue();
        if (value == null) {
            return null;
        }
        WrapIDebugHostType1 wrap = new WrapIDebugHostType1(value);
        try {
            DebugHostTypeInternal debugHostTypeInternal = DebugHostTypeInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return debugHostTypeInternal;
        }
        finally {
            wrap.Release();
        }
    }

    @Override
    public long getNumberOfParentModels() {
        WinDef.ULONGLONGByReference pulNumModels = new WinDef.ULONGLONGByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetNumberOfParentModels(pulNumModels));
        return pulNumModels.getValue().longValue();
    }

    @Override
    public ModelObject getParentModel(int i) {
        WinDef.ULONG ulI = new WinDef.ULONG((long)i);
        PointerByReference ppModel = new PointerByReference();
        PointerByReference ppContextObject = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetParentModel(ulI, ppModel, ppContextObject));
        return ModelObjectImpl.getObjectWithContext(ppModel, ppContextObject);
    }

    @Override
    public void addParentModel(ModelObject model, ModelObject contextObject, boolean override) {
        Pointer pModel = model.getPointer();
        Pointer pContextObject = contextObject.getPointer();
        WinDef.BOOL bOverride = new WinDef.BOOL(override);
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.AddParentModel(pModel, pContextObject, bOverride));
    }

    @Override
    public void removeParentModel(ModelObject model) {
        Pointer pModel = model.getPointer();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.RemoveParentModel(pModel));
    }

    @Override
    public ModelObject getKey(String searchKey) {
        WString kstr = new WString(searchKey);
        PointerByReference ppObject = new PointerByReference();
        PointerByReference ppMetadata = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetKey(kstr, ppObject, ppMetadata));
        ModelObject retval = ModelObjectImpl.getObjectWithMetadata(ppObject, ppMetadata);
        retval.setSearchKey(this.key);
        return retval;
    }

    @Override
    public ModelObject getKeyReference(String searchKey) {
        WString kstr = new WString(searchKey);
        PointerByReference ppObjectReference = new PointerByReference();
        PointerByReference ppMetadata = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetKeyReference(kstr, ppObjectReference, ppMetadata));
        ModelObject retval = ModelObjectImpl.getObjectWithMetadata(ppObjectReference, ppMetadata);
        retval.setSearchKey(this.key);
        return retval;
    }

    @Override
    public void setKey(WString key, ModelObject object, KeyStore conceptMetadata) {
        Pointer pObject = object.getPointer();
        Pointer pMetadata = conceptMetadata.getPointer();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.SetKey(key, pObject, pMetadata));
    }

    @Override
    public void clearKeys() {
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.ClearKeys());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyEnumerator enumerateKeys() {
        PointerByReference ppEnumerator = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.EnumerateKeys(ppEnumerator));
        WrapIKeyEnumerator wrap = new WrapIKeyEnumerator(ppEnumerator.getValue());
        try {
            KeyEnumeratorInternal keyEnumeratorInternal = KeyEnumeratorInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return keyEnumeratorInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyEnumerator enumerateKeyReferences() {
        PointerByReference ppEnumerator = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.EnumerateKeyReferences(ppEnumerator));
        WrapIKeyEnumerator wrap = new WrapIKeyEnumerator(ppEnumerator.getValue());
        try {
            KeyEnumeratorInternal keyEnumeratorInternal = KeyEnumeratorInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return keyEnumeratorInternal;
        }
        finally {
            wrap.Release();
        }
    }

    @Override
    public void setConcept(Guid.REFIID conceptId, ModelObject conceptInterface, ModelObject conceptMetadata) {
        Pointer pConceptInterface = conceptInterface.getPointer();
        Pointer pConceptMetadata = conceptMetadata.getPointer();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.SetConcept(conceptId, pConceptInterface, pConceptMetadata));
    }

    @Override
    public void clearConcepts() {
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.ClearConcepts());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelObject getRawReference(int kind, WString name, int searchFlags) {
        WinDef.ULONG ulKind = new WinDef.ULONG((long)kind);
        WinDef.ULONG ulSearchFlags = new WinDef.ULONG((long)searchFlags);
        PointerByReference ppObject = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetRawValue(ulKind, name, ulSearchFlags, ppObject));
        WrapIModelObject wrap = new WrapIModelObject(ppObject.getValue());
        try {
            ModelObjectInternal modelObjectInternal = ModelObjectInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return modelObjectInternal;
        }
        finally {
            wrap.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawEnumerator enumerateRawReferences(int kind, int searchFlags) {
        WinDef.ULONG ulKind = new WinDef.ULONG((long)kind);
        WinDef.ULONG ulSearchFlags = new WinDef.ULONG((long)searchFlags);
        PointerByReference ppEnumerator = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.EnumerateRawValues(ulKind, ulSearchFlags, ppEnumerator));
        WrapIRawEnumerator wrap = new WrapIRawEnumerator(ppEnumerator.getValue());
        try {
            RawEnumeratorInternal rawEnumeratorInternal = RawEnumeratorInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return rawEnumeratorInternal;
        }
        finally {
            wrap.Release();
        }
    }

    @Override
    public void setContextForDataModel(ModelObject dataModelObject, IUnknownEx context) {
        Pointer pDataModelObject = dataModelObject.getPointer();
        Pointer pContext = context.getPointer();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.SetContextForDataModel(pDataModelObject, pContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnknownEx getContextForDataModel(ModelObject dataModelObject) {
        Pointer pDataModelObject = dataModelObject.getPointer();
        PointerByReference ppContext = new PointerByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetContextForDataModel(pDataModelObject, ppContext));
        WrapIUnknownEx wrap = new WrapIUnknownEx(ppContext.getValue());
        try {
            UnknownExInternal unknownExInternal = UnknownExInternal.tryPreferredInterfaces(wrap::QueryInterface);
            return unknownExInternal;
        }
        finally {
            wrap.Release();
        }
    }

    @Override
    public boolean compare(ModelObject contextObject, ModelObject other) {
        Pointer pOther = other.getPointer();
        WinDef.BOOLByReference bEqual = new WinDef.BOOLByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.Compare(pOther, bEqual));
        return bEqual.getValue().booleanValue();
    }

    @Override
    public KeyStore getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(KeyStore metadata) {
        this.metadata = metadata;
    }

    public ModelObject getContextObject() {
        return this.contextObject;
    }

    @Override
    public void setContextObject(ModelObject context) {
        this.contextObject = context;
    }

    public DbgModelNative.LOCATION getTargetLocation() {
        return this.targetLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelObject getObjectWithContext(PointerByReference ppObject, PointerByReference ppContext) {
        WrapIModelObject wrap0 = new WrapIModelObject(ppObject.getValue());
        try {
            ModelObjectInternal object = ModelObjectInternal.tryPreferredInterfaces(wrap0::QueryInterface);
            WrapIModelObject wrap1 = new WrapIModelObject(ppContext.getValue());
            try {
                ModelObjectInternal context = ModelObjectInternal.tryPreferredInterfaces(wrap1::QueryInterface);
                object.setContextObject(context);
            }
            finally {
                wrap1.Release();
            }
            ModelObjectInternal modelObjectInternal = object;
            return modelObjectInternal;
        }
        finally {
            wrap0.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelObject getObjectWithMetadata(PointerByReference ppObject, PointerByReference ppMetadata) {
        WrapIModelObject wrap0 = new WrapIModelObject(ppObject.getValue());
        try {
            ModelObjectInternal object = ModelObjectInternal.tryPreferredInterfaces(wrap0::QueryInterface);
            Pointer value = ppMetadata.getValue();
            if (value != null) {
                WrapIKeyStore wrap1 = new WrapIKeyStore(value);
                try {
                    KeyStoreInternal mdata = KeyStoreInternal.tryPreferredInterfaces(wrap1::QueryInterface);
                    object.setMetadata(mdata);
                }
                finally {
                    wrap1.Release();
                }
            }
            ModelObjectInternal modelObjectInternal = object;
            return modelObjectInternal;
        }
        finally {
            wrap0.Release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UnknownEx getUnknownWithMetadata(PointerByReference ppObject, PointerByReference ppMetadata) {
        WrapIUnknownEx wrap0 = new WrapIUnknownEx(ppObject.getValue());
        try {
            UnknownExInternal object = UnknownExInternal.tryPreferredInterfaces(wrap0::QueryInterface);
            Pointer value = ppMetadata.getValue();
            if (value != null) {
                WrapIKeyStore wrap1 = new WrapIKeyStore(value);
                try {
                    KeyStoreInternal mdata = KeyStoreInternal.tryPreferredInterfaces(wrap1::QueryInterface);
                    ((UnknownExImpl)object).setMetadata(mdata);
                }
                finally {
                    wrap1.Release();
                }
            }
            UnknownExInternal unknownExInternal = object;
            return unknownExInternal;
        }
        finally {
            wrap0.Release();
        }
    }

    @Override
    public List<ModelObject> getElements() {
        ArrayList<ModelObject> list = new ArrayList<ModelObject>();
        Guid.REFIID ref = new Guid.REFIID(IIterableConcept.IID_IITERABLE_CONCEPT);
        IterableConcept concept = (IterableConcept)this.getConcept(ref);
        if (concept == null) {
            return list;
        }
        ModelIterator iterator = concept.getIterator(this);
        if (iterator != null) {
            ModelObject next;
            int i = 0;
            while ((next = iterator.getNext(1L)) != null) {
                ModelObject index = iterator.getIndexers();
                if (index != null) {
                    next.setIndexer(index);
                } else {
                    next.setSearchKey(Integer.toHexString(i));
                }
                list.add(next);
                ++i;
            }
        }
        return list;
    }

    @Override
    public ModelObject getChild(DataModelManager1 manager, Variant.VARIANT v) {
        Guid.REFIID ref = new Guid.REFIID(IIndexableConcept.IID_IINDEXABLE_CONCEPT);
        IndexableConcept indexable = (IndexableConcept)this.getConcept(ref);
        if (indexable == null) {
            return null;
        }
        long dimensionality = indexable.getDimensionality(this);
        Pointer[] ppIndexers = new Pointer[(int)dimensionality];
        Variant.VARIANT.ByReference vbr = new Variant.VARIANT.ByReference(v);
        ModelObject mo = manager.createIntrinsicObject(DbgModelNative.ModelObjectKind.OBJECT_INTRINSIC, vbr);
        ppIndexers[0] = mo.getPointer();
        return indexable.getAt(this, dimensionality, ppIndexers);
    }

    @Override
    public void switchTo(DataModelManager1 manager, Variant.VARIANT v) {
        Pointer[] args = new Pointer[1];
        Variant.VARIANT.ByReference vbr = new Variant.VARIANT.ByReference(v);
        ModelObject mo = manager.createIntrinsicObject(DbgModelNative.ModelObjectKind.OBJECT_INTRINSIC, vbr);
        args[0] = mo.getPointer();
        ModelMethod f = this.getMethod("SwitchTo");
        f.call(this, 1L, args);
    }

    @Override
    public Object getValue() {
        Object val = this.getIntrinsicValue();
        if (val instanceof WinDef.SHORT) {
            return ((WinDef.SHORT)val).shortValue();
        }
        if (val instanceof WinDef.USHORT) {
            return ((WinDef.USHORT)val).shortValue();
        }
        if (val instanceof WinDef.LONG) {
            return ((WinDef.LONG)val).intValue();
        }
        if (val instanceof WinDef.ULONG) {
            return ((WinDef.ULONG)val).intValue();
        }
        if (val instanceof WinDef.ULONGLONG) {
            return ((WinDef.ULONGLONG)val).longValue();
        }
        return val;
    }

    @Override
    public String getValueString() {
        Object val = this.getIntrinsicValue();
        if (val instanceof WinDef.SHORT) {
            return Integer.toHexString(((WinDef.SHORT)val).shortValue());
        }
        if (val instanceof WinDef.USHORT) {
            return Integer.toHexString(((WinDef.USHORT)val).shortValue());
        }
        if (val instanceof WinDef.LONG) {
            return Integer.toHexString(((WinDef.LONG)val).intValue());
        }
        if (val instanceof WinDef.ULONG) {
            return Integer.toHexString(((WinDef.ULONG)val).intValue());
        }
        if (val instanceof WinDef.ULONGLONG) {
            return Long.toHexString(((WinDef.ULONGLONG)val).longValue());
        }
        return val == null ? "" : val.toString();
    }

    public String toString() {
        Guid.REFIID ref = new Guid.REFIID(IStringDisplayableConcept.IID_ISTRING_DISPLAYABLE_CONCEPT);
        StringDisplayableConcept displayable = (StringDisplayableConcept)this.getConcept(ref);
        if (displayable == null) {
            return super.toString();
        }
        return displayable.toDisplayString(this, null);
    }

    @Override
    public synchronized Map<String, ModelObject> getKeyValueMap() {
        String kstr;
        TreeMap<String, ModelObject> map = new TreeMap<String, ModelObject>();
        KeyEnumerator enumerator = this.enumerateKeys();
        while ((kstr = enumerator.getNext()) != null) {
            ModelObject value = this.getKeyValue(kstr);
            if (value == null) continue;
            value.setSearchKey(kstr);
            map.put(kstr, value);
        }
        return map;
    }

    @Override
    public synchronized Map<String, ModelObject> getRawValueMap() {
        String kstr;
        TreeMap<String, ModelObject> map = new TreeMap<String, ModelObject>();
        DbgModelNative.TypeKind typeKind = this.getTypeKind();
        if (typeKind == null) {
            return map;
        }
        DbgModelNative.SymbolKind kind = null;
        switch (typeKind) {
            case TYPE_UDT: {
                kind = DbgModelNative.SymbolKind.SYMBOL_FIELD;
                break;
            }
            case TYPE_POINTER: {
                kind = DbgModelNative.SymbolKind.SYMBOL_BASE_CLASS;
                try {
                    ModelObject dereference = this.dereference();
                    return dereference.getRawValueMap();
                }
                catch (Exception e) {
                    kind = null;
                    break;
                }
            }
            case TYPE_INTRINSIC: 
            case TYPE_ARRAY: {
                break;
            }
            default: {
                System.err.println(this.getSearchKey() + ":" + typeKind);
            }
        }
        if (kind == null) {
            return map;
        }
        RawEnumerator enumerator = this.enumerateRawValues(kind.ordinal(), 0);
        while ((kstr = enumerator.getNext()) != null) {
            ModelObject value = enumerator.getValue();
            value.setSearchKey(kstr);
            map.put(kstr, value);
        }
        return map;
    }

    @Override
    public DbgModelNative.TypeKind getTypeKind() {
        DebugHostType1 typeInfo;
        DbgModelNative.ModelObjectKind modelKind = this.getKind();
        DbgModelNative.TypeKind typeKind = null;
        if (modelKind.equals((Object)DbgModelNative.ModelObjectKind.OBJECT_TARGET_OBJECT)) {
            DebugHostType1 targetInfo = this.getTargetInfo();
            typeKind = targetInfo.getTypeKind();
        }
        if (modelKind.equals((Object)DbgModelNative.ModelObjectKind.OBJECT_INTRINSIC) && (typeInfo = this.getTypeInfo()) != null) {
            typeKind = typeInfo.getTypeKind();
        }
        return typeKind;
    }

    @Override
    public ModelMethod getMethod(String name) {
        ModelObject m = this.getKeyValue(name);
        if (m == null || !m.getKind().equals((Object)DbgModelNative.ModelObjectKind.OBJECT_METHOD)) {
            return null;
        }
        Unknown unk = (Unknown)m.getIntrinsicValue();
        return ModelMethodInternal.tryPreferredInterfaces((arg_0, arg_1) -> ((Unknown)unk).QueryInterface(arg_0, arg_1));
    }

    @Override
    public ModelObject getIndexer() {
        return this.indexer;
    }

    @Override
    public void setIndexer(ModelObject indexer) {
        this.indexer = indexer;
        String str = "0x" + indexer.getValueString();
        if (!str.equals("")) {
            this.key = str;
        }
    }

    @Override
    public String getSearchKey() {
        if (this.key == null) {
            throw new RuntimeException("null key for " + this);
        }
        Map<String, ModelObject> map = this.getKeyValueMap();
        if (map.containsKey("BaseAddress")) {
            String valueString = map.get("BaseAddress").getValueString();
            return valueString;
        }
        if (map.containsKey("UniqueID") && map.containsKey("Id")) {
            String valueString = map.get("Id").getValueString();
            return valueString;
        }
        return this.key;
    }

    @Override
    public String getOriginalKey() {
        if (this.key == null) {
            throw new RuntimeException("null key for " + this);
        }
        return this.key;
    }

    @Override
    public void setSearchKey(String key) {
        this.key = key;
    }
}

