/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.algo;

import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import ghidra.graph.GraphAlgorithms;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class JohnsonCircuitsAlgorithm<V, E extends GEdge<V>> {
    public static final int JAVA_STACK_DEPTH_LIMIT = 2700;
    private GDirectedGraph<V, E> g;
    private GDirectedGraph<V, E> subGraph;
    private Stack<V> stack = new Stack();
    private V startVertex;
    private Set<V> blockedSet = new HashSet<V>();
    private Map<V, Set<V>> blockedBackEdgesMap = new HashMap<V, Set<V>>();
    private Accumulator<List<V>> accumulator;

    public JohnsonCircuitsAlgorithm(GDirectedGraph<V, E> g, Accumulator<List<V>> accumulator) {
        this.g = g;
        this.accumulator = accumulator;
    }

    public void compute(boolean uniqueCircuits, TaskMonitor monitor) throws CancelledException {
        Set<Set<V>> stronglyConnected = GraphAlgorithms.getStronglyConnectedComponents(this.g);
        for (Set<V> set : stronglyConnected) {
            if (set.size() < 2) continue;
            this.subGraph = GraphAlgorithms.createSubGraph(this.g, set);
            ArrayList<V> vertices = new ArrayList<V>(this.subGraph.getVertices());
            int size = vertices.size() - 1;
            if (uniqueCircuits) {
                ++size;
            }
            for (int i = 0; i < size; ++i) {
                this.startVertex = vertices.get(i);
                this.blockedSet.clear();
                this.blockedBackEdgesMap.clear();
                this.circuit(this.startVertex, 0, monitor);
                if (!uniqueCircuits) continue;
                this.subGraph.removeVertex(this.startVertex);
            }
        }
    }

    private boolean circuit(V v, int depth, TaskMonitor monitor) throws CancelledException {
        Object u;
        monitor.checkCanceled();
        if (depth > 2700) {
            return false;
        }
        boolean foundCircuit = false;
        this.blockedSet.add(v);
        this.stack.push(v);
        Collection<E> outEdges = this.subGraph.getOutEdges(v);
        for (GEdge e : outEdges) {
            u = e.getEnd();
            if (u.equals(this.startVertex)) {
                this.outputCircuit();
                foundCircuit = true;
                continue;
            }
            if (this.blockedSet.contains(u)) continue;
            foundCircuit |= this.circuit(u, depth + 1, monitor);
        }
        if (foundCircuit) {
            this.unblock(v);
        } else {
            for (GEdge e : outEdges) {
                u = e.getEnd();
                this.addBackEdge(u, v);
            }
        }
        this.stack.pop();
        return foundCircuit;
    }

    private void unblock(V v) {
        this.blockedSet.remove(v);
        Set<V> set = this.blockedBackEdgesMap.get(v);
        if (set == null) {
            return;
        }
        for (V u : set) {
            if (!this.blockedSet.contains(u)) continue;
            this.unblock(u);
        }
        set.clear();
    }

    private void addBackEdge(V u, V v) {
        Set<V> set = this.blockedBackEdgesMap.get(u);
        if (set == null) {
            set = new HashSet<V>();
            this.blockedBackEdgesMap.put((Set<V>)u, (Set<Set<V>>)set);
        }
        set.add(v);
    }

    private void outputCircuit() {
        ArrayList<V> circuit = new ArrayList<V>(this.stack);
        circuit.add(this.startVertex);
        this.accumulator.add(circuit);
    }
}

