/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.util.exception.DuplicateNameException;

public class RenameDataFieldCmd
implements Command {
    private DataTypeComponent comp;
    private String newName;
    private String statusMsg = "";

    public RenameDataFieldCmd(DataTypeComponent comp, String newName) {
        this.comp = comp;
        this.newName = newName;
    }

    public boolean applyTo(DomainObject obj) {
        if (this.comp == null) {
            this.statusMsg = "Null data type";
            return false;
        }
        try {
            this.comp.setFieldName(this.newName);
            return true;
        }
        catch (DuplicateNameException e) {
            this.statusMsg = "Type name already exists: " + this.newName;
            return false;
        }
    }

    public String getStatusMsg() {
        return this.statusMsg;
    }

    public String getName() {
        return "Rename Data Field";
    }
}

