/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.SequenceNumber;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.state.ContextState;
import ghidra.util.state.FunctionAnalyzer;
import ghidra.util.state.ResultsState;
import ghidra.util.state.VarnodeOperation;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class FunctionResultStateStackAnalysisCmd
extends BackgroundCommand {
    private AddressSet entryPoints = new AddressSet();
    private boolean forceProcessing = false;
    private boolean dontCreateNewVariables = false;

    public FunctionResultStateStackAnalysisCmd(AddressSetView entries, boolean forceProcessing) {
        super("Create Function Stack Variables", true, true, false);
        this.entryPoints.add(entries);
        this.forceProcessing = forceProcessing;
    }

    public FunctionResultStateStackAnalysisCmd(Address entry, boolean forceProcessing) {
        this((AddressSetView)new AddressSet(entry, entry), forceProcessing);
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        Program program = (Program)obj;
        int count = 0;
        monitor.initialize(this.entryPoints.getNumAddresses());
        AddressIterator iter = this.entryPoints.getAddresses(true);
        while (iter.hasNext() && !monitor.isCancelled()) {
            Address origEntry = iter.next();
            monitor.setProgress((long)(++count));
            Symbol funName = program.getSymbolTable().getPrimarySymbol(origEntry);
            Object msg = funName == null ? "" + origEntry : funName.getName();
            monitor.setMessage("Stack " + (String)msg);
            try {
                if (this.analyzeFunction(program, origEntry, monitor)) continue;
                this.setStatusMsg("Function overlaps an existing function body");
            }
            catch (CancelledException cancelledException) {}
        }
        if (monitor.isCancelled()) {
            this.setStatusMsg("Function Stack analysis cancelled");
            return false;
        }
        return true;
    }

    private boolean analyzeFunction(Program program, Address entry, TaskMonitor monitor) throws CancelledException {
        Listing listing = program.getListing();
        Function f = listing.getFunctionAt(entry);
        if (f == null) {
            return false;
        }
        int depthChange = 0;
        Stack<Function> stack = new Stack<Function>();
        ArrayList<Function> funcList = new ArrayList<Function>();
        stack.push(f);
        while (!stack.isEmpty()) {
            monitor.checkCanceled();
            Function func = (Function)stack.pop();
            if (func.getStackPurgeSize() == Integer.MAX_VALUE) {
                AddressIterator iter = program.getReferenceManager().getReferenceSourceIterator(func.getBody(), true);
                while (iter.hasNext()) {
                    Reference[] refs;
                    monitor.checkCanceled();
                    Address fromAddr = iter.next();
                    for (Reference ref : refs = program.getReferenceManager().getFlowReferencesFrom(fromAddr)) {
                        if (!ref.getReferenceType().isCall()) continue;
                        Address calledAddr = ref.getToAddress();
                        Function destFunc = program.getListing().getFunctionAt(calledAddr);
                        if (destFunc == null || destFunc.isInline()) continue;
                        stack.push(destFunc);
                    }
                }
                func.setStackPurgeSize(0x7FFFFFFE);
                funcList.add(0, func);
                continue;
            }
            if (!this.forceProcessing || !func.getEntryPoint().equals((Object)entry)) continue;
            func.setStackPurgeSize(0x7FFFFFFE);
            funcList.add(0, func);
        }
        PrototypeModel defaultModel = program.getCompilerSpec().getDefaultCallingConvention();
        int default_extraPop = defaultModel.getExtrapop();
        int default_stackshift = defaultModel.getStackshift();
        while (!funcList.isEmpty()) {
            monitor.checkCanceled();
            Function func = (Function)funcList.remove(0);
            monitor.setMessage("Stack " + func.getName());
            depthChange = this.createStackPointerVariables(func, monitor);
            PrototypeModel callingConvention = func.getCallingConvention();
            int stackShift = default_stackshift;
            int extraPop = default_extraPop;
            if (callingConvention != null) {
                stackShift = callingConvention.getStackshift();
                extraPop = callingConvention.getExtrapop();
            }
            if (depthChange > 1048575 || depthChange < -1048575) {
                depthChange = 0x7FFFFFFE;
            }
            if (extraPop != 32768) {
                depthChange = extraPop - stackShift;
            } else if (depthChange != 0x7FFFFFFE) {
                depthChange -= stackShift;
            }
            func.setStackPurgeSize(depthChange);
        }
        return true;
    }

    private int createStackPointerVariables(final Function func, TaskMonitor monitor) throws CancelledException {
        Program program = func.getProgram();
        final Listing listing = program.getListing();
        final AddressFactory addrFactory = program.getAddressFactory();
        final ReferenceManager refMgr = program.getReferenceManager();
        Register stackReg = program.getCompilerSpec().getStackPointer();
        if (stackReg == null) {
            return Integer.MAX_VALUE;
        }
        ResultsState results = new ResultsState(func.getEntryPoint(), new FunctionAnalyzer(){

            @Override
            public void dataReference(PcodeOp op, int instrOpIndex, Varnode storageVarnode, RefType refType, TaskMonitor monitor1) throws CancelledException {
            }

            @Override
            public void indirectDataReference(PcodeOp op, int instrOpIndex, Varnode offsetVarnode, int size, int storageSpaceID, RefType refType, TaskMonitor monitor1) throws CancelledException {
            }

            @Override
            public boolean resolvedFlow(PcodeOp op, int instrOpIndex, Address destAddr, ContextState currentState, ResultsState results1, TaskMonitor monitor1) throws CancelledException {
                return false;
            }

            @Override
            public void stackReference(PcodeOp op, int instrOpIndex, int stackOffset, int size, int storageSpaceID, RefType refType, TaskMonitor monitor1) throws CancelledException {
                if (instrOpIndex < 0) {
                    return;
                }
                Address fromAddr = op.getSeqnum().getTarget();
                Instruction instr = listing.getInstructionAt(fromAddr);
                if (instr == null) {
                    return;
                }
                Address stackAddr = addrFactory.getStackSpace().getAddress((long)stackOffset);
                RefType rt = refType;
                Reference ref = refMgr.getReference(fromAddr, stackAddr, instrOpIndex);
                if (ref != null) {
                    RefType existingRefType = ref.getReferenceType();
                    if (existingRefType == rt) {
                        return;
                    }
                    if (existingRefType == RefType.READ || existingRefType == RefType.WRITE) {
                        rt = RefType.READ_WRITE;
                    }
                } else if (refMgr.getReferencesFrom(fromAddr, instrOpIndex).length != 0) {
                    return;
                }
                if (!FunctionResultStateStackAnalysisCmd.this.dontCreateNewVariables) {
                    DataType type;
                    StackFrame stackFrame = func.getStackFrame();
                    Variable existingVar = stackFrame.getVariableContaining(stackOffset);
                    DataType dataType = type = size > 0 ? Undefined.getUndefinedDataType((int)size) : DataType.DEFAULT;
                    if (existingVar != null && existingVar.getDataType() == DataType.DEFAULT) {
                        func.removeVariable(existingVar);
                        existingVar = null;
                    }
                    if (existingVar == null) {
                        try {
                            stackFrame.createVariable(null, stackOffset, type, SourceType.ANALYSIS);
                        }
                        catch (DuplicateNameException e) {
                            throw new AssertException();
                        }
                        catch (InvalidInputException e) {
                            Msg.error((Object)this, (Object)("Failed to create stack variable at " + func.getEntryPoint() + ", ref-from=" + fromAddr + ", stack-offset=" + stackOffset + ", size=" + size + ": " + e.getMessage()));
                        }
                    }
                }
                refMgr.addStackReference(fromAddr, instrOpIndex, stackOffset, rt, SourceType.ANALYSIS);
            }

            @Override
            public void stackReference(PcodeOp op, int instrOpIndex, VarnodeOperation computedStackOffset, int size, int storageSpaceID, RefType refType, TaskMonitor monitor1) throws CancelledException {
            }

            @Override
            public List<Address> unresolvedIndirectFlow(PcodeOp op, int instrOpIndex, Varnode destination, ContextState currentState, ResultsState results1, TaskMonitor monitor1) throws CancelledException {
                return null;
            }
        }, program, true, monitor);
        if (results.getPreservedRegisters().contains(stackReg)) {
            return 0;
        }
        Set<Varnode> spReturnValues = results.getReturnValues(results.getStackPointerVarnode());
        if (!spReturnValues.isEmpty()) {
            for (SequenceNumber seq : results.getReturnAddresses()) {
                ContextState returnState = results.getContextStates(seq).next();
                Varnode varnode = returnState.get(results.getStackPointerVarnode(), TaskMonitorAdapter.DUMMY_MONITOR);
                Varnode zero = new Varnode(addrFactory.getConstantSpace().getAddress(0L), stackReg.getMinimumByteSize());
                if ((varnode = this.replaceInputVarnodes(varnode, results.getStackPointerVarnode(), zero, 4, monitor)) == null || !(varnode = this.simplifyVarnode(varnode, addrFactory)).isConstant()) continue;
                long offset = ResultsState.getSignedOffset(varnode);
                return (int)offset;
            }
        }
        return Integer.MAX_VALUE;
    }

    private Varnode simplifyVarnode(Varnode vn, AddressFactory addrFactory) throws CancelledException {
        if (!(vn instanceof VarnodeOperation)) {
            return vn;
        }
        VarnodeOperation vop = (VarnodeOperation)vn;
        return ResultsState.simplify(vop.getPCodeOp(), vop.getInputValues(), addrFactory, TaskMonitorAdapter.DUMMY_MONITOR);
    }

    private Varnode replaceInputVarnodes(Varnode exp, Varnode vn, Varnode value, int maxComplexity, TaskMonitor monitor) throws CancelledException {
        if (!(exp instanceof VarnodeOperation)) {
            return exp.equals((Object)vn) ? value : exp;
        }
        VarnodeOperation vop = (VarnodeOperation)exp;
        Varnode[] inputValues = vop.getInputValues();
        for (int i = 0; i < inputValues.length; ++i) {
            monitor.checkCanceled();
            if (vn.equals((Object)inputValues[i])) {
                inputValues[i] = value;
                continue;
            }
            if (maxComplexity == 0) {
                return null;
            }
            inputValues[i] = this.replaceInputVarnodes(inputValues[i], vn, value, maxComplexity - 1, monitor);
            if (inputValues[i] != null) continue;
            return null;
        }
        return new VarnodeOperation(vop.getPCodeOp(), inputValues);
    }
}

