/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.LocalVariable;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.StackVariableComparator;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableFilter;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.RefTypeFactory;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.StackReference;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.ContextEvaluatorAdapter;
import ghidra.program.util.SymbolicPropogator;
import ghidra.program.util.VariableStorageConflicts;
import ghidra.program.util.VarnodeContext;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class NewFunctionStackAnalysisCmd
extends BackgroundCommand {
    private static final int MAX_PARAM_OFFSET = 2048;
    private static final int MAX_LOCAL_OFFSET = -65536;
    private AddressSet entryPoints = new AddressSet();
    private Program program;
    private boolean forceProcessing = false;
    private boolean dontCreateNewVariables = false;
    private boolean doParams = false;
    private boolean doLocals = false;
    private Register stackReg;
    private int purge = 0;
    static String DEFAULT_FUNCTION_COMMENT = " FUNCTION";
    private static final int MAX_PARAM_FILLIN_COUNT = 10;

    public NewFunctionStackAnalysisCmd(AddressSetView entries, boolean forceProcessing) {
        this(entries, true, true, forceProcessing);
    }

    public NewFunctionStackAnalysisCmd(Address entry, boolean forceProcessing) {
        this((AddressSetView)new AddressSet(entry, entry), true, true, forceProcessing);
    }

    public NewFunctionStackAnalysisCmd(AddressSetView entries, boolean doParameterAnalysis, boolean doLocalAnalysis, boolean forceProcessing) {
        super("Create Function Stack Variables", true, true, false);
        this.entryPoints.add(entries);
        this.forceProcessing = forceProcessing;
        this.doParams = doParameterAnalysis;
        this.doLocals = doLocalAnalysis;
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        this.program = (Program)obj;
        int count = 0;
        long numAddresses = this.entryPoints.getNumAddresses();
        int numRanges = this.entryPoints.getNumAddressRanges();
        if ((long)numRanges != numAddresses) {
            numAddresses = this.program.getFunctionManager().getFunctionCount();
        }
        monitor.initialize(numAddresses);
        FunctionIterator functions = this.program.getFunctionManager().getFunctions((AddressSetView)this.entryPoints, true);
        while (functions.hasNext() && !monitor.isCancelled()) {
            Function func = (Function)functions.next();
            monitor.setProgress((long)(++count));
            monitor.setMessage("Stack " + func.getName());
            try {
                if (this.analyzeFunction(func, monitor)) continue;
                this.setStatusMsg("Function overlaps an existing function body");
            }
            catch (CancelledException cancelledException) {}
        }
        if (monitor.isCancelled()) {
            this.setStatusMsg("Function Stack analysis cancelled");
            return false;
        }
        return true;
    }

    private boolean analyzeFunction(Function f, TaskMonitor monitor) throws CancelledException {
        Function func;
        Address entry = f.getEntryPoint();
        Stack<Function> stack = new Stack<Function>();
        ArrayList<Function> funcList = new ArrayList<Function>();
        stack.push(f);
        while (!stack.isEmpty()) {
            monitor.checkCanceled();
            func = (Function)stack.pop();
            if (func.isThunk()) continue;
            if (this.forceProcessing && func.getEntryPoint().equals((Object)entry)) {
                funcList.add(0, func);
            }
            Variable[] variables = func.getVariables(VariableFilter.STACK_VARIABLE_FILTER);
            boolean hasReferences = false;
            for (int i = 0; i < variables.length; ++i) {
                Reference[] referencesTo = this.program.getReferenceManager().getReferencesTo(variables[i]);
                if (referencesTo.length == 0) continue;
                hasReferences = true;
                break;
            }
            if (variables.length != 0 && hasReferences) continue;
            funcList.add(0, func);
        }
        while (!funcList.isEmpty()) {
            monitor.checkCanceled();
            func = (Function)funcList.remove(0);
            SourceType oldSignatureSource = func.getSignatureSource();
            monitor.setMessage("Stack " + func.getName());
            this.createStackPointerVariables(func, monitor);
            if (oldSignatureSource == func.getSignatureSource()) continue;
            func.setSignatureSource(oldSignatureSource);
        }
        return true;
    }

    private boolean isProtectedVariable(Variable var) {
        return !var.isStackVariable() || !Undefined.isUndefined((DataType)var.getDataType()) || var.getSource() == SourceType.IMPORTED || var.getSource() == SourceType.USER_DEFINED || var.isCompoundVariable();
    }

    private void addFunctionStackVariablesToSortedList(Function func, List<Variable> sortedVariables) {
        for (Variable stackVar : func.getVariables(VariableFilter.STACK_VARIABLE_FILTER)) {
            Object varImpl;
            if (this.isProtectedVariable(stackVar)) continue;
            try {
                varImpl = stackVar instanceof Parameter ? new ParameterImpl(null, stackVar.getDataType(), stackVar.getStackOffset(), this.program) : new LocalVariableImpl(null, stackVar.getDataType(), stackVar.getStackOffset(), this.program);
            }
            catch (InvalidInputException e) {
                continue;
            }
            this.addVariableToSortedList((Variable)varImpl, sortedVariables);
        }
    }

    private int createStackPointerVariables(Function func, TaskMonitor monitor) throws CancelledException {
        this.stackReg = this.program.getCompilerSpec().getStackPointer();
        final ArrayList<Variable> sortedVariables = new ArrayList<Variable>();
        this.addFunctionStackVariablesToSortedList(func, sortedVariables);
        SymbolicPropogator symEval = new SymbolicPropogator(this.program);
        symEval.setParamRefCheck(false);
        symEval.setReturnRefCheck(false);
        symEval.setStoredRefCheck(false);
        ContextEvaluatorAdapter eval = new ContextEvaluatorAdapter(){

            @Override
            public boolean evaluateContext(VarnodeContext context, Instruction instr) {
                Varnode value;
                Register destReg;
                BigInteger signedValue;
                RegisterValue value2;
                if (instr.getFlowType().isTerminal() && (value2 = context.getRegisterValue(NewFunctionStackAnalysisCmd.this.stackReg, instr.getMaxAddress())) != null && (signedValue = value2.getSignedValue()) != null) {
                    NewFunctionStackAnalysisCmd.this.purge = signedValue.intValue();
                }
                if (instr.getMnemonicString().equals("LEA") && (destReg = instr.getRegister(0)) != null && (value = context.getRegisterVarnodeValue(destReg)) != null) {
                    this.checkForStackOffset(context, instr, value.getAddress(), 0);
                }
                return false;
            }

            @Override
            public boolean evaluateSymbolicReference(VarnodeContext context, Instruction instr, Address address) {
                if (instr.getFlowType().isTerminal()) {
                    return false;
                }
                this.checkForStackOffset(context, instr, address, -1);
                return false;
            }

            private void checkForStackOffset(VarnodeContext context, Instruction instr, Address address, int opIndex) {
                AddressSpace space = address.getAddressSpace();
                String spaceName = space.getName();
                if (spaceName.startsWith("track_") || context.isStackSpaceName(spaceName)) {
                    Register reg;
                    if (opIndex == -1 && (opIndex = NewFunctionStackAnalysisCmd.this.getStackOpIndex(context, instr, (int)address.getOffset())) == -1 && instr.getPrototype().hasDelaySlots()) {
                        if ((instr = instr.getNext()) == null) {
                            return;
                        }
                        opIndex = NewFunctionStackAnalysisCmd.this.getStackOpIndex(context, instr, (int)address.getOffset());
                    }
                    if (opIndex == -1) {
                        return;
                    }
                    if (instr.getMnemonicString().equals("POP") && (reg = instr.getRegister(opIndex)) != null && reg.getName().contains("BP")) {
                        return;
                    }
                    long extendedOffset = this.extendOffset(address.getOffset(), NewFunctionStackAnalysisCmd.this.stackReg.getBitLength());
                    Function func = NewFunctionStackAnalysisCmd.this.program.getFunctionManager().getFunctionContaining(instr.getMinAddress());
                    NewFunctionStackAnalysisCmd.this.defineFuncVariable(func, instr, opIndex, (int)extendedOffset, sortedVariables);
                }
            }

            private long extendOffset(long offset, int bitLength) {
                return offset << 64 - bitLength >> 64 - bitLength;
            }
        };
        symEval.setRegister(func.getEntryPoint(), this.stackReg);
        symEval.flowConstants(func.getEntryPoint(), func.getBody(), (ContextEvaluator)eval, true, monitor);
        if (sortedVariables.size() != 0) {
            ArrayList<Variable> protectedFuncVars = new ArrayList<Variable>();
            for (Variable v : func.getAllVariables()) {
                if (!this.isProtectedVariable(v)) continue;
                protectedFuncVars.add(v);
            }
            VariableStorageConflicts conflicts = new VariableStorageConflicts(sortedVariables, protectedFuncVars, false, monitor);
            SourceType signatureSource = func.getSignatureSource();
            if (signatureSource != SourceType.IMPORTED && signatureSource != SourceType.USER_DEFINED) {
                this.addStackParameters(func, sortedVariables, conflicts, monitor);
            }
            this.addStackLocalVariables(func, sortedVariables, conflicts, monitor);
        }
        return this.purge;
    }

    private void addStackLocalVariables(Function func, List<Variable> sortedVariables, VariableStorageConflicts conflicts, TaskMonitor monitor) {
        if (func.isThunk()) {
            return;
        }
        Variable[] unprotectedLocals = func.getVariables(variable -> variable instanceof LocalVariable && variable.isStackVariable() && !this.isProtectedVariable(variable));
        for (Variable var : sortedVariables) {
            if (var instanceof Parameter || conflicts.isConflicted(var, null)) continue;
            for (Variable old : unprotectedLocals) {
                if (!old.getVariableStorage().intersects(var.getVariableStorage())) continue;
                func.removeVariable(old);
            }
            try {
                VariableUtilities.checkVariableConflict((Function)func, null, (VariableStorage)var.getVariableStorage(), (boolean)false);
                func.addLocalVariable(var, SourceType.DEFAULT);
            }
            catch (DuplicateNameException | InvalidInputException throwable) {}
        }
    }

    private void addStackParameters(Function func, List<Variable> sortedVariables, VariableStorageConflicts conflicts, TaskMonitor monitor) {
        Parameter[] oldParamList = func.getParameters();
        ArrayList<Variable> newParamList = new ArrayList<Variable>();
        boolean growsNegative = func.getStackFrame().growsNegative();
        int sortedVarCnt = sortedVariables.size();
        int index = 0;
        for (index = 0; index < sortedVarCnt; ++index) {
            Variable var = sortedVariables.get(index);
            if (growsNegative && var instanceof Parameter) break;
            if (growsNegative || var instanceof Parameter) continue;
            --index;
            break;
        }
        if (index < 0 || index == sortedVarCnt) {
            return;
        }
        PrototypeModel callingConvention = func.getCallingConvention();
        if (callingConvention == null) {
            callingConvention = this.program.getCompilerSpec().getDefaultCallingConvention();
        }
        if (callingConvention == null) {
            return;
        }
        boolean hasStackParams = callingConvention.getStackParameterAlignment() >= 0;
        int nextCopyParamIndex = 0;
        if (growsNegative) {
            for (i = index; i < sortedVarCnt; ++i) {
                v = sortedVariables.get(i);
                if (conflicts.isConflicted(v, null)) continue;
                if ((nextCopyParamIndex = this.addMissingParameters(v, nextCopyParamIndex, oldParamList, newParamList, callingConvention, hasStackParams)) < 0) {
                    return;
                }
                newParamList.add(v);
            }
        } else {
            for (i = index; i >= 0; --i) {
                v = sortedVariables.get(i);
                if (conflicts.isConflicted(v, null)) continue;
                if ((nextCopyParamIndex = this.addMissingParameters(v, nextCopyParamIndex, oldParamList, newParamList, callingConvention, hasStackParams)) < 0) {
                    return;
                }
                newParamList.add(v);
            }
        }
        while (nextCopyParamIndex < oldParamList.length) {
            newParamList.add((Variable)oldParamList[nextCopyParamIndex++]);
        }
        try {
            func.replaceParameters(newParamList, func.hasCustomVariableStorage() ? Function.FunctionUpdateType.CUSTOM_STORAGE : Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, func.getSignatureSource());
            if (!VariableUtilities.storageMatches(newParamList, (Variable[])func.getParameters())) {
                func.replaceParameters(newParamList, Function.FunctionUpdateType.CUSTOM_STORAGE, true, func.getSignatureSource());
            }
        }
        catch (DuplicateNameException duplicateNameException) {
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    private int addMissingParameters(Variable stackVar, int nextCopyParamIndex, Parameter[] oldParamList, List<Variable> newParamList, PrototypeModel callingConvention, boolean hasStackParams) {
        VariableStorage argLocation;
        if (!(stackVar instanceof Parameter)) {
            throw new IllegalArgumentException();
        }
        if (callingConvention.getStackParameterOffset() == null) {
            return -1;
        }
        int offset = stackVar.getStackOffset();
        while (nextCopyParamIndex < oldParamList.length) {
            Parameter p = oldParamList[nextCopyParamIndex];
            if (!p.isStackVariable()) {
                newParamList.add((Variable)p);
            } else {
                int stackOffset = p.getStackOffset();
                if (offset > 0 && offset > stackOffset || offset < 0 && offset < stackOffset) {
                    newParamList.add((Variable)p);
                } else {
                    if (offset != stackOffset) break;
                    ++nextCopyParamIndex;
                    break;
                }
            }
            ++nextCopyParamIndex;
        }
        int nextOrdinal = newParamList.size();
        if (!hasStackParams || nextOrdinal >= 10) {
            return nextCopyParamIndex;
        }
        try {
            Parameter[] params = new Parameter[nextOrdinal];
            argLocation = callingConvention.getArgLocation(nextOrdinal, newParamList.toArray(params), DataType.DEFAULT, this.program);
            while (!argLocation.intersects(stackVar.getVariableStorage()) && nextOrdinal < 10) {
                ParameterImpl p = new ParameterImpl(null, DataType.DEFAULT, argLocation, this.program);
                newParamList.add((Variable)p);
                params = new Parameter[++nextOrdinal];
                argLocation = callingConvention.getArgLocation(nextOrdinal, newParamList.toArray(params), DataType.DEFAULT, this.program);
            }
        }
        catch (InvalidInputException e) {
            throw new RuntimeException(e);
        }
        if (!argLocation.isStackStorage()) {
            return nextCopyParamIndex;
        }
        return nextCopyParamIndex;
    }

    private int getStackOpIndex(VarnodeContext context, Instruction cu, int offset) {
        for (int opIndex = 0; opIndex < cu.getNumOperands(); ++opIndex) {
            Object[] obj = cu.getOpObjects(opIndex);
            int local_offset = 0;
            for (int i = 0; obj != null && i < obj.length; ++i) {
                if (obj[i] instanceof Register) {
                    String spaceName;
                    Register reg = (Register)obj[i];
                    Varnode vnode = context.getRegisterVarnodeValue(reg);
                    if (vnode == null || !(spaceName = vnode.getAddress().getAddressSpace().getName()).startsWith("track_") && !context.isStackSpaceName(spaceName)) continue;
                    local_offset += (int)vnode.getOffset();
                } else {
                    if (!(obj[i] instanceof Scalar)) continue;
                    Scalar sc = (Scalar)obj[i];
                    local_offset = (int)((long)local_offset + sc.getSignedValue());
                }
                if (local_offset != offset) continue;
                return opIndex;
            }
        }
        return -1;
    }

    private void defineFuncVariable(Function func, Instruction instr, int opIndex, int stackOffset, List<Variable> sortedVariables) {
        ReferenceManager refMgr = this.program.getReferenceManager();
        int refSize = this.getRefSize(instr, opIndex);
        try {
            if (stackOffset > 2048 || stackOffset < -65536) {
                return;
            }
            Reference ref = instr.getPrimaryReference(opIndex);
            if (ref instanceof StackReference) {
                Variable var = refMgr.getReferencedVariable(ref);
                if (var == null) {
                    this.accumulateVariable(func, ((StackReference)ref).getStackOffset(), refSize, sortedVariables);
                }
                return;
            }
            if (ref == null) {
                RefType refType = RefTypeFactory.getDefaultStackRefType((CodeUnit)instr, (int)opIndex);
                refMgr.addStackReference(instr.getMinAddress(), opIndex, stackOffset, refType, SourceType.ANALYSIS);
                this.accumulateVariable(func, stackOffset, refSize, sortedVariables);
            }
        }
        catch (InvalidInputException e) {
            Msg.debug((Object)((Object)this), (Object)("Failed to create variable (instruction at " + instr.getMinAddress() + ", stack-offset=" + stackOffset + ", size=" + refSize + "): " + e.getMessage()));
        }
    }

    private int getRefSize(Instruction instr, int opIndex) {
        if (instr.getProgram().getLanguage().supportsPcode()) {
            PcodeOp[] pcode = instr.getPcode();
            for (int i = pcode.length - 1; i >= 0; --i) {
                if (pcode[i].getOpcode() == 2) {
                    Varnode out = pcode[i].getOutput();
                    return out.getSize();
                }
                if (pcode[i].getOpcode() != 3) continue;
                Varnode src = pcode[i].getInput(2);
                return src.getSize();
            }
        } else {
            Object[] results = instr.getResultObjects();
            if (results.length == 1 && results[0] instanceof Register) {
                return ((Register)results[0]).getMinimumByteSize();
            }
        }
        return 0;
    }

    private List<Variable> getVariablesIntersecting(int offset, int size, List<Variable> sortedVariables) {
        ArrayList<Variable> list = null;
        int maxOffset = offset + size - 1;
        while (offset <= maxOffset) {
            Variable var = this.getVariableContaining(offset, sortedVariables);
            if (var != null) {
                if (list == null) {
                    list = new ArrayList<Variable>();
                }
                list.add(var);
                offset += var.getLength();
                continue;
            }
            ++offset;
        }
        return list;
    }

    private Variable getVariableContaining(int offset, List<Variable> sortedVariables) {
        Integer key = new Integer(offset);
        int index = Collections.binarySearch(sortedVariables, key, StackVariableComparator.get());
        if (index >= 0) {
            return sortedVariables.get(index);
        }
        index = -index - 1;
        if (--index < 0) {
            return null;
        }
        Variable var = sortedVariables.get(index);
        int stackOffset = var.getStackOffset();
        if (stackOffset + var.getLength() > offset) {
            if (var.getDataType().isDeleted()) {
                sortedVariables.remove(index);
            } else {
                return var;
            }
        }
        return null;
    }

    private void addVariableToSortedList(Variable var, List<Variable> sortedVariables) {
        int index = Collections.binarySearch(sortedVariables, new Integer(var.getStackOffset()), StackVariableComparator.get());
        if (index >= 0) {
            throw new AssertException("Unexpected variable conflict");
        }
        index = -index - 1;
        sortedVariables.add(index, var);
    }

    private void accumulateVariable(Function func, int offset, int refSize, List<Variable> sortedVariables) throws InvalidInputException {
        DataType dt;
        boolean isParam;
        if (this.dontCreateNewVariables) {
            return;
        }
        int size = refSize > 0 ? refSize : 1;
        StackFrame frame = func.getStackFrame();
        int paramOffset = frame.getParameterOffset();
        boolean growsNegative = frame.growsNegative();
        boolean bl = isParam = growsNegative && offset >= paramOffset || !growsNegative && offset <= paramOffset;
        if (!this.doLocals && !isParam) {
            return;
        }
        if (!this.doParams && isParam) {
            return;
        }
        List<Variable> variablesIntersecting = this.getVariablesIntersecting(offset, size, sortedVariables);
        if (variablesIntersecting != null) {
            Variable firstVar = variablesIntersecting.get(0);
            if (firstVar.getLength() == size) {
                return;
            }
            int endOffset = offset + size - 1;
            Variable lastVar = variablesIntersecting.get(variablesIntersecting.size() - 1);
            int minOffset = firstVar.getStackOffset();
            int maxOffset = lastVar.getStackOffset() + lastVar.getLength() - 1;
            for (int i = 0; i < variablesIntersecting.size(); ++i) {
                sortedVariables.remove(variablesIntersecting.get(i));
            }
            if (minOffset > offset) {
                minOffset = offset;
            }
            if (maxOffset < endOffset) {
                maxOffset = endOffset;
            }
            dt = Undefined.getUndefinedDataType((int)(Math.abs(maxOffset - minOffset) + 1));
            offset = minOffset;
        } else {
            dt = Undefined.getUndefinedDataType((int)size);
        }
        Object var = isParam ? new ParameterImpl(null, dt, offset, this.program) : new LocalVariableImpl(null, dt, offset, this.program);
        this.addVariableToSortedList((Variable)var, sortedVariables);
    }
}

