/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.datatypes;

import ghidra.program.model.data.ArchiveType;
import ghidra.program.model.data.SourceArchive;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

class SourceArchivePanel
extends JPanel {
    private SourceArchive sourceArchive;
    private JTextPane textPane;
    private StyledDocument doc;
    private SimpleAttributeSet headingAttrSet;
    private SimpleAttributeSet valueAttrSet;
    private SimpleAttributeSet deletedAttrSet;

    SourceArchivePanel() {
        super(new BorderLayout());
        this.create();
    }

    public void setSourceArchive(SourceArchive sourceArchive) {
        this.sourceArchive = sourceArchive;
        this.textPane.setText("");
        this.formatSourceArchive();
        this.textPane.setCaretPosition(0);
    }

    private void create() {
        this.textPane = new JTextPane();
        this.doc = this.textPane.getStyledDocument();
        this.add((Component)this.textPane, "Center");
        this.textPane.setEditable(false);
        this.headingAttrSet = new SimpleAttributeSet();
        this.headingAttrSet.addAttribute(StyleConstants.FontFamily, "Monospaced");
        this.headingAttrSet.addAttribute(StyleConstants.FontSize, new Integer(12));
        this.headingAttrSet.addAttribute(StyleConstants.Foreground, Color.BLUE);
        this.valueAttrSet = new SimpleAttributeSet();
        this.valueAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        this.valueAttrSet.addAttribute(StyleConstants.FontSize, new Integer(11));
        this.valueAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.deletedAttrSet = new SimpleAttributeSet();
        this.deletedAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        this.deletedAttrSet.addAttribute(StyleConstants.FontSize, new Integer(12));
        this.deletedAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.deletedAttrSet.addAttribute(StyleConstants.Foreground, Color.RED);
        this.setSourceArchive(null);
    }

    private void formatSourceArchive() {
        if (this.sourceArchive == null) {
            this.insertString("\n\nDeleted", this.deletedAttrSet);
            return;
        }
        this.formatName();
        this.formatSyncTime();
        this.formatDirtyFlag();
    }

    private void formatArchiveID() {
        this.insertString("    Archive ID: ", this.headingAttrSet);
        this.insertString(this.sourceArchive.getSourceArchiveID().getValue() + "\n", this.valueAttrSet);
    }

    private void formatName() {
        this.insertString("Name: ", this.headingAttrSet);
        this.insertString(this.sourceArchive.getName() + "\n", this.valueAttrSet);
    }

    private void formatFileID() {
        this.insertString("       File ID: ", this.headingAttrSet);
        this.insertString(this.sourceArchive.getDomainFileID() + "\n", this.valueAttrSet);
    }

    private void formatType() {
        ArchiveType archiveType = this.sourceArchive.getArchiveType();
        String typeString = archiveType == ArchiveType.FILE ? "File Archive" : (archiveType == ArchiveType.PROGRAM ? "Program" : (archiveType == ArchiveType.PROJECT ? "Project Archive" : (archiveType == ArchiveType.BUILT_IN ? "Built-In" : "Invalid")));
        this.insertString("          Type: ", this.headingAttrSet);
        this.insertString(typeString + "\n", this.valueAttrSet);
    }

    private void formatSyncTime() {
        String syncTime = new Date(this.sourceArchive.getLastSyncTime()).toString();
        this.insertString("Last Sync Time: ", this.headingAttrSet);
        this.insertString(syncTime + "\n", this.valueAttrSet);
    }

    private void formatDirtyFlag() {
        this.insertString("Changed Since Last Sync? ", this.headingAttrSet);
        this.insertString((this.sourceArchive.isDirty() ? "yes" : "no") + "\n", this.valueAttrSet);
    }

    private void insertString(String str, SimpleAttributeSet attributeSet) {
        int offset = this.doc.getLength();
        try {
            this.doc.insertString(offset, str, attributeSet);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

