/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser.hover;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.plugin.core.codebrowser.hover.ListingHoverService;
import ghidra.app.plugin.core.hover.AbstractScalarOperandHover;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import java.util.ArrayList;
import javax.swing.JComponent;

public class ScalarOperandListingHover
extends AbstractScalarOperandHover
implements ListingHoverService {
    private static final int PRIORITY = 20;
    private static final String NAME = "Scalar Operand Display";
    private static final String DESCRIPTION = "Scalars are shown as 1-, 2-, 4-, and 8-byte values, each in decimal, hexadecimal, and as ASCII character sequences.";

    public ScalarOperandListingHover(PluginTool tool) {
        super(tool, 20);
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    protected String getDescription() {
        return DESCRIPTION;
    }

    @Override
    protected String getOptionsCategory() {
        return "Listing Popups";
    }

    @Override
    public JComponent getHoverComponent(Program program, ProgramLocation programLocation, FieldLocation fieldLocation, Field field) {
        if (!this.enabled || programLocation == null) {
            return null;
        }
        if (!(programLocation instanceof OperandFieldLocation)) {
            return null;
        }
        Address a = programLocation.getAddress();
        Instruction instruction = program.getListing().getInstructionAt(a);
        if (instruction == null) {
            return null;
        }
        OperandFieldLocation operandLocation = (OperandFieldLocation)programLocation;
        Object operand = this.getOperand(operandLocation, instruction);
        if (!(operand instanceof Scalar)) {
            return null;
        }
        String formatted = this.formatScalar(instruction.getProgram(), instruction.getAddress(), (Scalar)operand);
        return this.createTooltipComponent(formatted);
    }

    private Object getOperand(OperandFieldLocation loc, Instruction instruction) {
        int opIndex = loc.getOperandIndex();
        Object[] operands = instruction.getOpObjects(opIndex);
        if (operands.length == 1) {
            return operands[0];
        }
        InstructionPrototype prototype = instruction.getPrototype();
        ArrayList list = prototype.getOpRepresentationList(opIndex, instruction.getInstructionContext());
        if (list == null) {
            return null;
        }
        int subOpIndex = loc.getSubOperandIndex();
        if (subOpIndex < 0 || subOpIndex >= list.size()) {
            return null;
        }
        return list.get(subOpIndex);
    }
}

