/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.cparser;

import docking.widgets.dialogs.MultiLineMessageDialog;
import ghidra.app.plugin.core.cparser.CParserPlugin;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.File;
import javax.swing.SwingUtilities;

class CParserTask
extends Task {
    private String[] filenames;
    private String options;
    private CParserPlugin plugin;
    private String dataFileName;
    private DataTypeManager dtMgr;

    CParserTask(CParserPlugin plugin, String[] filenames, String options, String dataFileName) {
        super("Parsing C Files", true, false, false);
        this.plugin = plugin;
        this.filenames = filenames;
        this.options = options;
        this.dataFileName = dataFileName;
    }

    public CParserTask(CParserPlugin plugin, String[] filenames, String options, DataTypeManager dataTypeManager) {
        super("Parsing C Files", true, false, false);
        this.plugin = plugin;
        this.filenames = filenames;
        this.options = options;
        this.dtMgr = dataTypeManager;
    }

    private String getFirstMessageLine(String errMsg) {
        int indexOf = errMsg.indexOf(10);
        String msg = errMsg;
        if (indexOf > 0) {
            msg = msg.substring(0, indexOf);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) {
        block20: {
            try (DataTypeManager fileDtMgr = null;){
                if (this.dtMgr == null) {
                    File file = new File(this.dataFileName);
                    fileDtMgr = this.dtMgr = FileDataTypeManager.createFileArchive((File)file);
                }
                this.plugin.parse(this.filenames, this.options, this.dtMgr, monitor);
                if (this.dataFileName == null) break block20;
                if (this.dtMgr.getDataTypeCount(true) != 0) {
                    try {
                        ((FileDataTypeManager)this.dtMgr).save();
                        this.dtMgr.close();
                        break block20;
                    }
                    catch (DuplicateFileException e) {
                        Msg.showError((Object)((Object)this), (Component)this.plugin.getDialog().getComponent(), (String)"Error During Save", (Object)e.getMessage());
                        break block20;
                    }
                    catch (Exception e) {
                        Msg.showError((Object)((Object)this), (Component)this.plugin.getDialog().getComponent(), (String)"Error During Save", (Object)("Could not save to file " + this.dataFileName), (Throwable)e);
                        break block20;
                    }
                    finally {
                        if (this.dtMgr instanceof FileDataTypeManager) {
                            this.dtMgr.close();
                        }
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MultiLineMessageDialog.showModalMessageDialog((Component)CParserTask.this.plugin.getDialog().getComponent(), (String)"Parse Errors", (String)("File was not created due to parse errors: " + ((FileDataTypeManager)CParserTask.this.dtMgr).getFilename()), (String)CParserTask.this.plugin.getFormattedParseMessage(null), (int)1);
                    }
                });
            }
        }
    }
}

