/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.data;

import ghidra.app.plugin.core.data.AbstractSettingsDialog;
import ghidra.app.plugin.core.data.DataPlugin;
import ghidra.app.plugin.core.data.DataTypeSettingsDialog;
import ghidra.docking.settings.BooleanSettingsDefinition;
import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.NumberSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.docking.settings.StringSettingsDefinition;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.InteriorSelection;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public class DataSettingsDialog
extends AbstractSettingsDialog {
    private ProgramSelection selection;
    private Data data;
    private Program program;
    private Settings sampleSelectionSettings;

    public DataSettingsDialog(Program program, ProgramSelection sel) throws CancelledException {
        super("Common Settings for Selected Data", DataSettingsDialog.getCommonSettings(program, sel), null);
        this.program = program;
        this.selection = sel;
        this.setHelpLocation(new HelpLocation("DataPlugin", "Data_Settings_OnSelection"));
    }

    public DataSettingsDialog(Data data) {
        super(DataSettingsDialog.constructTitle(data), DataSettingsDialog.getAllowedDataInstanceSettingsDefinitions(data.getDataType()), (Settings)data);
        this.data = data;
        this.program = data.getProgram();
        Data pdata = data.getParent();
        if (pdata != null && pdata.getBaseDataType() instanceof Composite) {
            this.setHelpLocation(new HelpLocation("DataPlugin", "SettingsOnStructureComponents"));
        } else {
            this.setHelpLocation(new HelpLocation("DataPlugin", "Data_Settings"));
        }
    }

    static SettingsDefinition[] getAllowedDataInstanceSettingsDefinitions(DataType dt) {
        return SettingsDefinition.filterSettingsDefinitions((SettingsDefinition[])dt.getSettingsDefinitions(), def -> !(def instanceof TypeDefSettingsDefinition));
    }

    private static String constructTitle(Data data) {
        StringBuffer buffy = new StringBuffer(DataTypeSettingsDialog.constructTitle(null, data.getDataType(), false));
        buffy.append(" at ");
        buffy.append(data.getMinAddress().toString());
        return buffy.toString();
    }

    @Override
    public void dispose() {
        this.program = null;
        super.dispose();
    }

    private static SettingsDefinition[] getCommonSettings(Program program, ProgramSelection selection) throws CancelledException {
        CommonSettingsAccumulatorTask myTask = new CommonSettingsAccumulatorTask(program, selection);
        new TaskLauncher((Task)myTask, null);
        if (myTask.isCancelled()) {
            throw new CancelledException();
        }
        return myTask.defsArray;
    }

    private static void removeMissingDefinitions(List<Class<? extends SettingsDefinition>> defClasses, List<SettingsDefinition> defs, SettingsDefinition[] checkDefs) {
        for (int i = defClasses.size() - 1; i >= 0; --i) {
            Class<? extends SettingsDefinition> c = defClasses.get(i);
            boolean found = false;
            for (SettingsDefinition checkDef : checkDefs) {
                if (!c.isAssignableFrom(checkDef.getClass())) continue;
                found = true;
                break;
            }
            if (found) continue;
            defClasses.remove(i);
            defs.remove(i);
        }
    }

    private static void applySettingsToData(DataSettingsDialog dlg, Data dataTarget) {
        Settings settings = dlg.getSettings();
        Settings defaultSettings = dlg.getDefaultSettings();
        for (SettingsDefinition settingsDef : dlg.getSettingsDefinitions()) {
            EnumSettingsDefinition def;
            if (dlg.selection != null && !settingsDef.hasValue(settings)) continue;
            if (settingsDef instanceof EnumSettingsDefinition) {
                def = (EnumSettingsDefinition)settingsDef;
                int s = def.getChoice(settings);
                if (defaultSettings != null && s == def.getChoice(defaultSettings)) {
                    def.clear((Settings)dataTarget);
                    continue;
                }
                def.setChoice((Settings)dataTarget, s);
                continue;
            }
            if (settingsDef instanceof BooleanSettingsDefinition) {
                def = (BooleanSettingsDefinition)settingsDef;
                boolean s = def.getValue(settings);
                if (defaultSettings != null && s == def.getValue(defaultSettings)) {
                    def.clear((Settings)dataTarget);
                    continue;
                }
                def.setValue((Settings)dataTarget, s);
                continue;
            }
            if (settingsDef instanceof NumberSettingsDefinition) {
                def = (NumberSettingsDefinition)settingsDef;
                long val = def.getValue(settings);
                if (defaultSettings != null && val == def.getValue(defaultSettings)) {
                    def.clear((Settings)dataTarget);
                    continue;
                }
                def.setValue((Settings)dataTarget, val);
                continue;
            }
            throw new AssertException();
        }
    }

    @Override
    protected String[] getSuggestedValues(StringSettingsDefinition settingsDefinition) {
        if (!settingsDefinition.supportsSuggestedValues()) {
            return null;
        }
        if (this.data != null) {
            return settingsDefinition.getSuggestedValues((Settings)this.data);
        }
        if (this.sampleSelectionSettings == null) {
            DataIterator definedData = this.program.getListing().getDefinedData((AddressSetView)this.selection, true);
            if (definedData.hasNext()) {
                this.sampleSelectionSettings = definedData.next();
            }
            if (this.sampleSelectionSettings == null) {
                return null;
            }
        }
        return settingsDefinition.getSuggestedValues(this.sampleSelectionSettings);
    }

    @Override
    protected void applySettings() throws CancelledException {
        int txId = this.program.startTransaction(this.getTitle());
        try {
            if (this.selection != null) {
                ApplyCommonSettingsTask myTask = new ApplyCommonSettingsTask(this, this.program, this.selection);
                new TaskLauncher((Task)myTask, null);
                if (myTask.isCancelled()) {
                    throw new CancelledException();
                }
                return;
            }
            DataSettingsDialog.applySettingsToData(this, this.data);
        }
        finally {
            this.program.endTransaction(txId, true);
        }
    }

    private static class CommonSettingsAccumulatorTask
    extends Task {
        Program program;
        ProgramSelection selection;
        SettingsDefinition[] defsArray = new SettingsDefinition[0];

        CommonSettingsAccumulatorTask(Program program, ProgramSelection selection) {
            super("Accumulating Data Settings", true, false, true);
            this.program = program;
            this.selection = selection;
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            monitor.initialize(this.selection.getNumAddresses());
            InteriorSelection interiorSelection = this.selection.getInteriorSelection();
            if (interiorSelection != null) {
                this.accumulateInteriorSettingsDefinitions(interiorSelection, monitor);
            } else {
                this.accumulateDataSettingsDefinitions(monitor);
            }
        }

        private void accumulateDataSettingsDefinitions(TaskMonitor monitor) throws CancelledException {
            ArrayList<Class<? extends SettingsDefinition>> defClasses = new ArrayList<Class<? extends SettingsDefinition>>();
            ArrayList<SettingsDefinition> defs = new ArrayList<SettingsDefinition>();
            Listing listing = this.program.getListing();
            DataIterator definedData = listing.getDefinedData((AddressSetView)this.selection, true);
            if (!definedData.hasNext()) {
                return;
            }
            Data d = definedData.next();
            monitor.incrementProgress((long)d.getLength());
            for (SettingsDefinition def : d.getDataType().getSettingsDefinitions()) {
                if (def instanceof TypeDefSettingsDefinition) continue;
                defs.add(def);
                defClasses.add(def.getClass());
            }
            while (!defClasses.isEmpty() && definedData.hasNext()) {
                monitor.checkCanceled();
                d = definedData.next();
                DataSettingsDialog.removeMissingDefinitions(defClasses, defs, d.getDataType().getSettingsDefinitions());
                monitor.incrementProgress((long)d.getLength());
            }
            this.defsArray = new SettingsDefinition[defs.size()];
            defs.toArray(this.defsArray);
        }

        private void accumulateInteriorSettingsDefinitions(InteriorSelection interiorSelection, TaskMonitor monitor) throws CancelledException {
            ArrayList<Class<? extends SettingsDefinition>> defClasses = null;
            ArrayList<SettingsDefinition> defs = null;
            int[] from = interiorSelection.getFrom().getComponentPath();
            int[] to = interiorSelection.getTo().getComponentPath();
            Data dataComp = DataPlugin.getDataUnit(this.program, this.selection.getMinAddress(), from);
            if (dataComp == null || from.length != to.length) {
                return;
            }
            Data parent = dataComp.getParent();
            int fromIndex = from[from.length - 1];
            int toIndex = to[to.length - 1];
            for (int i = fromIndex; i <= toIndex; ++i) {
                monitor.checkCanceled();
                dataComp = parent.getComponent(i);
                if (dataComp == null) break;
                monitor.incrementProgress((long)dataComp.getLength());
                DataType dt = dataComp.getDataType();
                if (dt == DataType.DEFAULT) continue;
                SettingsDefinition[] settingsDefinitions = dt.getSettingsDefinitions();
                if (settingsDefinitions.length == 0) {
                    return;
                }
                if (defClasses == null) {
                    defClasses = new ArrayList<Class<? extends SettingsDefinition>>();
                    defs = new ArrayList<SettingsDefinition>();
                    for (SettingsDefinition def : settingsDefinitions) {
                        defs.add(def);
                        defClasses.add(def.getClass());
                    }
                    continue;
                }
                DataSettingsDialog.removeMissingDefinitions(defClasses, (List<SettingsDefinition>)defs, settingsDefinitions);
            }
            this.defsArray = new SettingsDefinition[defs.size()];
            defs.toArray(this.defsArray);
        }
    }

    private static class ApplyCommonSettingsTask
    extends Task {
        DataSettingsDialog dlg;
        Program program;
        ProgramSelection selection;

        ApplyCommonSettingsTask(DataSettingsDialog dlg, Program program, ProgramSelection selection) {
            super("Applying Settings", true, false, true);
            this.dlg = dlg;
            this.program = program;
            this.selection = selection;
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            monitor.initialize(this.selection.getNumAddresses());
            InteriorSelection interiorSelection = this.selection.getInteriorSelection();
            if (interiorSelection == null) {
                DataIterator definedData = this.program.getListing().getDefinedData((AddressSetView)this.selection, true);
                while (definedData.hasNext()) {
                    monitor.checkCanceled();
                    Data d = definedData.next();
                    DataSettingsDialog.applySettingsToData(this.dlg, d);
                    monitor.incrementProgress((long)d.getLength());
                }
                return;
            }
            int[] from = interiorSelection.getFrom().getComponentPath();
            int[] to = interiorSelection.getTo().getComponentPath();
            Data dataComp = DataPlugin.getDataUnit(this.program, this.selection.getMinAddress(), from);
            if (dataComp == null) {
                return;
            }
            Data parent = dataComp.getParent();
            int fromIndex = from[from.length - 1];
            int toIndex = to[to.length - 1];
            monitor.initialize((long)(toIndex - fromIndex + 1));
            for (int i = fromIndex; i <= toIndex; ++i) {
                monitor.checkCanceled();
                dataComp = parent.getComponent(i);
                if (dataComp == null) break;
                monitor.incrementProgress((long)dataComp.getLength());
                DataType dt = dataComp.getDataType();
                if (dt == DataType.DEFAULT) continue;
                DataSettingsDialog.applySettingsToData(this.dlg, dataComp);
            }
        }
    }
}

