/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import ghidra.app.util.ToolTipUtils;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypeDef;
import ghidra.service.graph.AttributedEdge;
import ghidra.service.graph.AttributedGraph;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayOptions;
import ghidra.service.graph.GraphDisplayOptionsBuilder;
import ghidra.service.graph.GraphDisplayProvider;
import ghidra.service.graph.GraphType;
import ghidra.service.graph.GraphTypeBuilder;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.GraphException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;

public class TypeGraphTask
extends Task {
    private DataType type;
    private String graphTitle;
    private GraphDisplayProvider graphService;
    public static final String COMPOSITE = "Composite";
    public static final String REFERENCE = "Reference";

    public TypeGraphTask(DataType type, GraphDisplayProvider graphService) {
        super("Graph Data Type", true, false, true);
        this.type = type;
        if (this.type instanceof TypeDef) {
            this.type = ((TypeDef)this.type).getBaseDataType();
        }
        this.graphTitle = "Graph of Type: " + type.getName();
        this.graphService = graphService;
    }

    public void run(TaskMonitor monitor) throws CancelledException {
        GraphType graphType = new GraphTypeBuilder("Data Graph").edgeType(REFERENCE).edgeType(COMPOSITE).build();
        GraphDisplayOptions options = new GraphDisplayOptionsBuilder(graphType).defaultVertexColor(Color.BLUE).edge(COMPOSITE, Color.MAGENTA).edge(REFERENCE, Color.BLUE).build();
        AttributedGraph graph = new AttributedGraph(this.graphTitle, graphType);
        try {
            if (this.type instanceof Pointer) {
                this.recursePointer((Pointer)this.type, graph, null, monitor);
            }
            if (this.type instanceof Composite) {
                this.recurseComposite((Composite)this.type, graph, null, null, monitor);
            }
        }
        catch (CancelledException e) {
            monitor.setMessage("Cancelling...");
            this.graphTitle = this.graphTitle + " (partial)";
        }
        try {
            GraphDisplay display = this.graphService.getGraphDisplay(false, monitor);
            display.setGraph(graph, options, this.graphTitle, false, monitor);
        }
        catch (GraphException e) {
            Msg.showError((Object)((Object)this), null, (String)"Data Type Graph Error", (Object)("Unexpected error while graphing: " + e.getMessage()), (Throwable)e);
        }
    }

    private void recurseComposite(Composite struct, AttributedGraph graph, AttributedVertex lastVertex, String edgeType, TaskMonitor monitor) throws CancelledException {
        AttributedVertex newVertex = new AttributedVertex(struct.getName());
        newVertex.setDescription(ToolTipUtils.getToolTipText((DataType)struct));
        if (lastVertex == null) {
            graph.addVertex(newVertex);
        } else {
            AttributedEdge edge = graph.addEdge(lastVertex, newVertex);
            edge.setEdgeType(edgeType);
            if (edge.hasAttribute("Weight")) {
                return;
            }
        }
        for (DataTypeComponent inner : struct.getComponents()) {
            monitor.checkCanceled();
            DataType dt = inner.getDataType();
            if (dt instanceof TypeDef) {
                dt = ((TypeDef)dt).getBaseDataType();
            }
            if (dt instanceof Pointer) {
                this.recursePointer((Pointer)dt, graph, newVertex, monitor);
                continue;
            }
            if (!(dt instanceof Composite)) continue;
            this.recurseComposite((Composite)dt, graph, newVertex, COMPOSITE, monitor);
        }
    }

    private void recursePointer(Pointer pointer, AttributedGraph graph, AttributedVertex lastVertex, TaskMonitor monitor) throws CancelledException {
        monitor.checkCanceled();
        DataType ptrType = pointer.getDataType();
        if (ptrType == null) {
            return;
        }
        if (ptrType instanceof TypeDef) {
            ptrType = ((TypeDef)ptrType).getBaseDataType();
        }
        if (ptrType instanceof Pointer) {
            this.recursePointer((Pointer)ptrType, graph, lastVertex, monitor);
        } else if (ptrType instanceof Composite) {
            this.recurseComposite((Composite)ptrType, graph, lastVertex, REFERENCE, monitor);
        }
    }
}

