/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.archive;

import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.BuiltInArchive;
import ghidra.app.plugin.core.datamgr.archive.DomainFileArchive;
import ghidra.framework.model.DomainFile;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.DuplicateFileException;
import java.awt.Component;
import java.io.IOException;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class ProgramArchive
implements DomainFileArchive {
    private static ImageIcon CLOSED_ICON = ResourceManager.loadImage((String)"images/closedBookRed.png");
    private static ImageIcon OPEN_ICON = ResourceManager.loadImage((String)"images/openBookRed.png");
    private final Program program;
    DataTypeManagerChangeListener categoryListener;
    private DataTypeManager dataTypeManager;

    ProgramArchive(Program program) {
        this.program = program;
        this.dataTypeManager = program.getDataTypeManager();
    }

    public Program getProgram() {
        return this.program;
    }

    public DataTypeManager getDataTypeManager() {
        return this.dataTypeManager;
    }

    @Override
    public String getName() {
        return this.dataTypeManager.getName();
    }

    @Override
    public int compareTo(Archive archive) {
        if (archive instanceof BuiltInArchive) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isChanged() {
        return false;
    }

    @Override
    public boolean isSavable() {
        return false;
    }

    @Override
    public void save() throws DuplicateFileException, IOException {
    }

    @Override
    public void saveAs(Component component) throws IOException {
    }

    @Override
    public DomainFile getDomainFile() {
        return this.program.getDomainFile();
    }

    public Program getDomainObject() {
        return this.program;
    }

    @Override
    public ImageIcon getIcon(boolean expanded) {
        return expanded ? OPEN_ICON : CLOSED_ICON;
    }
}

