/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.equate.EquateTablePlugin;
import ghidra.app.util.ToolTipUtils;
import ghidra.docking.settings.FormatSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.util.UniversalID;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import util.CollectionUtils;

class EquateTableModel
extends GDynamicColumnTableModel<Equate, Object> {
    private EquateTablePlugin plugin;
    private List<Equate> equateList = new ArrayList<Equate>();
    static final int NAME_COL = 0;
    static final int VALUE_COL = 1;
    static final int REFS_COL = 2;

    EquateTableModel(EquateTablePlugin plugin) {
        super((ServiceProvider)plugin.getTool());
        this.plugin = plugin;
    }

    private void populateEquates() {
        this.equateList.clear();
        Program program = this.plugin.getProgram();
        if (program == null) {
            this.fireTableDataChanged();
            return;
        }
        EquateTable equateTable = program.getEquateTable();
        this.equateList = CollectionUtils.asList((Iterator)equateTable.getEquates());
        this.fireTableDataChanged();
    }

    public String getName() {
        return "Equates";
    }

    public void update() {
        this.populateEquates();
    }

    public List<Equate> getModelData() {
        return this.equateList;
    }

    protected TableColumnDescriptor<Equate> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new EquateNameColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new EquateValueColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new EquateReferenceCountColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new IsEnumBasedEquateColumn());
        return descriptor;
    }

    public Object getDataSource() {
        return null;
    }

    public boolean isCellEditable(int row, int column) {
        if (!this.getColumnName(column).equals("Name")) {
            return false;
        }
        return !this.getEquate(row).getName().startsWith("dtID");
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!this.getColumnName(columnIndex).equals("Name")) {
            return;
        }
        if (!(aValue instanceof String)) {
            return;
        }
        this.plugin.renameEquate(this.equateList.get(rowIndex), (String)aValue);
    }

    public Equate getEquate(int rowIndex) {
        return this.equateList.get(rowIndex);
    }

    private class EquateNameColumn
    extends AbstractDynamicTableColumn<Equate, String, Object> {
        public static final String NAME = "Name";
        private GColumnRenderer<String> renderer = new AbstractGColumnRenderer<String>(){

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(data);
                boolean isSelected = data.isSelected();
                label.setText(" ");
                Equate eq = (Equate)data.getRowObject();
                if (eq == null) {
                    return label;
                }
                if (!eq.isValidUUID()) {
                    label.setForeground(isSelected ? Color.WHITE : Color.RED);
                } else if (!eq.isEnumBased()) {
                    label.setForeground(isSelected ? Color.WHITE : Color.BLUE.brighter());
                }
                String tooltip = this.getEquateToolTip(eq);
                label.setToolTipText(tooltip);
                label.setText((String)data.getValue());
                return label;
            }

            public String getFilterString(String t, Settings settings) {
                return t;
            }

            private String getEquateToolTip(Equate eq) {
                Program program = EquateTableModel.this.plugin.getProgram();
                ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
                UniversalID id = eq.getEnumUUID();
                if (id == null) {
                    return eq.getName();
                }
                Enum enoom = (Enum)dtm.findDataTypeForID(id);
                if (enoom == null) {
                    return null;
                }
                String tooltip = ToolTipUtils.getToolTipText((DataType)enoom);
                return tooltip;
            }
        };

        private EquateNameColumn() {
        }

        public String getColumnName() {
            return NAME;
        }

        public String getValue(Equate rowObject, Settings settings, Object data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getDisplayName();
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return this.renderer;
        }
    }

    private class EquateValueColumn
    extends AbstractDynamicTableColumn<Equate, Long, Object> {
        public static final String NAME = "Value";
        private GColumnRenderer<Long> renderer = new AbstractGColumnRenderer<Long>(){

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(data);
                Equate eq = (Equate)data.getRowObject();
                if (eq == null) {
                    return label;
                }
                label.setToolTipText(eq.getDisplayValue());
                return label;
            }

            public String getFilterString(Long t, Settings settings) {
                StringBuilder sb = new StringBuilder();
                sb.append(Long.toHexString(t)).append(" ").append(Long.toString(t));
                return sb.toString();
            }
        };

        private EquateValueColumn() {
        }

        public String getColumnName() {
            return NAME;
        }

        public Long getValue(Equate rowObject, Settings settings, Object data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            FormatSettingsDefinition formatDef = FormatSettingsDefinition.DEF;
            if (!formatDef.hasValue(settings)) {
                formatDef.setChoice(settings, 0);
            }
            return rowObject.getValue();
        }

        public GColumnRenderer<Long> getColumnRenderer() {
            return this.renderer;
        }
    }

    private class EquateReferenceCountColumn
    extends AbstractDynamicTableColumn<Equate, Integer, Object> {
        public static final String NAME = "# Refs";

        private EquateReferenceCountColumn() {
        }

        public String getColumnName() {
            return NAME;
        }

        public Integer getValue(Equate rowObject, Settings settings, Object data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getReferenceCount();
        }
    }

    private class IsEnumBasedEquateColumn
    extends AbstractDynamicTableColumn<Equate, Boolean, Object> {
        public static final String NAME = "Is Enum-Based";

        private IsEnumBasedEquateColumn() {
        }

        public String getColumnName() {
            return NAME;
        }

        public Boolean getValue(Equate rowObject, Settings settings, Object data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.isEnumBased();
        }
    }
}

