/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.fallthrough;

import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.fallthrough.FallThroughDialog;
import ghidra.app.plugin.core.fallthrough.FallThroughModel;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.ProgramLocation;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Changes the \"fall-through\" addresses", description="Provides actions for changing an instructions \"fall-through\" address.  Normally an instructions \"fall-through\" address is the address of the instruction that immediately follows it (except for jmp).  This plugin allows a user to overide this behaviour on specific situations.", eventsConsumed={ProgramLocationPluginEvent.class, ProgramActivatedPluginEvent.class, ProgramSelectionPluginEvent.class})
public class FallThroughPlugin
extends Plugin {
    private DockingAction clearFallthroughAction;
    private DockingAction autoFallthroughAction;
    private DockingAction setFallthroughAction;
    private Program currentProgram;

    public FallThroughPlugin(PluginTool tool) {
        super(tool);
        this.setupActions();
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramActivatedPluginEvent) {
            this.currentProgram = ((ProgramActivatedPluginEvent)event).getActiveProgram();
        }
    }

    Instruction getInstruction(ListingActionContext context) {
        Address address = context.getAddress();
        if (address != null) {
            return context.getProgram().getListing().getInstructionAt(address);
        }
        return null;
    }

    private void setupActions() {
        this.tool.setMenuGroup(new String[]{"Fallthrough"}, "references");
        this.autoFallthroughAction = new ListingContextAction("Auto Set Fallthroughs", this.getName()){

            @Override
            public void actionPerformed(ListingActionContext context) {
                FallThroughPlugin.this.autoOverride(context);
            }

            @Override
            protected boolean isEnabledForContext(ListingActionContext context) {
                if (context.hasSelection()) {
                    return true;
                }
                Instruction instruction = FallThroughPlugin.this.getInstruction(context);
                return instruction != null && !instruction.isFallThroughOverridden();
            }
        };
        this.autoFallthroughAction.setPopupMenuData(new MenuData(new String[]{"Fallthrough", "Auto Override"}, null, "Fallthrough"));
        this.tool.addAction((DockingActionIf)this.autoFallthroughAction);
        this.clearFallthroughAction = new ListingContextAction("Clear Fallthroughs", this.getName()){

            @Override
            public void actionPerformed(ListingActionContext context) {
                FallThroughPlugin.this.clearOverrides(context);
            }

            @Override
            protected boolean isEnabledForContext(ListingActionContext context) {
                if (context.hasSelection()) {
                    return true;
                }
                Instruction instruction = FallThroughPlugin.this.getInstruction(context);
                return instruction != null && instruction.isFallThroughOverridden();
            }
        };
        this.clearFallthroughAction.setPopupMenuData(new MenuData(new String[]{"Fallthrough", "Clear Overrides"}, null, "Fallthrough"));
        this.tool.addAction((DockingActionIf)this.clearFallthroughAction);
        this.setFallthroughAction = new ListingContextAction("Set Fallthrough", this.getName()){

            @Override
            public void actionPerformed(ListingActionContext context) {
                FallThroughPlugin.this.showDialog(context);
            }

            @Override
            protected boolean isEnabledForContext(ListingActionContext context) {
                Instruction instruction = FallThroughPlugin.this.getInstruction(context);
                return instruction != null;
            }
        };
        this.setFallthroughAction.setPopupMenuData(new MenuData(new String[]{"Fallthrough", "Set..."}, null, "Fallthrough"));
        this.tool.addAction((DockingActionIf)this.setFallthroughAction);
    }

    private void showDialog(ListingActionContext context) {
        FallThroughModel model = new FallThroughModel(this.tool, context.getProgram(), context.getAddress());
        FallThroughDialog fallThroughDialog = new FallThroughDialog(this, model);
        this.tool.showDialog((DialogComponentProvider)fallThroughDialog);
        model.dispose();
    }

    private void autoOverride(ListingActionContext context) {
        FallThroughModel model = new FallThroughModel(this.tool, context.getProgram(), context.getAddress());
        if (context.hasSelection()) {
            model.autoOverride(context.getSelection());
        } else {
            Address addr = context.getAddress();
            model.autoOverride((AddressSetView)new AddressSet(addr, addr));
        }
        model.dispose();
    }

    private void clearOverrides(ListingActionContext context) {
        FallThroughModel model = new FallThroughModel(this.tool, context.getProgram(), context.getAddress());
        if (context.hasSelection()) {
            model.clearOverride(context.getSelection());
        } else {
            Address addr = context.getAddress();
            model.clearOverride((AddressSetView)new AddressSet(addr, addr));
        }
        model.dispose();
    }

    public void dispose() {
        this.clearFallthroughAction.dispose();
        this.autoFallthroughAction.dispose();
    }

    void goTo(Address address) {
        GoToService goToService = (GoToService)this.tool.getService(GoToService.class);
        if (goToService != null) {
            goToService.goTo((ProgramLocation)new AddressFieldLocation(this.currentProgram, address));
        }
    }
}

