/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.script;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingUtils;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import docking.action.ToolBarData;
import docking.action.builder.AbstractActionBuilder;
import docking.action.builder.ActionBuilder;
import docking.actions.KeyBindingUtils;
import docking.widgets.table.GTable;
import generic.jar.ResourceFile;
import ghidra.app.plugin.core.script.GhidraScriptComponentProvider;
import ghidra.app.plugin.core.script.GhidraScriptMgrPlugin;
import ghidra.app.plugin.core.script.ScriptAction;
import ghidra.app.plugin.core.script.ScriptSelectionDialog;
import ghidra.app.script.GhidraScriptInfoManager;
import ghidra.app.script.ScriptInfo;
import ghidra.framework.Application;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.BrowserLoader;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import resources.Icons;
import resources.ResourceManager;
import utilities.util.FileUtilities;

class GhidraScriptActionManager {
    public static final String RERUN_LAST_SHARED_ACTION_NAME = "Rerun Last Script";
    private static final KeyStroke RERUN_LAST_SCRIPT_KEYSTROKE = KeyStroke.getKeyStroke(82, DockingUtils.CONTROL_KEY_MODIFIER_MASK | 0x40);
    private static final String SCRIPT_ACTIONS_KEY = "Scripts_Actions_Key";
    private static final String RESOURCE_FILE_ACTION_RUN_GROUP = "1";
    private GhidraScriptComponentProvider provider;
    private GhidraScriptMgrPlugin plugin;
    private GhidraScriptInfoManager infoManager;
    private DockingAction showBundleStatusAction;
    private DockingAction newAction;
    private DockingAction runLastAction;
    private DockingAction globalRunLastAction;
    private DockingAction renameAction;
    private DockingAction keyBindingAction;
    private Map<ResourceFile, ScriptAction> actionMap = new HashMap<ResourceFile, ScriptAction>();

    GhidraScriptActionManager(GhidraScriptComponentProvider provider, GhidraScriptMgrPlugin plugin, GhidraScriptInfoManager infoManager) {
        this.provider = provider;
        this.plugin = plugin;
        this.infoManager = infoManager;
        this.createActions();
    }

    void dispose() {
        this.actionMap.values().forEach(DockingAction::dispose);
        this.actionMap.clear();
    }

    void restoreUserDefinedKeybindings(SaveState saveState) {
        String[] names;
        Collection<ResourceFile> dirs = this.provider.getBundleHost().getBundleFiles();
        block0: for (String name : names = saveState.getNames()) {
            for (ResourceFile dir : dirs) {
                ResourceFile script = new ResourceFile(dir, name);
                if (!script.exists()) continue;
                ScriptAction action = this.createAction(script);
                String strokeStr = saveState.getString(name, null);
                if (strokeStr == null || strokeStr.length() == 0) {
                    action.setKeyBindingData(null);
                    continue;
                }
                KeyStroke stroke = KeyBindingUtils.parseKeyStroke((String)strokeStr);
                if (stroke == null) continue block0;
                action.setKeyBindingData(new KeyBindingData(stroke));
            }
        }
    }

    void restoreScriptsThatAreInTool(SaveState saveState) {
        String[] array;
        for (String filename : array = saveState.getStrings(SCRIPT_ACTIONS_KEY, new String[0])) {
            ResourceFile file = generic.util.Path.fromPathString((String)filename);
            if (file.exists()) {
                ScriptInfo info = this.infoManager.getScriptInfo(file);
                if (info == null) continue;
                this.createAction(info.getSourceFile());
                continue;
            }
            Msg.info((Object)this, (Object)("Cannot find script for keybinding: '" + filename + "'"));
        }
    }

    void saveUserDefinedKeybindings(SaveState saveState) {
        Collection<ScriptAction> actions = this.actionMap.values();
        for (ScriptAction action : actions) {
            if (!action.isUserDefinedKeyBinding()) continue;
            ResourceFile scriptFile = action.getScript();
            ScriptInfo info = this.infoManager.getExistingScriptInfo(scriptFile);
            if (info == null) {
                Msg.showError((Object)this, (Component)this.provider.getComponent(), (String)"Bad state?", (Object)"action associated with a script that has no info");
                continue;
            }
            KeyStroke stroke = action.getKeyBinding();
            if (stroke == null) {
                saveState.putString(scriptFile.getName(), "");
                continue;
            }
            String strokeStr = KeyBindingUtils.parseKeyStroke((KeyStroke)stroke);
            saveState.putString(scriptFile.getName(), strokeStr);
        }
    }

    void saveScriptsThatAreInTool(SaveState saveState) {
        Set<ResourceFile> actionScriptFiles = this.actionMap.keySet();
        HashSet<String> scriptPaths = new HashSet<String>(actionScriptFiles.size());
        for (ResourceFile file : actionScriptFiles) {
            scriptPaths.add(generic.util.Path.toPathString((ResourceFile)file));
        }
        String[] array = scriptPaths.toArray(new String[scriptPaths.size()]);
        saveState.putStrings(SCRIPT_ACTIONS_KEY, array);
    }

    void notifyScriptWasRun() {
        String newDesc = "Rerun " + this.provider.getLastRunScript().getName();
        this.runLastAction.firePropertyChanged("description", (Object)"", (Object)newDesc);
        this.globalRunLastAction.firePropertyChanged("description", (Object)"", (Object)newDesc);
    }

    private DockingAction createScriptAction(String name, String menuEntry, String description, Icon icon, String toolBarGroup, Runnable runnable) {
        return (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(name, this.plugin.getName()).popupMenuPath(new String[]{menuEntry})).popupMenuIcon(icon)).toolBarIcon(icon)).toolBarGroup(toolBarGroup)).description(description)).enabled(false)).enabledWhen(context -> context.getContextObject() instanceof ResourceFile)).onAction(context -> runnable.run())).buildAndInstallLocal((ComponentProvider)this.provider);
    }

    private DockingAction createScriptTableAction(String name, String description, Icon icon, Runnable runnable) {
        return (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(name, this.plugin.getName()).popupMenuPath(new String[]{name})).popupMenuIcon(icon)).toolBarIcon(icon)).toolBarGroup(null)).description(description)).enabledWhen(context -> {
            Object contextObject = context.getContextObject();
            return contextObject instanceof GTable || contextObject instanceof ResourceFile;
        })).onAction(context -> runnable.run())).buildAndInstallLocal((ComponentProvider)this.provider);
    }

    private void createActions() {
        this.createScriptAction("Run", "Run Script", "Run Script", ResourceManager.loadImage((String)"images/play.png"), RESOURCE_FILE_ACTION_RUN_GROUP, this.provider::runScript);
        this.runLastAction = new RerunLastScriptAction(RESOURCE_FILE_ACTION_RUN_GROUP);
        this.plugin.getTool().addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.runLastAction);
        this.globalRunLastAction = new RerunLastScriptAction("Xtra");
        this.plugin.getTool().addAction((DockingActionIf)this.globalRunLastAction);
        this.createScriptAction("Edit", "Edit with basic editor", "Edit Script with basic editor", ResourceManager.loadImage((String)"images/accessories-text-editor.png"), null, this.provider::editScriptBuiltin);
        this.createScriptAction("EditEclipse", "Edit with Eclipse", "Edit Script with Eclipse", ResourceManager.loadImage((String)"images/eclipse.png"), null, this.provider::editScriptEclipse);
        this.keyBindingAction = this.createScriptAction("Key Binding", "Assign Key Binding", "Assign Key Binding", ResourceManager.loadImage((String)"images/key.png"), null, this.provider::assignKeyBinding);
        this.createScriptAction("Delete", "Delete", "Delete Script", ResourceManager.loadImage((String)"images/edit-delete.png"), null, this.provider::deleteScript);
        this.renameAction = this.createScriptAction("Rename", "Rename", "Rename Script", ResourceManager.loadImage((String)"images/textfield_rename.png"), null, this.provider::renameScript);
        this.newAction = this.createScriptTableAction("New", "Create New Script", ResourceManager.loadImage((String)"images/script_add.png"), this.provider::newScript);
        this.createScriptTableAction("Refresh", "Refresh Script List", Icons.REFRESH_ICON, this.provider::refresh);
        this.showBundleStatusAction = this.createScriptTableAction("Script Directories", "Manage Script Directories", ResourceManager.loadImage((String)"images/text_list_bullets.png"), this.provider::showBundleStatusComponent);
        ((ActionBuilder)((ActionBuilder)new ActionBuilder("Script Quick Launch", this.plugin.getName()).keyBinding(KeyStroke.getKeyStroke(83, DockingUtils.CONTROL_KEY_MODIFIER_MASK | 0x40))).onAction(this::chooseScript)).buildAndInstall((Tool)this.plugin.getTool());
        ImageIcon icon = ResourceManager.loadImage((String)"images/red-cross.png");
        Predicate<ActionContext> test = context -> {
            Object contextObject = context.getContextObject();
            return contextObject instanceof GTable || contextObject instanceof ResourceFile;
        };
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Ghidra API Help", this.plugin.getName()).popupMenuPath(new String[]{"Ghidra API Help"})).popupMenuIcon((Icon)icon)).popupWhen(test)).toolBarIcon((Icon)icon)).toolBarGroup(null)).description("Help")).helpLocation(new HelpLocation(this.plugin.getName(), "Help"))).enabledWhen(test)).onAction(context -> this.showGhidraScriptJavadoc())).buildAndInstallLocal((ComponentProvider)this.provider);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Ghidra API Help", this.plugin.getName()).menuGroup("AAAHelpContents")).menuPath(new String[]{"&Help", "Ghidra API Help"})).helpLocation(new HelpLocation("Misc", "Welcome_to_Ghidra_Help"))).inWindow(AbstractActionBuilder.When.ALWAYS)).onAction(context -> this.showGhidraScriptJavadoc())).buildAndInstall((Tool)this.plugin.getTool());
    }

    private void chooseScript(ActionContext actioncontext1) {
        List<ScriptInfo> scriptInfos = this.provider.getScriptInfos();
        ScriptSelectionDialog dialog = new ScriptSelectionDialog(this.plugin, scriptInfos);
        dialog.show();
        ScriptInfo chosenInfo = dialog.getUserChoice();
        if (chosenInfo == null) {
            return;
        }
        this.provider.runScript(chosenInfo.getSourceFile());
    }

    private void showGhidraScriptJavadoc() {
        if (SystemUtilities.isInDevelopmentMode()) {
            Msg.showWarn((Object)this, (Component)this.provider.getComponent(), (String)"Error Unzipping Javadoc File", (Object)"Cannot view Ghidra API Help in development mode.");
            return;
        }
        File zipFile = new File(Application.getInstallationDirectory().getFile(false), "docs/GhidraAPI_javadoc.zip");
        String version = Application.getApplicationVersion();
        File extractDir = new File(Application.getUserCacheDirectory(), "GhidraAPI_javadoc");
        File entryFile = new File(extractDir, version + "/api/ghidra/app/script/GhidraScript.html");
        LaunchJavadocTask task = new LaunchJavadocTask(zipFile, extractDir, entryFile, version);
        new TaskLauncher((Task)task, (Component)this.provider.getComponent());
    }

    HelpLocation getPathHelpLocation() {
        return new HelpLocation(this.plugin.getName(), this.showBundleStatusAction.getName());
    }

    HelpLocation getKeyBindingHelpLocation() {
        return new HelpLocation(this.plugin.getName(), this.keyBindingAction.getName());
    }

    HelpLocation getRenameHelpLocation() {
        return new HelpLocation(this.plugin.getName(), this.renameAction.getName());
    }

    HelpLocation getNewHelpLocation() {
        return new HelpLocation(this.plugin.getName(), this.newAction.getName());
    }

    ScriptAction get(ResourceFile script) {
        return this.actionMap.get(script);
    }

    boolean hasScriptAction(ResourceFile script) {
        return this.actionMap.containsKey(script);
    }

    synchronized ScriptAction createAction(ResourceFile script) {
        ScriptAction action = this.actionMap.get(script);
        if (action == null) {
            action = new ScriptAction(this.plugin, script);
            this.actionMap.put(script, action);
        }
        return action;
    }

    synchronized void removeAction(ResourceFile script) {
        ScriptAction action = this.actionMap.remove(script);
        if (action != null) {
            action.dispose();
            this.plugin.getTool().removeAction((DockingActionIf)action);
        }
    }

    KeyStroke getKeyBinding(ResourceFile script) {
        ScriptAction action = this.actionMap.get(script);
        if (action != null) {
            return action.getKeyBinding();
        }
        return null;
    }

    private class RerunLastScriptAction
    extends DockingAction {
        RerunLastScriptAction(String toolbarGroup) {
            super(GhidraScriptActionManager.RERUN_LAST_SHARED_ACTION_NAME, GhidraScriptActionManager.this.plugin.getName(), KeyBindingType.SHARED);
            this.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/play_again.png"), toolbarGroup));
            this.setDescription("Rerun the last run script");
            this.setHelpLocation(new HelpLocation(GhidraScriptActionManager.this.plugin.getName(), "Run_Last"));
            this.initKeyStroke(RERUN_LAST_SCRIPT_KEYSTROKE);
        }

        private void initKeyStroke(KeyStroke keyStroke) {
            if (keyStroke == null) {
                return;
            }
            this.setKeyBindingData(new KeyBindingData(keyStroke));
        }

        public void actionPerformed(ActionContext context) {
            GhidraScriptActionManager.this.provider.runLastScript();
        }

        public boolean isEnabledForContext(ActionContext context) {
            return GhidraScriptActionManager.this.provider.getLastRunScript() != null;
        }
    }

    private class LaunchJavadocTask
    extends Task {
        private final File zipFile;
        private final File extractDir;
        private final File entryFile;
        private final String version;

        LaunchJavadocTask(File zipFile, File extractDir, File entryFile, String version) {
            super("Extract Javadoc Task", true, true, true);
            this.zipFile = zipFile;
            this.extractDir = extractDir;
            this.entryFile = entryFile;
            this.version = version;
        }

        public void run(TaskMonitor monitor) {
            if (!this.zipFile.exists()) {
                Msg.showError((Object)GhidraScriptActionManager.this, (Component)GhidraScriptActionManager.this.provider.getComponent(), (String)"Unexpected Error Unzipping Javadoc File", (Object)("Javadoc zip file does not exist at expected path: " + this.zipFile.getAbsolutePath()));
                return;
            }
            if (this.extractDir.exists()) {
                for (File dir : this.extractDir.listFiles(File::isDirectory)) {
                    if (dir.getName().equals(this.version)) continue;
                    this.cleanup(monitor, dir);
                }
            }
            File versionedExtractDir = new File(this.extractDir, this.version);
            try (ZipFile zipFileObject = new ZipFile(this.zipFile);){
                if (versionedExtractDir.exists()) {
                    try (Stream<Path> walk = Files.walk(versionedExtractDir.toPath(), new FileVisitOption[0]);){
                        if ((long)(zipFileObject.size() + 1) == walk.count()) {
                            this.launchJavadoc();
                            return;
                        }
                    }
                    this.cleanup(monitor, versionedExtractDir);
                }
                monitor.setMessage("Preparing to extract Ghidra API javadoc...");
                monitor.initialize((long)zipFileObject.size());
                Enumeration<? extends ZipEntry> entries = zipFileObject.entries();
                while (entries.hasMoreElements()) {
                    if (monitor.isCancelled()) {
                        this.cleanup(monitor, versionedExtractDir);
                        return;
                    }
                    ZipEntry entry = entries.nextElement();
                    monitor.setMessage("Extracting " + entry.getName() + "...");
                    this.writeZipEntry(versionedExtractDir, entry, zipFileObject.getInputStream(entry));
                    monitor.incrementProgress(1L);
                }
                monitor.setMessage("Launching native viewer for " + this.entryFile.getName());
                this.launchJavadoc();
            }
            catch (IOException e) {
                Msg.showError((Object)GhidraScriptActionManager.this, (Component)GhidraScriptActionManager.this.provider.getComponent(), (String)"Unexpected Error Unzipping Javadoc File", (Object)"Unexpected error unzipping javadoc file", (Throwable)e);
                this.cleanup(monitor, versionedExtractDir);
            }
        }

        private void cleanup(TaskMonitor monitor, File dir) {
            monitor.setMessage("Deleting " + dir.getName() + "...");
            FileUtilities.deleteDir((File)dir);
        }

        private void launchJavadoc() {
            URI uri = this.entryFile.toURI();
            URL url = null;
            try {
                url = uri.toURL();
            }
            catch (MalformedURLException e) {
                Msg.showError((Object)GhidraScriptActionManager.this, (Component)GhidraScriptActionManager.this.provider.getComponent(), (String)"Unexpected Error Showing Script Help", (Object)"Unexpectedly could not create a URL for the GhidraScript javadoc", (Throwable)e);
                return;
            }
            BrowserLoader.display(url, url, (ServiceProvider)GhidraScriptActionManager.this.plugin.getTool());
        }

        private void writeZipEntry(File unzipDirectory, ZipEntry entry, InputStream inputStream) throws IOException {
            String zipName = entry.getName();
            if (zipName.endsWith("/")) {
                new File(unzipDirectory, zipName).mkdirs();
                return;
            }
            File file = new File(unzipDirectory, zipName);
            this.mkdirs(file);
            FileOutputStream ouputStream = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            int bytesRead = -1;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                ouputStream.write(buffer, 0, bytesRead);
            }
            inputStream.close();
            ouputStream.close();
        }

        private void mkdirs(File file) {
            String filename = file.getName();
            if (filename.endsWith("/")) {
                file.mkdirs();
            } else {
                File parentFile = file.getParentFile();
                parentFile.mkdirs();
            }
        }
    }
}

