/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchmem.mask;

import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.NavigatableContextAction;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.searchmem.mask.MaskGenerator;
import ghidra.app.plugin.core.searchmem.mask.MaskValue;
import ghidra.app.plugin.core.searchmem.mask.SLMaskControl;
import ghidra.app.services.MemorySearchService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Search for Matching Instructions", description="This plugin will use the selected instructions and build a combined mask/value buffer. Memory is then searched looking for this combined value buffer that represents the selected instructions. This automates the process of searching through memory for a particular ordering of instructions by hand.", servicesRequired={MemorySearchService.class}, eventsConsumed={ProgramSelectionPluginEvent.class})
public class MnemonicSearchPlugin
extends Plugin {
    static final String MENU_PULLRIGHT = "For Matching Instructions";
    static final String POPUP_MENU_GROUP = "Search";
    private NavigatableContextAction setSearchMnemonicOpsNoConstAction;
    private NavigatableContextAction setSearchMnemonicOpsConstAction;
    private NavigatableContextAction setSearchMnemonicNoOpsNoConstAction;
    public String maskedBitString;

    public MnemonicSearchPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    private void processAction(NavigatableActionContext context, boolean useOps, boolean useConsts) {
        NavigatableActionContext newContext = (NavigatableActionContext)context.getContextObject();
        Program program = newContext.getProgram();
        ProgramSelection selection = newContext.getSelection();
        if (selection.getNumAddressRanges() > 1) {
            Msg.showInfo((Object)((Object)this), (Component)context.getComponentProvider().getComponent(), (String)"Mnemonic Search Error", (Object)"Multiple selected regions are not allowed; please limit to one.");
            return;
        }
        SLMaskControl maskControl = new SLMaskControl(useOps, useConsts);
        MaskGenerator generator = new MaskGenerator(maskControl);
        MaskValue mask = generator.getMask(program, selection);
        if (mask != null) {
            this.maskedBitString = this.createMaskedBitString(mask.getValue(), mask.getMask());
            byte[] maskedBytes = this.maskedBitString.getBytes();
            MemorySearchService memorySearchService = (MemorySearchService)this.tool.getService(MemorySearchService.class);
            memorySearchService.setIsMnemonic(true);
            memorySearchService.search(maskedBytes, newContext);
            memorySearchService.setSearchText(this.maskedBitString);
        }
    }

    private void createActions() {
        String group = "search for";
        String pullRightGroup = "0";
        this.tool.setMenuGroup(new String[]{"&Search", MENU_PULLRIGHT}, group, pullRightGroup);
        HelpLocation helpLocation = new HelpLocation(POPUP_MENU_GROUP, "Mnemonic_Search");
        this.setSearchMnemonicOpsNoConstAction = new NavigatableContextAction("Include Operands (except constants)", this.getName()){

            @Override
            public void actionPerformed(NavigatableActionContext context) {
                MnemonicSearchPlugin.this.processAction(context, true, false);
            }

            @Override
            protected boolean isEnabledForContext(NavigatableActionContext context) {
                return context.hasSelection();
            }
        };
        this.setSearchMnemonicOpsNoConstAction.setMenuBarData(new MenuData(new String[]{"&Search", MENU_PULLRIGHT, "Include Operands (except constants)"}, null, group, -1, "3"));
        this.setSearchMnemonicOpsNoConstAction.setHelpLocation(helpLocation);
        this.setSearchMnemonicOpsNoConstAction.addToWindowWhen(NavigatableActionContext.class);
        this.setSearchMnemonicOpsConstAction = new NavigatableContextAction("Include Operands", this.getName()){

            @Override
            public void actionPerformed(NavigatableActionContext context) {
                MnemonicSearchPlugin.this.processAction(context, true, true);
            }

            @Override
            protected boolean isEnabledForContext(NavigatableActionContext context) {
                return context.hasSelection();
            }
        };
        this.setSearchMnemonicOpsConstAction.setMenuBarData(new MenuData(new String[]{"&Search", MENU_PULLRIGHT, "Include Operands"}, null, group, -1, "2"));
        this.setSearchMnemonicOpsConstAction.setHelpLocation(helpLocation);
        this.setSearchMnemonicOpsConstAction.addToWindowWhen(NavigatableActionContext.class);
        this.setSearchMnemonicNoOpsNoConstAction = new NavigatableContextAction("Exclude Operands", this.getName()){

            @Override
            public void actionPerformed(NavigatableActionContext context) {
                MnemonicSearchPlugin.this.processAction(context, false, false);
            }

            @Override
            protected boolean isEnabledForContext(NavigatableActionContext context) {
                return context.hasSelection();
            }
        };
        this.setSearchMnemonicNoOpsNoConstAction.setMenuBarData(new MenuData(new String[]{"&Search", MENU_PULLRIGHT, "Exclude Operands"}, null, group, -1, "1"));
        this.setSearchMnemonicNoOpsNoConstAction.setHelpLocation(helpLocation);
        this.setSearchMnemonicNoOpsNoConstAction.addToWindowWhen(NavigatableActionContext.class);
        this.tool.addAction((DockingActionIf)this.setSearchMnemonicOpsNoConstAction);
        this.tool.addAction((DockingActionIf)this.setSearchMnemonicOpsConstAction);
        this.tool.addAction((DockingActionIf)this.setSearchMnemonicNoOpsNoConstAction);
        this.tool.setMenuGroup(new String[]{MENU_PULLRIGHT}, POPUP_MENU_GROUP);
    }

    private String createMaskedBitString(byte[] values, byte[] masks) {
        String bitString = new String();
        if (values.length != masks.length) {
            return null;
        }
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                bitString = (masks[i] >> 7 - j & 1) == 0 ? bitString.concat(".") : ((values[i] >> 7 - j & 1) == 0 ? bitString.concat("0") : bitString.concat("1"));
            }
            bitString = bitString.concat(" ");
        }
        return bitString;
    }
}

