/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc.datatype;

import ghidra.docking.settings.FormatSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.PaddingSettingsDefinition;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;

public class PcRelative31AddressDataType
extends BuiltIn {
    private static final FormatSettingsDefinition FORMAT = FormatSettingsDefinition.DEF;
    private static final PaddingSettingsDefinition PADDING = PaddingSettingsDefinition.DEF;
    private static SettingsDefinition[] SETTINGS_DEFS = new SettingsDefinition[]{FORMAT, PADDING};
    public static final PcRelative31AddressDataType dataType = new PcRelative31AddressDataType();

    public PcRelative31AddressDataType() {
        this(null);
    }

    public PcRelative31AddressDataType(DataTypeManager dtm) {
        super(null, "prel31", dtm);
    }

    protected SettingsDefinition[] getBuiltInSettingsDefinitions() {
        return SETTINGS_DEFS;
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new PcRelative31AddressDataType(dtm);
    }

    public String getMnemonic(Settings settings) {
        return this.name;
    }

    public int getLength() {
        return 4;
    }

    public String getDescription() {
        return "PC-Relative address using bottom 31 bits";
    }

    public Object getValue(MemBuffer buf, Settings settings, int length) {
        try {
            int ptr = buf.getInt(0) & 0xFFFFFFFF;
            int offset = (ptr |= Integer.MIN_VALUE) << 1 >> 1;
            return buf.getAddress().add((long)offset);
        }
        catch (AddressOutOfBoundsException | MemoryAccessException mae) {
            return null;
        }
    }

    public Class<?> getValueClass(Settings settings) {
        return Address.class;
    }

    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        Address addr = (Address)this.getValue(buf, settings, length);
        if (addr == null) {
            return "??";
        }
        return addr.toString();
    }
}

