/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next;

import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.app.util.bin.format.dwarf4.DWARFException;
import ghidra.app.util.bin.format.dwarf4.next.DWARFDataTypeManager;
import ghidra.app.util.bin.format.dwarf4.next.DWARFFunctionImporter;
import ghidra.app.util.bin.format.dwarf4.next.DWARFImportOptions;
import ghidra.app.util.bin.format.dwarf4.next.DWARFImportSummary;
import ghidra.app.util.bin.format.dwarf4.next.DWARFProgram;
import ghidra.app.util.bin.format.dwarf4.next.DWARFSourceInfo;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import utility.function.Dummy;

public class DWARFParser {
    private DWARFProgram prog;
    private DWARFDataTypeManager dwarfDTM;
    private TaskMonitor monitor;
    private DWARFImportOptions importOptions;
    private DWARFImportSummary importSummary = new DWARFImportSummary();

    public DWARFParser(DWARFProgram prog, DataTypeManager builtInDTM, TaskMonitor monitor) {
        this.prog = prog;
        this.monitor = monitor;
        this.importOptions = prog.getImportOptions();
        this.dwarfDTM = new DWARFDataTypeManager(prog, (DataTypeManager)prog.getGhidraProgram().getDataTypeManager(), builtInDTM, this.importSummary);
    }

    public DWARFImportOptions getImportOptions() {
        return this.importOptions;
    }

    private void moveTypesIntoSourceFolders() throws CancelledException {
        List<DataTypePath> importedTypes = this.dwarfDTM.getImportedTypes();
        Collections.sort(importedTypes, (dtp1, dtp2) -> dtp1.getCategoryPath().getPath().compareTo(dtp2.getCategoryPath().getPath()));
        this.monitor.setIndeterminate(false);
        this.monitor.setShowProgressValue(true);
        this.monitor.initialize((long)importedTypes.size());
        this.monitor.setMessage("DWARF Move Types");
        CategoryPath unCatRootCp = this.prog.getUncategorizedRootDNI().getOrganizationalCategoryPath();
        CategoryPath rootCP = this.prog.getRootDNI().asCategoryPath();
        for (DataTypePath dataTypePath : importedTypes) {
            DWARFSourceInfo dsi;
            DataType dataType;
            this.monitor.checkCanceled();
            this.monitor.incrementProgress(1L);
            if (this.monitor.getProgress() % 5L == 0L) {
                Swing.runNow((Runnable)Dummy.runnable());
            }
            if ((dataType = this.prog.getGhidraProgram().getDataTypeManager().getDataType(dataTypePath)) == null || dataType instanceof Pointer || dataType instanceof Array || (dsi = this.dwarfDTM.getSourceInfo(dataType)) == null || dsi.getFilename() == null) continue;
            CategoryPath dataTypeOrigCP = dataType.getCategoryPath();
            CategoryPath newRoot = new CategoryPath(rootCP, new String[]{dsi.getFilename()});
            CategoryPath newCP = this.rehomeCategoryPathSubTree(unCatRootCp, newRoot, dataTypeOrigCP);
            if (newCP == null) continue;
            try {
                dataType.setCategoryPath(newCP);
                if (dataType instanceof Composite) {
                    this.fixupAnonStructMembers((Composite)dataType, dataTypeOrigCP, newCP);
                }
                this.deleteEmptyCategoryPaths(dataTypeOrigCP);
            }
            catch (DuplicateNameException e) {
                Msg.error((Object)this, (Object)("Failed to move " + dataType.getDataTypePath() + " to " + newCP));
            }
        }
        this.monitor.setMessage("DWARF Move Types - Done");
    }

    private void fixupAnonStructMembers(Composite compositeDataType, CategoryPath origCategoryPath, CategoryPath newCP) throws DuplicateNameException {
        CategoryPath origCompositeNSCP = new CategoryPath(origCategoryPath, new String[]{compositeDataType.getName()});
        CategoryPath destCompositeNSCP = new CategoryPath(newCP, new String[]{compositeDataType.getName()});
        for (DataTypeComponent component : compositeDataType.getDefinedComponents()) {
            DataType dtcDT = component.getDataType();
            if (dtcDT instanceof Array || dtcDT instanceof Pointer) {
                dtcDT = DataTypeUtils.getNamedBaseDataType(dtcDT);
            }
            if (!dtcDT.getCategoryPath().equals((Object)origCompositeNSCP) || this.dwarfDTM.getSourceInfo(dtcDT) != null) continue;
            dtcDT.setCategoryPath(destCompositeNSCP);
        }
        this.deleteEmptyCategoryPaths(origCompositeNSCP);
    }

    private void deleteEmptyCategoryPaths(CategoryPath cp) {
        ProgramBasedDataTypeManager dtm = this.prog.getGhidraProgram().getDataTypeManager();
        while (!CategoryPath.ROOT.equals((Object)cp)) {
            Category cat = dtm.getCategory(cp);
            Category parentCat = dtm.getCategory(cp.getParent());
            if (cat == null || parentCat == null || cat.getDataTypes().length != 0 || cat.getCategories().length != 0) break;
            if (!parentCat.removeEmptyCategory(cat.getName(), this.monitor)) {
                Msg.error((Object)this, (Object)("Failed to delete empty category " + cp));
                break;
            }
            cp = parentCat.getCategoryPath();
        }
    }

    private CategoryPath rehomeCategoryPathSubTree(CategoryPath origRoot, CategoryPath newRoot, CategoryPath cp) {
        if (origRoot.equals((Object)cp)) {
            return newRoot;
        }
        List origRootParts = origRoot.asList();
        List cpParts = cp.asList();
        if (cpParts.size() < origRootParts.size() || !origRootParts.equals(cpParts.subList(0, origRootParts.size()))) {
            return null;
        }
        return new CategoryPath(newRoot, cpParts.subList(origRootParts.size(), cpParts.size()));
    }

    public DWARFImportSummary parse() throws IOException, DWARFException, CancelledException {
        this.monitor.setIndeterminate(false);
        this.monitor.setShowProgressValue(true);
        long start_ts = System.currentTimeMillis();
        if (this.importOptions.isImportDataTypes()) {
            this.dwarfDTM.importAllDataTypes(this.monitor);
            this.prog.getGhidraProgram().flushEvents();
            this.importSummary.dataTypeElapsedMS = System.currentTimeMillis() - start_ts;
        }
        if (this.importOptions.isImportFuncs()) {
            long funcstart_ts = System.currentTimeMillis();
            DWARFFunctionImporter dfi = new DWARFFunctionImporter(this.prog, this.dwarfDTM, this.importOptions, this.importSummary, this.monitor);
            dfi.importFunctions();
            this.importSummary.funcsElapsedMS = System.currentTimeMillis() - funcstart_ts;
        }
        if (this.importOptions.isOrganizeTypesBySourceFile()) {
            this.moveTypesIntoSourceFolders();
        }
        this.importSummary.totalElapsedMS = System.currentTimeMillis() - start_ts;
        return this.importSummary;
    }
}

