/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pef;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ExportedSymbolHashSlot
implements StructConverter {
    private int symbolCount;
    private int indexOfFirstExportKey;

    ExportedSymbolHashSlot(BinaryReader reader) throws IOException {
        int countAndStart = reader.readNextInt();
        this.symbolCount = countAndStart >> 18;
        this.indexOfFirstExportKey = countAndStart & 0x12;
    }

    public int getSymbolCount() {
        return this.symbolCount;
    }

    public int getIndexOfFirstExportKey() {
        return this.indexOfFirstExportKey;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return new TypedefDataType("ExportedSymbolHashSlot", DWORD);
    }
}

