/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.xcoff;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.xcoff.XCoffFileHeader;
import ghidra.app.util.bin.format.xcoff.XCoffFileHeaderMagic;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public final class XCoffOptionalHeader
implements StructConverter {
    private static final char NL = '\n';
    public static final int AOUTHDRSZ = 72;
    private short o_magic;
    private short o_vstamp;
    private long o_tsize;
    private long o_dsize;
    private long o_bsize;
    private long o_entry;
    private long o_text_start;
    private long o_data_start;
    private long o_toc;
    private short o_snentry;
    private short o_sntext;
    private short o_sndata;
    private short o_sntoc;
    private short o_snloader;
    private short o_snbss;
    private short o_algntext;
    private short o_algndata;
    private byte[] o_modtype;
    private byte o_cpuflag;
    private byte o_cputype;
    private long o_maxstack;
    private long o_maxdata;
    private long o_debugger;
    private byte o_flags;
    private short o_sntdata;
    private short o_sntbss;

    XCoffOptionalHeader(BinaryReader reader, XCoffFileHeader header) throws IOException {
        this.o_magic = reader.readNextShort();
        this.o_vstamp = reader.readNextShort();
        if (XCoffFileHeaderMagic.is32bit(header)) {
            this.o_tsize = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.o_dsize = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.o_bsize = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.o_entry = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.o_text_start = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.o_data_start = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.o_toc = (long)reader.readNextInt() & 0xFFFFFFFFL;
        } else if (XCoffFileHeaderMagic.is64bit(header)) {
            this.o_tsize = reader.readNextLong();
            this.o_dsize = reader.readNextLong();
            this.o_bsize = reader.readNextLong();
            this.o_entry = reader.readNextLong();
            this.o_text_start = reader.readNextLong();
            this.o_data_start = reader.readNextLong();
            this.o_toc = reader.readNextLong();
        }
        this.o_snentry = reader.readNextShort();
        this.o_sntext = reader.readNextShort();
        this.o_sndata = reader.readNextShort();
        this.o_sntoc = reader.readNextShort();
        this.o_snloader = reader.readNextShort();
        this.o_snbss = reader.readNextShort();
        this.o_algntext = reader.readNextShort();
        this.o_algndata = reader.readNextShort();
        this.o_modtype = reader.readNextByteArray(2);
        this.o_cpuflag = reader.readNextByte();
        this.o_cputype = reader.readNextByte();
        if (XCoffFileHeaderMagic.is32bit(header)) {
            this.o_maxstack = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.o_maxdata = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.o_debugger = (long)reader.readNextInt() & 0xFFFFFFFFL;
        } else if (XCoffFileHeaderMagic.is64bit(header)) {
            this.o_maxstack = reader.readNextLong();
            this.o_maxdata = reader.readNextLong();
            this.o_debugger = reader.readNextLong();
        }
        this.o_flags = reader.readNextByte();
        this.o_sntdata = reader.readNextShort();
        this.o_sntbss = reader.readNextShort();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("OPTIONAL HEADER VALUES").append('\n');
        buffer.append("magic      = ").append(this.o_magic).append('\n');
        buffer.append("vstamp     = ").append(this.o_vstamp).append('\n');
        buffer.append("tsize      = ").append(this.o_tsize).append('\n');
        buffer.append("dsize      = ").append(this.o_dsize).append('\n');
        buffer.append("bsize      = ").append(this.o_bsize).append('\n');
        buffer.append("entry      = ").append(this.o_entry).append('\n');
        buffer.append("text_start = ").append(this.o_text_start).append('\n');
        buffer.append("data_start = ").append(this.o_data_start).append('\n');
        buffer.append("o_toc      = ").append(this.o_toc).append('\n');
        buffer.append("o_snentry  = ").append(this.o_snentry).append('\n');
        buffer.append("o_sntext   = ").append(this.getSectionNumberForText()).append('\n');
        buffer.append("o_sndata   = ").append(this.o_sndata).append('\n');
        buffer.append("o_sntoc    = ").append(this.o_sntoc).append('\n');
        buffer.append("o_snloader = ").append(this.o_snloader).append('\n');
        buffer.append("o_snbss    = ").append(this.o_snbss).append('\n');
        buffer.append("o_algntext = ").append(this.o_algntext).append('\n');
        buffer.append("o_algndata = ").append(this.o_algndata).append('\n');
        buffer.append("o_modtype  = ").append(this.o_modtype).append('\n');
        buffer.append("o_cpuflag  = ").append(this.o_cpuflag).append('\n');
        buffer.append("o_cputype  = ").append(this.o_cputype).append('\n');
        buffer.append("o_maxstack = ").append(this.o_maxstack).append('\n');
        buffer.append("o_maxdata  = ").append(this.o_maxdata).append('\n');
        buffer.append("o_flags    = ").append(this.o_flags).append('\n');
        buffer.append("o_debugger = ").append(this.o_debugger).append('\n');
        buffer.append("o_sntdata  = ").append(this.o_sntdata).append('\n');
        buffer.append("o_sntbss   = ").append(this.o_sntbss).append('\n');
        return buffer.toString();
    }

    public short getMagic() {
        return this.o_magic;
    }

    public short getVersionStamp() {
        return this.o_vstamp;
    }

    public long getTextSize() {
        return this.o_tsize;
    }

    public long getInitializedDataSize() {
        return this.o_dsize;
    }

    public long getUninitializedDataSize() {
        return this.o_bsize;
    }

    public long getEntry() {
        return this.o_entry;
    }

    public long getTextStart() {
        return this.o_text_start;
    }

    public long getDataStart() {
        return this.o_data_start;
    }

    public long getTOC() {
        return this.o_toc;
    }

    public short getSectionNumberForEntry() {
        return this.o_snentry;
    }

    public short getSectionNumberForText() {
        return this.o_sntext;
    }

    public short getSectionNumberForData() {
        return this.o_sndata;
    }

    public short getSectionNumberForTOC() {
        return this.o_sntoc;
    }

    public short getSectionNumberForLoader() {
        return this.o_snloader;
    }

    public short getSectionNumberForBss() {
        return this.o_snbss;
    }

    public short getMaxAlignmentForText() {
        return this.o_algntext;
    }

    public short getMaxAlignmentForData() {
        return this.o_algndata;
    }

    public String getModuleType() {
        return new String(this.o_modtype);
    }

    public byte getCpuFlag() {
        return this.o_cpuflag;
    }

    public byte getCpuType() {
        return this.o_cputype;
    }

    public long getMaxStackSize() {
        return this.o_maxstack;
    }

    public long getMaxDataSize() {
        return this.o_maxdata;
    }

    public long getDebugger() {
        return this.o_debugger;
    }

    public byte getFlags() {
        return this.o_flags;
    }

    public short getSectionNumberForTData() {
        return this.o_sntdata;
    }

    public short getSectionNumberForTBss() {
        return this.o_sntbss;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(XCoffOptionalHeader.class);
    }
}

