/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfExternalSymbol;
import ghidra.app.util.bin.format.omf.OmfFileHeader;
import ghidra.app.util.bin.format.omf.OmfFixupRecord;
import ghidra.app.util.bin.format.omf.OmfGroupRecord;
import ghidra.app.util.bin.format.omf.OmfSegmentHeader;
import ghidra.app.util.bin.format.omf.OmfSymbol;
import ghidra.app.util.bin.format.omf.OmfSymbolRecord;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramWrapperLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.DataConverter;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class OmfLoader
extends AbstractProgramWrapperLoader {
    public static final String OMF_NAME = "Relocatable Object Module Format (OMF)";
    public static final long MIN_BYTE_LENGTH = 11L;
    public static final long IMAGE_BASE = 8192L;
    public static final long MAX_UNINITIALIZED_FILL = 8192L;
    private ArrayList<OmfSymbol> externsyms = null;

    private String mapTranslator(String record) {
        if (record == null) {
            return null;
        }
        if (record.startsWith("Borland")) {
            return "borlandcpp";
        }
        if (record.startsWith("Delphi")) {
            return "borlanddelphi";
        }
        if (record.startsWith("CodeGear")) {
            return "codegearcpp";
        }
        return null;
    }

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (provider.length() < 11L) {
            return loadSpecs;
        }
        BinaryReader reader = OmfFileHeader.createReader(provider);
        if (OmfFileHeader.checkMagicNumber(reader)) {
            OmfFileHeader scan;
            reader.setPointerIndex(0);
            try {
                scan = OmfFileHeader.scan(reader, TaskMonitorAdapter.DUMMY_MONITOR, true);
            }
            catch (OmfException e) {
                throw new IOException("Bad header format: " + e.getMessage());
            }
            List<QueryResult> results = QueryOpinionService.query(this.getName(), scan.getMachineName(), this.mapTranslator(scan.getTranslator()));
            for (QueryResult result : results) {
                loadSpecs.add(new LoadSpec((Loader)this, 8192L, result));
            }
            if (loadSpecs.isEmpty()) {
                loadSpecs.add(new LoadSpec((Loader)this, 8192L, true));
            }
        }
        return loadSpecs;
    }

    @Override
    public String getName() {
        return OMF_NAME;
    }

    @Override
    protected void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program, TaskMonitor monitor, MessageLog log) throws IOException, CancelledException {
        OmfFileHeader header = null;
        BinaryReader reader = OmfFileHeader.createReader(provider);
        try {
            header = OmfFileHeader.parse(reader, monitor);
            header.resolveNames();
            header.sortSegmentDataBlocks();
            OmfFileHeader.doLinking(8192L, header.getSegments(), header.getGroups());
        }
        catch (OmfException ex) {
            if (header == null) {
                throw new IOException("OMF File header was corrupted");
            }
            log.appendMsg("File was corrupted - leaving partial program " + provider.getName());
        }
        MemoryBlockUtils.createFileBytes(program, provider, monitor);
        int id = program.startTransaction("loading program from OMF");
        boolean success = false;
        try {
            this.processSegmentHeaders(reader, header, program, monitor, log);
            this.processExternalSymbols(header, program, monitor, log);
            this.processPublicSymbols(header, program, monitor, log);
            this.processRelocations(header, program, monitor, log);
            success = true;
        }
        catch (AddressOverflowException e) {
            throw new IOException(e);
        }
        finally {
            program.endTransaction(id, success);
        }
    }

    private void relocationError(Program program, MessageLog log, OmfFixupRecord.FixupState state) {
        Object message;
        if (state.locAddress != null) {
            message = "Unable to process relocation at " + state.locAddress + " with type 0x" + Integer.toHexString(state.locationType);
            program.getBookmarkManager().setBookmark(state.locAddress, "Error", "Relocations", (String)message);
        } else {
            message = "Badly broken relocation";
        }
        log.appendMsg((String)message);
    }

    private void processRelocations(OmfFileHeader header, Program program, TaskMonitor monitor, MessageLog log) {
        ArrayList<OmfFixupRecord> fixups = header.getFixups();
        OmfFixupRecord.FixupState state = new OmfFixupRecord.FixupState(header, this.externsyms, program.getLanguage());
        DataConverter converter = DataConverter.getInstance((!header.isLittleEndian() ? 1 : 0) != 0);
        Iterator<OmfFixupRecord> iterator = fixups.iterator();
        block8: while (iterator.hasNext()) {
            OmfFixupRecord fixup;
            state.currentFixupRecord = fixup = iterator.next();
            OmfFixupRecord.Subrecord[] subrecs = fixup.getSubrecords();
            Memory memory = program.getMemory();
            for (OmfFixupRecord.Subrecord subrec : subrecs) {
                if (monitor.isCancelled()) continue block8;
                if (subrec.isThread()) {
                    ((OmfFixupRecord.ThreadSubrecord)subrec).updateState(state);
                    continue;
                }
                long finalvalue = -1L;
                byte[] origbytes = null;
                try {
                    OmfFixupRecord.FixupSubrecord fixsub = (OmfFixupRecord.FixupSubrecord)subrec;
                    state.clear();
                    fixsub.resolveFixup(state);
                    if (state.targetState == -1L || state.locAddress == null) {
                        this.relocationError(program, log, state);
                        continue;
                    }
                    switch (state.locationType) {
                        case 0: {
                            origbytes = new byte[1];
                            memory.getBytes(state.locAddress, origbytes);
                            finalvalue = state.targetState;
                            finalvalue = state.M ? (finalvalue += (long)origbytes[0]) : (finalvalue -= state.locAddress.getOffset() + 1L);
                            memory.setByte(state.locAddress, (byte)finalvalue);
                            break;
                        }
                        case 1: 
                        case 5: {
                            origbytes = new byte[2];
                            memory.getBytes(state.locAddress, origbytes);
                            finalvalue = state.targetState;
                            finalvalue = state.M ? (finalvalue += (long)converter.getShort(origbytes)) : (finalvalue -= state.locAddress.getOffset() + 2L);
                            memory.setShort(state.locAddress, (short)finalvalue);
                            break;
                        }
                        case 4: 
                        case 9: 
                        case 13: {
                            origbytes = new byte[4];
                            memory.getBytes(state.locAddress, origbytes);
                            finalvalue = state.targetState;
                            finalvalue = state.M ? (finalvalue += (long)converter.getInt(origbytes)) : (finalvalue -= state.locAddress.getOffset() + 4L);
                            memory.setInt(state.locAddress, (int)finalvalue);
                            break;
                        }
                        default: {
                            log.appendMsg("Unsupported relocation type " + Integer.toString(state.locationType) + " at 0x" + Long.toHexString(state.locAddress.getOffset()));
                            break;
                        }
                    }
                }
                catch (MemoryAccessException e) {
                    this.relocationError(program, log, state);
                    continue;
                }
                catch (OmfException e) {
                    this.relocationError(program, log, state);
                    continue;
                }
                long[] values = new long[]{finalvalue};
                program.getRelocationTable().add(state.locAddress, state.locationType, values, origbytes, null);
            }
        }
    }

    private void processSegmentHeaders(BinaryReader reader, OmfFileHeader header, Program program, TaskMonitor monitor, MessageLog log) throws AddressOverflowException, IOException {
        monitor.setMessage("Process segments...");
        Language language = program.getLanguage();
        ArrayList<OmfSegmentHeader> segments = header.getSegments();
        for (OmfSegmentHeader segment : segments) {
            if (monitor.isCancelled()) break;
            MemoryBlock block = null;
            long segmentSize = segment.getSegmentLength();
            Address segmentAddr = segment.getAddress(language);
            if (segmentSize == 0L) {
                block = program.getMemory().getBlock(segmentAddr);
                log.appendMsg("Empty Segment: " + segment.getName());
                continue;
            }
            if (segment.hasNonZeroData()) {
                block = MemoryBlockUtils.createInitializedBlock(program, false, segment.getName(), segmentAddr, segment.getRawDataStream(reader, log), segmentSize, "Address:0x" + Long.toHexString(segmentAddr.getOffset()) + " Size:0x" + Long.toHexString(segmentSize), null, segment.isReadable(), segment.isWritable(), segment.isExecutable(), log, monitor);
                if (block == null) continue;
                log.appendMsg("Created Initialized Block: " + segment.getName() + " @ " + segmentAddr);
                continue;
            }
            block = MemoryBlockUtils.createUninitializedBlock(program, false, segment.getName(), segmentAddr, segmentSize, "Address:0x" + Long.toHexString(segmentAddr.getOffset()) + " Size:0x" + Long.toHexString(segmentSize), null, segment.isReadable(), segment.isWritable(), segment.isExecutable(), log);
            if (block == null) continue;
            log.appendMsg("Created Uninitialized Block: " + segment.getName() + " @ " + segmentAddr);
        }
    }

    private Address findFreeAddress(Program program) {
        MemoryBlock[] blocks;
        Memory memory = program.getMemory();
        Address maxAddr = memory.getMinAddress();
        if (maxAddr == null) {
            return null;
        }
        for (MemoryBlock block : blocks = memory.getBlocks()) {
            Address blockEnd = block.getEnd().getPhysicalAddress();
            if (blockEnd.compareTo((Object)maxAddr) <= 0) continue;
            maxAddr = blockEnd;
        }
        Address externAddress = null;
        long newOffset = maxAddr.getOffset() + 4096L & 0xFFFFFFFFFFFFF000L;
        externAddress = maxAddr.getNewAddress(newOffset);
        return externAddress;
    }

    private void processPublicSymbols(OmfFileHeader header, Program program, TaskMonitor monitor, MessageLog log) {
        SymbolTable symbolTable = program.getSymbolTable();
        ArrayList<OmfSymbolRecord> symbols = header.getPublicSymbols();
        ArrayList<OmfSegmentHeader> segments = header.getSegments();
        ArrayList<OmfGroupRecord> groups = header.getGroups();
        Language language = program.getLanguage();
        monitor.setMessage("Creating Public Symbols");
        for (OmfSymbolRecord symbolrec : symbols) {
            if (monitor.isCancelled()) break;
            Address addrBase = null;
            if (symbolrec.getSegmentIndex() != 0) {
                OmfSegmentHeader baseSegment = segments.get(symbolrec.getSegmentIndex() - 1);
                addrBase = baseSegment.getAddress(language);
            } else if (symbolrec.getGroupIndex() != 0) {
                OmfGroupRecord baseGroup = groups.get(symbolrec.getGroupIndex() - 1);
                addrBase = baseGroup.getAddress(language);
            } else {
                addrBase = language.getDefaultSpace().getAddress(0L);
            }
            int numSymbols = symbolrec.numSymbols();
            for (int i = 0; i < numSymbols; ++i) {
                OmfSymbol symbol = symbolrec.getSymbol(i);
                Address address = addrBase.add(symbol.getOffset());
                symbol.setAddress(address);
                this.createSymbol(symbol, address, symbolTable, log);
            }
        }
    }

    private boolean createSymbol(OmfSymbol symbol, Address address, SymbolTable symbolTable, MessageLog log) {
        Symbol existingSym = symbolTable.getPrimarySymbol(address);
        String name = symbol.getName();
        Symbol sym = symbolTable.getGlobalSymbol(name, address);
        if (sym == null) {
            try {
                sym = symbolTable.createLabel(address, name, SourceType.IMPORTED);
            }
            catch (InvalidInputException e) {
                log.appendMsg("Unable to create symbol " + symbol.getName() + " at 0x" + Long.toHexString(address.getOffset()));
                return false;
            }
        }
        if (existingSym == null || !existingSym.isPrimary()) {
            sym.setPrimary();
        }
        return true;
    }

    private void processExternalSymbols(OmfFileHeader header, Program program, TaskMonitor monitor, MessageLog log) {
        ArrayList<OmfExternalSymbol> symbolrecs = header.getExternalSymbols();
        if (symbolrecs.size() == 0) {
            return;
        }
        Address externalAddress = this.findFreeAddress(program);
        if (externalAddress == null) {
            log.appendMsg("Serious problem, there is no memory at all for symbols!");
            return;
        }
        Address externalAddressStart = externalAddress;
        this.externsyms = new ArrayList();
        SymbolTable symbolTable = program.getSymbolTable();
        Language language = program.getLanguage();
        monitor.setMessage("Creating External Symbols");
        block0: for (OmfExternalSymbol symbolrec : symbolrecs) {
            OmfSymbol[] symbols;
            for (OmfSymbol symbol : symbols = symbolrec.getSymbols()) {
                if (monitor.isCancelled()) continue block0;
                Address address = null;
                if (symbol.getSegmentRef() != 0) {
                    OmfSegmentHeader segment = header.getExtraSegments().get(symbol.getSegmentRef() - 1);
                    address = segment.getAddress(language);
                    symbol.setAddress(address);
                    this.externsyms.add(symbol);
                    this.createSymbol(symbol, address, symbolTable, log);
                    continue;
                }
                address = externalAddress;
                symbol.setAddress(address);
                this.externsyms.add(symbol);
                if (!this.createSymbol(symbol, address, symbolTable, log)) continue;
                externalAddress = externalAddress.add(16L);
            }
        }
        this.createExternalBlock(program, log, externalAddress, externalAddressStart);
    }

    private void createExternalBlock(Program program, MessageLog log, Address externalAddress, Address externalAddressStart) {
        if (!externalAddressStart.equals((Object)externalAddress)) {
            long size = externalAddress.subtract(externalAddressStart);
            try {
                MemoryBlock block = program.getMemory().createUninitializedBlock("EXTERNAL", externalAddressStart, size, false);
                block.setWrite(true);
                Address current = externalAddressStart;
                while (current.compareTo((Object)externalAddress) < 0) {
                    this.createUndefined(program.getListing(), program.getMemory(), current, externalAddress.getAddressSpace().getPointerSize());
                    current = current.add((long)externalAddress.getAddressSpace().getPointerSize());
                }
            }
            catch (Exception e) {
                log.appendMsg("Error creating external memory block:  - " + e.getMessage());
            }
        }
    }

    private Data createUndefined(Listing listing, Memory memory, Address addr, int size) throws CodeUnitInsertionException {
        MemoryBlock block = memory.getBlock(addr);
        if (block == null || !block.isInitialized()) {
            return null;
        }
        DataType undefined = Undefined.getUndefinedDataType((int)size);
        return listing.createData(addr, undefined);
    }
}

