/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.util.Option;
import ghidra.app.util.OptionException;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.LoaderTier;
import ghidra.app.util.xml.ProgramInfo;
import ghidra.app.util.xml.ProgramXmlMgr;
import ghidra.app.util.xml.XmlProgramOptions;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.ExternalLanguageCompilerSpecQuery;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XmlLoader
extends AbstractProgramLoader {
    private static final String FILE_EXTENSION = ".xml";
    public static final String XML_SRC_NAME = "XML Input Format";
    private static Pattern ADDRESS_MODEL_PATTERN = Pattern.compile("(\\d+)-bit");

    @Override
    public LoaderTier getTier() {
        return LoaderTier.SPECIALIZED_TARGET_LOADER;
    }

    @Override
    public int getTierPriority() {
        return 50;
    }

    @Override
    public boolean supportsLoadIntoProgram() {
        return true;
    }

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ProgramInfo info;
        ArrayList<LoadSpec> loadSpecs;
        block14: {
            loadSpecs = new ArrayList<LoadSpec>();
            this.getLanguageService();
            ParseResult result = this.parse(provider);
            info = result.lastInfo;
            if (info == null) {
                return loadSpecs;
            }
            if (info.languageID != null) {
                try {
                    LanguageDescription languageDescription = this.getLanguageService().getLanguageDescription(info.languageID);
                    boolean preferred = false;
                    if (info.compilerSpecID == null) {
                        for (CompilerSpecDescription csd : languageDescription.getCompatibleCompilerSpecDescriptions()) {
                            LanguageCompilerSpecPair pair = new LanguageCompilerSpecPair(languageDescription.getLanguageID(), csd.getCompilerSpecID());
                            loadSpecs.add(new LoadSpec(this, 0L, pair, preferred));
                        }
                        break block14;
                    }
                    languageDescription.getCompilerSpecDescriptionByID(info.compilerSpecID);
                    LanguageCompilerSpecPair pair = new LanguageCompilerSpecPair(info.languageID, info.compilerSpecID);
                    preferred = true;
                    loadSpecs.add(new LoadSpec(this, 0L, pair, preferred));
                }
                catch (CompilerSpecNotFoundException | LanguageNotFoundException languageDescription) {}
            } else if (info.processorName != null) {
                Integer size = this.extractSize(info.addressModel);
                Endian endian = Endian.toEndian((String)info.endian);
                ExternalLanguageCompilerSpecQuery broadQuery = new ExternalLanguageCompilerSpecQuery(info.processorName, info.getNormalizedExternalToolName(), endian, size, info.compilerSpecID);
                List pairs = this.getLanguageService().getLanguageCompilerSpecPairs(broadQuery);
                if (!pairs.isEmpty()) {
                    boolean preferred = false;
                    if (pairs.size() == 1) {
                        preferred = true;
                    }
                    for (LanguageCompilerSpecPair pair : pairs) {
                        loadSpecs.add(new LoadSpec(this, 0L, pair, preferred));
                    }
                }
            }
        }
        if (loadSpecs.isEmpty()) {
            Endian endian = Endian.toEndian((String)info.endian);
            List languageDescriptions = this.getLanguageService().getLanguageDescriptions(false);
            for (LanguageDescription languageDescription : languageDescriptions) {
                if (endian != null && !languageDescription.getEndian().equals((Object)endian)) continue;
                Collection compilerSpecDescriptions = languageDescription.getCompatibleCompilerSpecDescriptions();
                for (CompilerSpecDescription compilerSpecDescription : compilerSpecDescriptions) {
                    LanguageCompilerSpecPair pair = new LanguageCompilerSpecPair(languageDescription.getLanguageID(), compilerSpecDescription.getCompilerSpecID());
                    loadSpecs.add(new LoadSpec(this, 0L, pair, false));
                }
            }
        }
        return loadSpecs;
    }

    @Override
    public String getPreferredFileName(ByteProvider provider) {
        String name = provider.getName();
        if (name.toLowerCase().endsWith(FILE_EXTENSION)) {
            return name.substring(0, name.length() - FILE_EXTENSION.length());
        }
        return name;
    }

    private Integer extractSize(String addressModel) {
        Matcher matcher;
        if (addressModel != null && (matcher = ADDRESS_MODEL_PATTERN.matcher(addressModel)).find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<AbstractProgramLoader.LoadedProgram> loadProgram(ByteProvider provider, String programName, DomainFolder programFolder, LoadSpec loadSpec, List<Option> options, MessageLog log, Object consumer, TaskMonitor monitor) throws IOException, CancelledException {
        ArrayList<AbstractProgramLoader.LoadedProgram> results = new ArrayList<AbstractProgramLoader.LoadedProgram>();
        LanguageCompilerSpecPair pair = loadSpec.getLanguageCompilerSpec();
        Language importerLanguage = this.getLanguageService().getLanguage(pair.languageID);
        CompilerSpec importerCompilerSpec = importerLanguage.getCompilerSpecByID(pair.compilerSpecID);
        ParseResult result = this.parse(provider);
        if (result.lastInfo == null) {
            return results;
        }
        Address imageBase = null;
        if (result.lastInfo.imageBase != null) {
            imageBase = importerLanguage.getAddressFactory().getAddress(result.lastInfo.imageBase);
        }
        Program prog = this.createProgram(provider, programName, imageBase, this.getName(), importerLanguage, importerCompilerSpec, consumer);
        boolean success = false;
        try {
            success = this.doImport(result.lastXmlMgr, options, log, prog, monitor, false);
            if (success) {
                this.createDefaultMemoryBlocks(prog, importerLanguage, log);
            }
        }
        finally {
            if (!success) {
                prog.release(consumer);
                prog = null;
            }
        }
        if (prog != null) {
            results.add(new AbstractProgramLoader.LoadedProgram(prog, programFolder));
        }
        return results;
    }

    @Override
    protected boolean loadProgramInto(ByteProvider provider, LoadSpec loadSpec, List<Option> options, MessageLog log, Program prog, TaskMonitor monitor) throws IOException, CancelledException {
        File file = provider.getFile();
        return this.doImport(new ProgramXmlMgr(file), options, log, prog, monitor, true);
    }

    private boolean doImportWork(ProgramXmlMgr mgr, List<Option> options, MessageLog log, Program prog, TaskMonitor monitor, boolean isAddToProgram) throws IOException {
        MessageLog mgrLog = null;
        boolean success = false;
        try {
            XmlProgramOptions xmlOptions = new XmlProgramOptions();
            xmlOptions.setOptions(options);
            xmlOptions.setAddToProgram(isAddToProgram);
            mgrLog = mgr.read(prog, monitor, xmlOptions);
            log.copyFrom(mgrLog);
            success = true;
        }
        catch (Exception e) {
            String message = "(empty)";
            if (mgrLog != null && !"".equals(mgrLog.toString())) {
                message = mgrLog.toString();
            }
            if (log != null && !"".equals(log.toString())) {
                message = log.toString();
            }
            Msg.warn((Object)this, (Object)("XML import exception, log: " + message), (Throwable)e);
            throw new IOException(e.getMessage(), e);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doImport(final ProgramXmlMgr mgr, final List<Option> options, final MessageLog log, Program prog, TaskMonitor monitor, final boolean isAddToProgram) throws IOException {
        if (!AutoAnalysisManager.hasAutoAnalysisManager(prog)) {
            int txId = prog.startTransaction("XML Import");
            try {
                boolean bl = this.doImportWork(mgr, options, log, prog, monitor, isAddToProgram);
                return bl;
            }
            finally {
                prog.endTransaction(txId, true);
            }
        }
        AutoAnalysisManager analysisMgr = AutoAnalysisManager.getAnalysisManager(prog);
        try {
            return analysisMgr.scheduleWorker(new AnalysisWorker(){

                @Override
                public String getWorkerName() {
                    return "XML Importer";
                }

                @Override
                public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor taskMonitor) throws Exception, CancelledException {
                    return XmlLoader.this.doImportWork(mgr, options, log, program, taskMonitor, isAddToProgram);
                }
            }, null, false, monitor);
        }
        catch (CancelledException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private ParseResult parse(ByteProvider provider) {
        try {
            ProgramXmlMgr lastXmlMgr = new ProgramXmlMgr(provider);
            ProgramInfo lastInfo = lastXmlMgr.getProgramInfo();
            return new ParseResult(lastXmlMgr, lastInfo);
        }
        catch (Throwable e) {
            Msg.trace((Object)this, (Object)("Unable to parse XML for " + provider.getName()), (Throwable)e);
            return new ParseResult(null, null);
        }
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        return new XmlProgramOptions().getOptions(loadIntoProgram);
    }

    @Override
    public String getName() {
        return XML_SRC_NAME;
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        try {
            new XmlProgramOptions().setOptions(options);
        }
        catch (OptionException e) {
            return e.getMessage();
        }
        return null;
    }

    private static class ParseResult {
        final ProgramXmlMgr lastXmlMgr;
        final ProgramInfo lastInfo;

        ParseResult(ProgramXmlMgr lastXmlMgr, ProgramInfo lastInfo) {
            this.lastXmlMgr = lastXmlMgr;
            this.lastInfo = lastInfo;
        }
    }
}

