/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcode;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.CompositeAttributedString;
import ghidra.app.plugin.processors.sleigh.template.OpTpl;
import ghidra.app.util.pcode.AbstractAppender;
import ghidra.app.util.pcode.AbstractPcodeFormatter;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import java.awt.Color;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.List;

public class AttributedStringPcodeFormatter
extends AbstractPcodeFormatter<List<AttributedString>, ToAttributedStringsAppender> {
    private int maxDisplayLines = 0;
    private boolean displayRawPcode = false;
    private FontMetrics metrics;
    private Color addressColor = OptionsGui.ADDRESS.getDefaultColor();
    private Color registerColor = OptionsGui.REGISTERS.getDefaultColor();
    private Color scalarColor = OptionsGui.CONSTANT.getDefaultColor();
    private Color localColor = OptionsGui.LABELS_LOCAL.getDefaultColor();
    private Color mnemonicColor = OptionsGui.MNEMONIC.getDefaultColor();
    private Color unimplColor = OptionsGui.UNIMPL.getDefaultColor();
    private Color separatorColor = OptionsGui.SEPARATOR.getDefaultColor();
    private Color lineLabelColor = OptionsGui.PCODE_LINE_LABEL.getDefaultColor();
    private Color spaceColor = OptionsGui.PCODE_ADDR_SPACE.getDefaultColor();
    private Color rawColor = OptionsGui.PCODE_RAW_VARNODE.getDefaultColor();
    private Color useropColor = OptionsGui.PCODE_USEROP.getDefaultColor();
    private AttributedString aSpace;
    private AttributedString aEquals;
    private AttributedString aComma;
    private AttributedString aLeftParen;
    private AttributedString aRightParen;
    private AttributedString aLeftBracket;
    private AttributedString aRightBracket;
    private AttributedString aStar;
    private AttributedString aColon;
    private AttributedString aQuote;

    public AttributedStringPcodeFormatter() {
        this.initPunctuation();
    }

    public void setAddressColor(Color addressColor) {
        this.addressColor = addressColor;
    }

    public void setRegisterColor(Color registerColor) {
        this.registerColor = registerColor;
    }

    public void setScalarColor(Color scalarColor) {
        this.scalarColor = scalarColor;
    }

    public void setLocalColor(Color localColor) {
        this.localColor = localColor;
    }

    public void setMnemonicColor(Color mnemonicColor) {
        this.mnemonicColor = mnemonicColor;
    }

    public void setUnimplColor(Color unimplColor) {
        this.unimplColor = unimplColor;
    }

    public void setSeparatorColor(Color separatorColor) {
        this.separatorColor = separatorColor;
        this.initPunctuation();
    }

    public void setLineLabelColor(Color lineLabelColor) {
        this.lineLabelColor = lineLabelColor;
    }

    public void setSpaceColor(Color spaceColor) {
        this.spaceColor = spaceColor;
    }

    public void setRawColor(Color rawColor) {
        this.rawColor = rawColor;
    }

    public void setUseropColor(Color useropColor) {
        this.useropColor = useropColor;
    }

    public void setFontMetrics(FontMetrics metrics) {
        this.metrics = metrics;
        this.initPunctuation();
    }

    public void setOptions(int maxDisplayLines, boolean displayRawPcode) {
        this.maxDisplayLines = maxDisplayLines;
        this.displayRawPcode = displayRawPcode;
    }

    private void initPunctuation() {
        this.aSpace = new AttributedString(" ", this.separatorColor, this.metrics);
        this.aEquals = new AttributedString(" = ", this.separatorColor, this.metrics);
        this.aComma = new AttributedString(",", this.separatorColor, this.metrics);
        this.aLeftParen = new AttributedString("(", this.separatorColor, this.metrics);
        this.aRightParen = new AttributedString(")", this.separatorColor, this.metrics);
        this.aLeftBracket = new AttributedString("[", this.separatorColor, this.metrics);
        this.aRightBracket = new AttributedString("]", this.separatorColor, this.metrics);
        this.aStar = new AttributedString("*", this.separatorColor, this.metrics);
        this.aColon = new AttributedString(":", this.separatorColor, this.metrics);
        this.aQuote = new AttributedString("\"", this.separatorColor, this.metrics);
    }

    @Override
    protected ToAttributedStringsAppender createAppender(Language language, boolean indent) {
        return new ToAttributedStringsAppender(language, indent);
    }

    @Override
    public boolean isFormatRaw() {
        return this.displayRawPcode;
    }

    @Override
    protected AbstractPcodeFormatter.FormatResult formatOpTemplate(ToAttributedStringsAppender appender, OpTpl op) {
        if (this.maxDisplayLines > 0 && appender.getLineCount() >= this.maxDisplayLines) {
            return AbstractPcodeFormatter.FormatResult.TERMINATE;
        }
        appender.startLine();
        AbstractPcodeFormatter.FormatResult result = super.formatOpTemplate(appender, op);
        appender.endLine();
        return result;
    }

    class ToAttributedStringsAppender
    extends AbstractAppender<List<AttributedString>> {
        private final List<AttributedString> list;
        private List<AttributedString> lineList;

        public ToAttributedStringsAppender(Language language, boolean indent) {
            super(language, indent);
            this.list = new ArrayList<AttributedString>();
        }

        int getLineCount() {
            return this.list.size();
        }

        void startLine() {
            this.lineList = new ArrayList<AttributedString>();
        }

        void endLine() {
            this.list.add((AttributedString)new CompositeAttributedString(this.lineList));
        }

        @Override
        public void appendLineLabelRef(long label) {
            this.lineList.add(new AttributedString(this.stringifyLineLabel(label), AttributedStringPcodeFormatter.this.lineLabelColor, AttributedStringPcodeFormatter.this.metrics));
        }

        @Override
        public void appendMnemonic(int opcode) {
            Color color = opcode == 0 ? AttributedStringPcodeFormatter.this.unimplColor : AttributedStringPcodeFormatter.this.mnemonicColor;
            this.lineList.add(new AttributedString(this.stringifyOpMnemonic(opcode), color, AttributedStringPcodeFormatter.this.metrics));
        }

        @Override
        public void appendUserop(int id) {
            this.lineList.add(new AttributedString(this.stringifyUserop(this.language, id), AttributedStringPcodeFormatter.this.useropColor, AttributedStringPcodeFormatter.this.metrics));
        }

        @Override
        public void appendRawVarnode(AddressSpace space, long offset, long size) {
            this.lineList.add(new AttributedString(this.stringifyRawVarnode(space, offset, size), AttributedStringPcodeFormatter.this.rawColor, AttributedStringPcodeFormatter.this.metrics));
        }

        private AttributedString getAttributedChar(char c) {
            switch (c) {
                case ' ': {
                    return AttributedStringPcodeFormatter.this.aSpace;
                }
                case '=': {
                    return AttributedStringPcodeFormatter.this.aEquals;
                }
                case ',': {
                    return AttributedStringPcodeFormatter.this.aComma;
                }
                case '(': {
                    return AttributedStringPcodeFormatter.this.aLeftParen;
                }
                case ')': {
                    return AttributedStringPcodeFormatter.this.aRightParen;
                }
                case '[': {
                    return AttributedStringPcodeFormatter.this.aLeftBracket;
                }
                case ']': {
                    return AttributedStringPcodeFormatter.this.aRightBracket;
                }
                case '*': {
                    return AttributedStringPcodeFormatter.this.aStar;
                }
                case ':': {
                    return AttributedStringPcodeFormatter.this.aColon;
                }
                case '\"': {
                    return AttributedStringPcodeFormatter.this.aQuote;
                }
            }
            throw new AssertionError();
        }

        @Override
        public void appendCharacter(char c) {
            this.lineList.add(this.getAttributedChar(c));
        }

        @Override
        public void appendAddressWordOffcut(long wordOffset, long offcut) {
            this.lineList.add(new AttributedString(this.stringifyWordOffcut(wordOffset, offcut), AttributedStringPcodeFormatter.this.addressColor, AttributedStringPcodeFormatter.this.metrics));
        }

        @Override
        public void appendLabel(String label) {
            this.lineList.add(new AttributedString(label, AttributedStringPcodeFormatter.this.localColor, AttributedStringPcodeFormatter.this.metrics));
        }

        @Override
        public void appendRegister(Register register) {
            this.lineList.add(new AttributedString(this.stringifyRegister(register), AttributedStringPcodeFormatter.this.registerColor, AttributedStringPcodeFormatter.this.metrics));
        }

        @Override
        public void appendScalar(long value) {
            this.lineList.add(new AttributedString(this.stringifyScalarValue(value), AttributedStringPcodeFormatter.this.scalarColor, AttributedStringPcodeFormatter.this.metrics));
        }

        @Override
        public void appendSpace(AddressSpace space) {
            this.lineList.add(new AttributedString(this.stringifySpace(space), AttributedStringPcodeFormatter.this.spaceColor, AttributedStringPcodeFormatter.this.metrics));
        }

        @Override
        public void appendUnique(long offset) {
            this.lineList.add(new AttributedString(this.stringifyUnique(offset), AttributedStringPcodeFormatter.this.localColor, AttributedStringPcodeFormatter.this.metrics));
        }

        @Override
        public List<AttributedString> finish() {
            return this.list;
        }
    }
}

