/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.FileOffsetFieldOptionsPropertyEditor;
import ghidra.app.util.viewer.field.FileOffsetFieldOptionsWrappedOption;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.CustomOption;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockSourceInfo;
import ghidra.program.util.FileOffsetFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.exception.AssertException;
import java.beans.PropertyEditor;
import java.math.BigInteger;

public class FileOffsetFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "File Offset";
    public static final String GROUP_TITLE = "File Offset Field";
    public static final String FILE_OFFSET_DISPLAY_OPTIONS_NAME = "File Offset Field.File Offset Display Options";
    private boolean showFilename;
    private boolean useHex;
    private PropertyEditor fileOffsetFieldOptionsEditor = new FileOffsetFieldOptionsPropertyEditor();

    public FileOffsetFieldFactory() {
        super(FIELD_NAME);
    }

    private FileOffsetFieldFactory(FieldFormatModel model, HighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
        this.initOptions(fieldOptions);
    }

    private void initOptions(Options fieldOptions) {
        HelpLocation helpLoc = new HelpLocation("CodeBrowserPlugin", "File_Offset_Field");
        fieldOptions.registerOption(FILE_OFFSET_DISPLAY_OPTIONS_NAME, OptionType.CUSTOM_TYPE, (Object)new FileOffsetFieldOptionsWrappedOption(), helpLoc, "Adjusts the File Offset Field display", this.fileOffsetFieldOptionsEditor);
        CustomOption customOption = fieldOptions.getCustomOption(FILE_OFFSET_DISPLAY_OPTIONS_NAME, null);
        if (!(customOption instanceof FileOffsetFieldOptionsWrappedOption)) {
            throw new AssertException("Someone set an option for File Offset Field.File Offset Display Options that is not the expected " + FileOffsetFieldOptionsWrappedOption.class.getName() + " type.");
        }
        FileOffsetFieldOptionsWrappedOption fofowo = (FileOffsetFieldOptionsWrappedOption)customOption;
        this.showFilename = fofowo.showFilename();
        this.useHex = fofowo.useHex();
        fieldOptions.getOptions(GROUP_TITLE).setOptionsHelpLocation(helpLoc);
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, HighlightProvider highlightProvider, ToolOptions options, ToolOptions fieldOptions) {
        return new FileOffsetFieldFactory(formatModel, highlightProvider, (Options)options, (Options)fieldOptions);
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionsName, Object oldValue, Object newValue) {
        if (optionsName.equals(FILE_OFFSET_DISPLAY_OPTIONS_NAME)) {
            FileOffsetFieldOptionsWrappedOption fofowo = (FileOffsetFieldOptionsWrappedOption)newValue;
            this.showFilename = fofowo.showFilename();
            this.useHex = fofowo.useHex();
            this.model.update();
        }
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        Address addr = cu.getAddress();
        MemoryBlock block = cu.getProgram().getMemory().getBlock(addr);
        Object text = "N/A";
        for (MemoryBlockSourceInfo sourceInfo : block.getSourceInfos()) {
            if (!sourceInfo.contains(addr) || !sourceInfo.getFileBytes().isPresent()) continue;
            FileBytes fileBytes = (FileBytes)sourceInfo.getFileBytes().get();
            long offset = sourceInfo.getFileBytesOffset(addr);
            text = this.useHex ? String.format("0x%x", offset) : String.format("%d", offset);
            if (!this.showFilename) break;
            text = fileBytes.getFilename() + ":" + (String)text;
            break;
        }
        TextFieldElement fieldElement = new TextFieldElement(new AttributedString((String)text, this.color, this.getMetrics()), 0, 0);
        ListingTextField listingTextField = ListingTextField.createSingleLineTextField(this, proxy, (FieldElement)fieldElement, this.startX + varWidth, this.width, this.hlProvider);
        listingTextField.setPrimary(true);
        return listingTextField;
    }

    @Override
    public FieldLocation getFieldLocation(ListingField lf, BigInteger index, int fieldNum, ProgramLocation loc) {
        if (loc instanceof FileOffsetFieldLocation) {
            FileOffsetFieldLocation fileOffsetFieldLoc = (FileOffsetFieldLocation)loc;
            Object obj = lf.getProxy().getObject();
            if (obj instanceof CodeUnit && this.hasSamePath(lf, (ProgramLocation)fileOffsetFieldLoc)) {
                return new FieldLocation(index, fieldNum, 0, fileOffsetFieldLoc.getCharOffset());
            }
        }
        return null;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField lf) {
        Object obj = lf.getProxy().getObject();
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        Address addr = cu.getMinAddress();
        int[] cpath = null;
        if (cu instanceof Data) {
            cpath = ((Data)cu).getComponentPath();
        }
        return new FileOffsetFieldLocation(cu.getProgram(), addr, cpath, col);
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!CodeUnit.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 4 || category == 5 || category == 6;
    }
}

