/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import ghidra.app.nav.Navigatable;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.viewer.field.AnnotatedStringHandler;
import ghidra.app.util.viewer.field.AnnotationException;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Program;
import ghidra.util.BrowserLoader;
import ghidra.util.Msg;
import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;

public class URLAnnotatedStringHandler
implements AnnotatedStringHandler {
    private static final String INVALID_SYMBOL_TEXT = "@url annotation must have a URL string optionally followed by a display string";
    private static final String[] SUPPORTED_ANNOTATIONS = new String[]{"url", "hyperlink", "href", "link"};

    @Override
    public AttributedString createAnnotatedString(AttributedString prototypeString, String[] text, Program program) throws AnnotationException {
        if (text.length <= 1) {
            throw new AnnotationException(INVALID_SYMBOL_TEXT);
        }
        URL url = this.getURLForString(text[1]);
        if (url == null) {
            return new AttributedString("Invalid URL annotations - not a URL: " + text[1], Color.RED, prototypeString.getFontMetrics(0), false, Color.RED);
        }
        String displayText = url.toExternalForm();
        if (text.length > 2) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 2; i < text.length; ++i) {
                buffer.append(text[i]).append(" ");
            }
            buffer.deleteCharAt(buffer.length() - 1);
            displayText = buffer.toString();
        }
        return new AttributedString(displayText, prototypeString.getColor(0), prototypeString.getFontMetrics(0), true, prototypeString.getColor(0));
    }

    @Override
    public String[] getSupportedAnnotations() {
        return SUPPORTED_ANNOTATIONS;
    }

    private URL getURLForString(String urlString) {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    @Override
    public boolean handleMouseClick(String[] annotationParts, Navigatable navigatable, ServiceProvider serviceProvider) {
        String urlString = annotationParts[1];
        URL url = this.getURLForString(urlString);
        if (url != null) {
            if ("ghidra".equals(url.getProtocol())) {
                ProgramManager programManager = (ProgramManager)serviceProvider.getService(ProgramManager.class);
                return programManager.openProgram(url, 1) != null;
            }
            BrowserLoader.display(url, null, serviceProvider);
            return true;
        }
        Msg.showError((Object)this, null, (String)"Invalid URL", (Object)("Unable to create a Java URL object from string: " + urlString));
        return false;
    }

    @Override
    public String getDisplayString() {
        return "URL";
    }

    @Override
    public String getPrototypeString() {
        return "{@url http://www.example.com}";
    }
}

