/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.xml;

import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.util.XmlProgramUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlAttributeException;
import ghidra.util.xml.XmlAttributes;
import ghidra.util.xml.XmlUtilities;
import ghidra.util.xml.XmlWriter;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xml.sax.SAXParseException;

class RegisterValuesXmlMgr {
    private Program program;
    private MessageLog log;
    private AddressFactory factory;
    private ProgramContext context;
    private Set<String> undefinedRegisterNames;

    RegisterValuesXmlMgr(Program program, MessageLog log) {
        this.program = program;
        this.log = log;
        this.factory = program.getAddressFactory();
        this.context = program.getProgramContext();
    }

    void read(XmlPullParser parser, TaskMonitor monitor) throws SAXParseException, CancelledException {
        this.undefinedRegisterNames = new HashSet<String>();
        XmlElement element = parser.next();
        if (!element.isStart() || !element.getName().equals("REGISTER_VALUES")) {
            throw new SAXParseException("Expected REGISTER_VALUES start tag", null, null, parser.getLineNumber(), parser.getColumnNumber());
        }
        element = parser.next();
        while (element != null && element.isStart() && element.getName().equals("REGISTER_VALUE_RANGE")) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            this.processRegisterValues(element, parser);
            element = parser.next();
            if (element.isStart() || !element.getName().equalsIgnoreCase("REGISTER_VALUE_RANGE")) {
                throw new SAXParseException("Expected REGISTER_VALUE_RANGE end tag", null, null, parser.getLineNumber(), parser.getColumnNumber());
            }
            element = parser.next();
        }
        if (element != null && !element.getName().equals("REGISTER_VALUES")) {
            throw new SAXParseException("Expected REGISTER_VALUES end tag", null, null, parser.getLineNumber(), parser.getColumnNumber());
        }
    }

    private List<Register> getUniqueRegisters() {
        ArrayList<Register> regs = new ArrayList<Register>(this.context.getRegisters());
        Collections.sort(regs, new Comparator<Register>(){

            @Override
            public int compare(Register r1, Register r2) {
                int size2;
                int size1 = r1.getMinimumByteSize();
                if (size1 != (size2 = r2.getMinimumByteSize())) {
                    return size1 - size2;
                }
                return r1.getOffset() - r2.getOffset();
            }
        });
        return regs;
    }

    void write(XmlWriter writer, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        writer.startElement("REGISTER_VALUES");
        List<Register> regs = this.getUniqueRegisters();
        if (set == null) {
            set = this.program.getMemory();
        }
        AddressRangeIterator rangeIter = set.getAddressRanges();
        while (rangeIter.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            AddressRange range = (AddressRange)rangeIter.next();
            for (Register reg : regs) {
                AddressRangeIterator it = this.context.getRegisterValueAddressRanges(reg, range.getMinAddress(), range.getMaxAddress());
                while (it.hasNext()) {
                    monitor.checkCanceled();
                    AddressRange valueRange = (AddressRange)it.next();
                    BigInteger value = this.context.getValue(reg, valueRange.getMinAddress(), false);
                    if (value == null) continue;
                    XmlAttributes attr = new XmlAttributes();
                    attr.addAttribute("REGISTER", reg.getName());
                    attr.addAttribute("VALUE", value, true);
                    attr.addAttribute("START_ADDRESS", XmlProgramUtilities.toString((Address)valueRange.getMinAddress()));
                    attr.addAttribute("LENGTH", valueRange.getLength(), true);
                    writer.writeElement("REGISTER_VALUE_RANGE", attr);
                }
            }
        }
        writer.endElement("REGISTER_VALUES");
    }

    private void processRegisterValues(XmlElement element, XmlPullParser parser) {
        try {
            String regName = element.getAttribute("REGISTER");
            if (regName == null) {
                throw new XmlAttributeException("REGISTER attribute missing for REGISTER_VALUE_RANGE element");
            }
            String valueStr = element.getAttribute("VALUE");
            if (valueStr.startsWith("0x") || valueStr.startsWith("0X")) {
                valueStr = valueStr.substring(2);
            }
            BigInteger value = new BigInteger(valueStr, 16);
            String startAddrStr = element.getAttribute("START_ADDRESS");
            if (startAddrStr == null) {
                throw new XmlAttributeException("START_ADDRESS attribute missing for REGISTER_VALUE_RANGE element");
            }
            Address startAddr = XmlProgramUtilities.parseAddress((AddressFactory)this.factory, (String)startAddrStr);
            if (startAddr == null) {
                throw new AddressFormatException("Incompatible Register Address: " + startAddrStr);
            }
            long len = XmlUtilities.parseLong((String)element.getAttribute("LENGTH"));
            if (len < 1L) {
                throw new XmlAttributeException("LENGTH [" + len + "] is illegal for REGISTER_VALUE_RANGE element");
            }
            Register reg = this.context.getRegister(regName);
            if (reg == null) {
                if (this.undefinedRegisterNames.add(regName)) {
                    this.log.appendMsg("REGISTER [" + regName + "] is not defined by " + this.program.getLanguageID() + ", register values will be ignored");
                }
                return;
            }
            this.context.setValue(reg, startAddr, startAddr.addNoWrap(len - 1L), value);
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
        }
    }
}

