/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SingleFileSystemIndexHelper {
    private GFile rootDir;
    private GFileImpl payloadFile;

    public SingleFileSystemIndexHelper(GFileSystem fs, FSRLRoot fsFSRL, String payloadFilename, long length, String payloadMD5) {
        this.rootDir = GFileImpl.fromFSRL(fs, null, fsFSRL.withPath("/"), true, -1L);
        this.payloadFile = GFileImpl.fromFSRL(fs, this.rootDir, this.rootDir.getFSRL().withPath(payloadFilename).withMD5(payloadMD5), false, length);
    }

    public void clear() {
        this.payloadFile = null;
    }

    public boolean isPayloadFile(GFile file) {
        return this.payloadFile.equals(file);
    }

    public boolean isClosed() {
        return this.payloadFile == null;
    }

    public GFile getPayloadFile() {
        return this.payloadFile;
    }

    public FSRL getRootDirFSRL() {
        return this.rootDir.getFSRL();
    }

    public GFile getRootDir() {
        return this.rootDir;
    }

    public int getFileCount() {
        return 1;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Invalid state, index already closed");
        }
        if (directory == null || this.rootDir.equals(directory)) {
            return Arrays.asList(this.payloadFile);
        }
        return Collections.emptyList();
    }

    public GFile lookup(String path) {
        if (path == null || path.equals("/")) {
            return this.rootDir;
        }
        if (path.equals(this.payloadFile.getFSRL().getPath())) {
            return this.payloadFile;
        }
        return null;
    }

    public String toString() {
        return "SingleFileSystemIndexHelper for " + this.rootDir.getFilesystem();
    }
}

