/*
 * Decompiled with CFR 0.152.
 */
package ghidra.test.processors.support;

import ghidra.app.emulator.EmulatorHelper;
import ghidra.app.util.PseudoDisassembler;
import ghidra.docking.settings.SettingsImpl;
import ghidra.pcode.memstate.MemoryState;
import ghidra.pcode.utils.Utils;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.lang.InstructionBlock;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.test.processors.support.EmulatorTestRunner;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class PCodeTestAbstractControlBlock {
    static final int SIZEOF_U4 = 4;
    private final Disassembler disassembler;
    protected final Program program;
    protected final AddressSpace codeSpace;
    protected final AddressSpace dataSpace;
    protected final int pointerSize;
    protected final Address infoStructAddr;
    protected final Structure infoProgramStruct;
    private List<FunctionInfo> functions = new ArrayList<FunctionInfo>();
    private HashMap<String, FunctionInfo> functionMap = new HashMap();

    PCodeTestAbstractControlBlock(Program program, Address infoStructAddr, Structure infoStruct) {
        this.program = program;
        this.pointerSize = program.getDataTypeManager().getDataOrganization().getPointerSize();
        this.infoStructAddr = infoStructAddr;
        this.infoProgramStruct = infoStruct.clone((DataTypeManager)program.getDataTypeManager());
        this.codeSpace = program.getAddressFactory().getDefaultAddressSpace();
        this.dataSpace = program.getLanguage().getDefaultDataSpace();
        this.disassembler = Disassembler.getDisassembler((Program)program, (TaskMonitor)TaskMonitor.DUMMY, m -> {});
    }

    public Address getInfoStructureAddress() {
        return this.infoStructAddr;
    }

    public FunctionInfo getFunctionInfo(String functionName) {
        return this.functionMap.get(functionName);
    }

    public FunctionInfo getFunctionInfo(int functionIndex) {
        return this.functions.get(functionIndex);
    }

    public int getNumberFunctions() {
        return this.functions.size();
    }

    void forceCodePointer(Address addr) {
        if (this.codeSpace == this.dataSpace) {
            return;
        }
        ReferenceManager refMgr = this.program.getReferenceManager();
        Reference ref = refMgr.getPrimaryReferenceFrom(addr, 0);
        if (ref == null) {
            return;
        }
        Address toAddr = ref.getToAddress();
        if (!toAddr.getAddressSpace().equals(this.codeSpace)) {
            toAddr = this.codeSpace.getAddress(toAddr.getAddressableWordOffset(), true);
            Reference newRef = refMgr.addMemoryReference(addr, toAddr, RefType.DATA, SourceType.ANALYSIS, 0);
            refMgr.setPrimary(newRef, true);
            refMgr.delete(ref);
        }
    }

    static byte[] getCharArrayBytes(Program program, String string) {
        DataOrganization dataOrganization = program.getDataTypeManager().getDataOrganization();
        int charSize = dataOrganization.getCharSize();
        byte[] strBytes = string.getBytes();
        if (charSize == 1) {
            return strBytes;
        }
        int len = charSize * strBytes.length;
        byte[] bytes = new byte[len];
        boolean bigEndian = program.getMemory().isBigEndian();
        int index = 0;
        int pad = charSize - 1;
        for (byte strByte : strBytes) {
            if (bigEndian) {
                index += pad;
            }
            bytes[index++] = strByte;
            if (bigEndian) continue;
            index += pad;
        }
        return bytes;
    }

    private Address readPointer(MemBuffer buffer, int bufferOffset, AddressSpace addrSpace, boolean updateReference) {
        byte[] bytes = new byte[this.pointerSize];
        buffer.getBytes(bytes, bufferOffset);
        long offset = Utils.bytesToLong((byte[])bytes, (int)this.pointerSize, (boolean)buffer.isBigEndian()) * (long)addrSpace.getAddressableUnitSize();
        Address addr = addrSpace.getAddress(offset);
        if (updateReference) {
            Address fromAddr;
            ReferenceManager refMgr = this.program.getReferenceManager();
            Reference ref = refMgr.getPrimaryReferenceFrom(fromAddr = buffer.getAddress().add((long)bufferOffset), 0);
            if (ref != null && !ref.getToAddress().equals((Object)addr)) {
                refMgr.delete(ref);
                ref = null;
            }
            if (ref == null) {
                refMgr.addMemoryReference(fromAddr, addr, RefType.DATA, SourceType.USER_DEFINED, 0);
            }
        }
        return addr;
    }

    protected Address readDefinedDataPointer(Address addr) {
        Data data = this.program.getListing().getDefinedDataAt(addr);
        if (data == null || !(data.getDataType() instanceof Pointer)) {
            return null;
        }
        return (Address)data.getValue();
    }

    protected Address readCodePointer(MemBuffer buffer, int bufferOffset, boolean updateReference) throws MemoryAccessException {
        Address ptr;
        Address codePtr = this.readPointer(buffer, bufferOffset, this.codeSpace, updateReference);
        if (codePtr.getOffset() == 0L) {
            return codePtr;
        }
        int ptrShift = this.program.getDataTypeManager().getDataOrganization().getPointerShift();
        if (ptrShift != 0) {
            codePtr = codePtr.getNewAddress(codePtr.getOffset() << ptrShift);
        }
        if ((ptr = this.readDefinedDataPointer(codePtr)) != null) {
            codePtr = ptr;
        } else {
            Address[] flows;
            Address addr = PseudoDisassembler.getNormalizedDisassemblyAddress((Program)this.program, (Address)codePtr);
            InstructionBlock codeBlock = this.disassembler.pseudoDisassembleBlock(addr, null, 1);
            if (codeBlock == null || codeBlock.isEmpty() || codeBlock.hasInstructionError()) {
                throw new MemoryAccessException("Code pointer " + codePtr.toString(true) + " does not refer to valid code");
            }
            Instruction instr = codeBlock.getInstructionAt(addr);
            FlowType flowType = instr.getFlowType();
            if (flowType.isJump() && (flows = instr.getFlows()).length == 1) {
                codePtr = flows[0];
            }
        }
        return codePtr;
    }

    protected Address readDataPointer(MemBuffer buffer, int bufferOffset, boolean updateReference) {
        return this.readPointer(buffer, bufferOffset, this.dataSpace, updateReference);
    }

    protected Address readPointer(int controlBlockOffset) throws MemoryAccessException {
        Address addr = this.infoStructAddr.add((long)controlBlockOffset);
        byte[] bytes = new byte[this.pointerSize];
        Memory memory = this.program.getMemory();
        if (memory.getBytes(addr, bytes) != this.pointerSize) {
            throw new MemoryAccessException("Failed to read program memory: " + this.pointerSize + " bytes at " + addr);
        }
        long offset = Utils.bytesToLong((byte[])bytes, (int)this.pointerSize, (boolean)memory.isBigEndian());
        return this.infoStructAddr.getNewAddress(offset);
    }

    protected void applyU4Data(Address addr) {
        try {
            this.program.getListing().createData(addr, (DataType)DWordDataType.dataType);
        }
        catch (CodeUnitInsertionException codeUnitInsertionException) {
            // empty catch block
        }
    }

    protected int getStructureComponent(Structure testInfoStruct, String fieldName) {
        for (DataTypeComponent component : testInfoStruct.getDefinedComponents()) {
            if (!fieldName.equals(component.getFieldName())) continue;
            return component.getOffset();
        }
        throw new RuntimeException(fieldName + " field not found within " + testInfoStruct.getName() + " structure definition at " + this.infoStructAddr.toString(true));
    }

    protected void readControlBlock(boolean applyStruct) throws InvalidControlBlockException, CodeUnitInsertionException {
        if (applyStruct) {
            DataUtilities.createData((Program)this.program, (Address)this.infoStructAddr, (DataType)this.infoProgramStruct, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_CONFLICT_DATA);
        }
        TerminatedStringDataType stringType = new TerminatedStringDataType((DataTypeManager)this.program.getDataTypeManager());
        Structure functionInfoStruct = (Structure)this.infoProgramStruct.getDataTypeManager().getDataType(CategoryPath.ROOT, "FunctionInfo");
        if (functionInfoStruct == null) {
            throw new AssertException("FunctionInfo structure not yet resolved");
        }
        int nameOffset = this.getStructureComponent(functionInfoStruct, "name");
        int funcOffset = this.getStructureComponent(functionInfoStruct, "func");
        int numTestOffset = this.getStructureComponent(functionInfoStruct, "numTest");
        try {
            DumbMemBufferImpl memBuffer = new DumbMemBufferImpl(this.program.getMemory(), this.infoStructAddr);
            int functionArrayPtrOffset = this.getStructureComponent(this.infoProgramStruct, "funcInfoArrayPtr");
            Address functionInfoAddress = this.readDataPointer((MemBuffer)memBuffer, functionArrayPtrOffset, applyStruct);
            Msg.info((Object)this, (Object)("Loading FunctionInfo array at " + functionInfoAddress));
            while (true) {
                memBuffer.setPosition(functionInfoAddress);
                if (applyStruct) {
                    DataUtilities.createData((Program)this.program, (Address)functionInfoAddress, (DataType)functionInfoStruct, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_CONFLICT_DATA);
                    this.forceCodePointer(functionInfoAddress.add((long)funcOffset));
                }
                Address funcNamePtr = this.readDataPointer((MemBuffer)memBuffer, nameOffset, applyStruct);
                Address funcPtr = this.readCodePointer((MemBuffer)memBuffer, funcOffset, applyStruct);
                int numTest = memBuffer.getInt(numTestOffset);
                if (funcNamePtr.getOffset() != 0L) {
                    MemoryBlock block;
                    memBuffer.setPosition(funcNamePtr);
                    String functionName = (String)stringType.getValue((MemBuffer)memBuffer, SettingsImpl.NO_SETTINGS, 0);
                    if (!(funcPtr.getOffset() == 0L || (block = this.program.getMemory().getBlock(funcPtr)) != null && block.isInitialized())) {
                        throw new InvalidControlBlockException(this.infoProgramStruct.getName() + " @ " + this.infoStructAddr.toString(true) + " has invalid pointer offset for function: " + functionName + " -> " + funcPtr);
                    }
                    if (funcPtr.getOffset() != 0L) {
                        FunctionInfo info = new FunctionInfo(functionName, funcPtr, numTest);
                        this.functions.add(info);
                        this.functionMap.put(functionName, info);
                    }
                    functionInfoAddress = functionInfoAddress.add((long)functionInfoStruct.getLength());
                    continue;
                }
                break;
            }
        }
        catch (MemoryAccessException e) {
            throw new InvalidControlBlockException(this.infoProgramStruct.getName() + " program read error", e);
        }
    }

    protected String emuReadString(EmulatorHelper emu, Address strPtrAddr) {
        int index;
        DataOrganization dataOrganization = emu.getProgram().getDataTypeManager().getDataOrganization();
        int charSize = dataOrganization.getCharSize();
        boolean isBigEndian = emu.getProgram().getMemory().isBigEndian();
        MemoryState memState = emu.getEmulator().getMemState();
        long offset = strPtrAddr.getOffset();
        if (isBigEndian) {
            offset += (long)(charSize - 1);
        }
        char[] buffer = new char[128];
        for (index = 0; index < buffer.length; ++index) {
            buffer[index] = (char)(memState.getValue(strPtrAddr.getAddressSpace(), offset, 1) & 0xFFL);
            if (buffer[index] == '\u0000') break;
            offset += (long)charSize;
        }
        return new String(buffer, 0, index);
    }

    protected long emuRead(EmulatorHelper emu, Address addr, int size) {
        if (size < 1 || size > 8) {
            throw new IllegalArgumentException("Unsupported EMU read size: " + size);
        }
        MemoryState memState = emu.getEmulator().getMemState();
        return memState.getValue(addr.getAddressSpace(), addr.getOffset(), size);
    }

    protected void emuWrite(EmulatorHelper emu, Address addr, int size, long value) {
        if (size < 1 || size > 8) {
            throw new IllegalArgumentException("Unsupported EMU read size: " + size);
        }
        MemoryState memState = emu.getEmulator().getMemState();
        memState.setValue(addr.getAddressSpace(), addr.getOffset(), size, value);
    }

    protected Address getMirroredDataAddress(EmulatorTestRunner emuTestRunner, Address addr) {
        AddressSpace defaultDataSpace = emuTestRunner.getProgram().getLanguage().getDefaultDataSpace();
        if (defaultDataSpace != null && !addr.getAddressSpace().equals(defaultDataSpace)) {
            addr = defaultDataSpace.getAddress(addr.getOffset());
        }
        return addr;
    }

    static Address findBytes(Memory memory, AddressSetView set, byte[] bytes) {
        for (AddressRange range : set.getAddressRanges()) {
            Address addr = memory.findBytes(range.getMinAddress(), range.getMaxAddress(), bytes, null, true, TaskMonitor.DUMMY);
            if (addr == null || addr.getAddressSpace().isOverlaySpace()) continue;
            return addr;
        }
        return null;
    }

    public static class FunctionInfo
    implements Comparable<FunctionInfo> {
        public final String functionName;
        public final Address functionAddr;
        public final int numberOfAsserts;

        FunctionInfo(String functionName, Address functionAddr, int numberOfAsserts) {
            this.functionName = functionName;
            this.functionAddr = functionAddr;
            this.numberOfAsserts = numberOfAsserts;
        }

        @Override
        public int compareTo(FunctionInfo other) {
            return this.functionName.compareTo(other.functionName);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FunctionInfo)) {
                return false;
            }
            FunctionInfo other = (FunctionInfo)obj;
            return this.functionName.equals(other.functionName) & this.functionAddr.equals((Object)other.functionAddr);
        }

        public int hashCode() {
            return this.functionAddr.hashCode();
        }

        public String toString() {
            return this.functionName + "@" + this.functionAddr.toString(true);
        }
    }

    static class InvalidControlBlockException
    extends Exception {
        private static final long serialVersionUID = 9137869694955008327L;

        public InvalidControlBlockException(String msg) {
            super(msg);
        }

        public InvalidControlBlockException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

