/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import docking.widgets.table.GTableCellRenderingData;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HTMLUtilities;
import ghidra.util.table.column.AbstractGhidraColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.ProgramLocationTableColumnExtensionPoint;
import java.awt.Color;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import resources.ResourceManager;

public class MemoryTypeProgramLocationBasedTableColumn
extends ProgramLocationTableColumnExtensionPoint<ProgramLocation, MemoryBlock> {
    private MemoryTypeRenderer renderer = new MemoryTypeRenderer();
    private Comparator<MemoryBlock> comparator = new MemoryTypeComparator();

    public String getColumnName() {
        return "Mem Type";
    }

    public MemoryBlock getValue(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
        Memory memory = program.getMemory();
        MemoryBlock block = memory.getBlock(rowObject.getAddress());
        return block;
    }

    @Override
    public ProgramLocation getProgramLocation(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
        return rowObject;
    }

    public GColumnRenderer<MemoryBlock> getColumnRenderer() {
        return this.renderer;
    }

    public Comparator<MemoryBlock> getComparator() {
        return this.comparator;
    }

    private class MemoryTypeRenderer
    extends AbstractGhidraColumnRenderer<MemoryBlock> {
        private Color disabledColor = Color.LIGHT_GRAY;
        private ImageIcon offIcon = ResourceManager.loadImage((String)"images/EmptyIcon16.gif");
        private ImageIcon onIcon = ResourceManager.loadImage((String)"images/check.png");

        MemoryTypeRenderer() {
            this.setHTMLRenderingEnabled(true);
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel theRenderer = (JLabel)super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            if (value == null) {
                return this;
            }
            MemoryBlock block = (MemoryBlock)value;
            StringBuffer buffy = new StringBuffer("<html>");
            StringBuffer tooltipBuffy = new StringBuffer("<html>");
            this.asString(block, buffy, tooltipBuffy);
            this.setText(buffy.toString());
            this.setToolTipText(tooltipBuffy.toString());
            return theRenderer;
        }

        private void asString(MemoryBlock block, StringBuffer buffy, StringBuffer tooltipBuffy) {
            this.updateForRead(block, buffy, tooltipBuffy);
            this.updateForWrite(block, buffy, tooltipBuffy);
            this.updateForExecute(block, buffy, tooltipBuffy);
            this.updateForVolatile(block, buffy, tooltipBuffy);
        }

        private void updateForVolatile(MemoryBlock block, StringBuffer buffy, StringBuffer tooltipBuffy) {
            if (block.isVolatile()) {
                buffy.append("<b>V</b>");
                tooltipBuffy.append("<image src=\"" + this.onIcon.getDescription() + "\">");
            } else {
                buffy.append(HTMLUtilities.colorString((Color)this.disabledColor, (String)"V"));
                tooltipBuffy.append("<image src=\"" + this.offIcon.getDescription() + "\">");
            }
            tooltipBuffy.append(HTMLUtilities.spaces((int)2)).append("Volatile<br>");
        }

        private void updateForExecute(MemoryBlock block, StringBuffer buffy, StringBuffer tooltipBuffy) {
            if (block.isExecute()) {
                buffy.append("<b>E</b>");
                tooltipBuffy.append("<image src=\"" + this.onIcon.getDescription() + "\">");
            } else {
                buffy.append(HTMLUtilities.colorString((Color)this.disabledColor, (String)"E"));
                tooltipBuffy.append("<image src=\"" + this.offIcon.getDescription() + "\">");
            }
            tooltipBuffy.append(HTMLUtilities.spaces((int)2)).append("Execute<br>");
        }

        private void updateForWrite(MemoryBlock block, StringBuffer buffy, StringBuffer tooltipBuffy) {
            if (block.isWrite()) {
                buffy.append("<b>W</b>");
                tooltipBuffy.append("<image src=\"" + this.onIcon.getDescription() + "\">");
            } else {
                buffy.append(HTMLUtilities.colorString((Color)this.disabledColor, (String)"W"));
                tooltipBuffy.append("<image src=\"" + this.offIcon.getDescription() + "\">");
            }
            tooltipBuffy.append(HTMLUtilities.spaces((int)2)).append("Write<br>");
        }

        private void updateForRead(MemoryBlock block, StringBuffer buffy, StringBuffer tooltipBuffy) {
            if (block.isRead()) {
                buffy.append("<b>R</b>");
                tooltipBuffy.append("<image src=\"" + this.onIcon.getDescription() + "\">");
            } else {
                buffy.append(HTMLUtilities.colorString((Color)this.disabledColor, (String)"R"));
                tooltipBuffy.append("<image src=\"" + this.offIcon.getDescription() + "\">");
            }
            tooltipBuffy.append(HTMLUtilities.spaces((int)2)).append("Read<br>");
        }

        public String getFilterString(MemoryBlock t, Settings settings) {
            if (t == null) {
                return "";
            }
            StringBuffer buffy = new StringBuffer("<html>");
            StringBuffer tooltipBuffy = new StringBuffer("<html>");
            this.asString(t, buffy, tooltipBuffy);
            return buffy.toString();
        }
    }

    private class MemoryTypeComparator
    implements Comparator<MemoryBlock> {
        private MemoryTypeComparator() {
        }

        @Override
        public int compare(MemoryBlock o1, MemoryBlock o2) {
            return o1.getPermissions() - o2.getPermissions();
        }
    }
}

