/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib.AnnotationItem;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.AnnotationSetRefList;
import org.jf.dexlib.Convertible;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.ReadOnlyArrayList;

public class AnnotationDirectoryItem
extends Item<AnnotationDirectoryItem> {
    @Nullable
    private AnnotationSetItem classAnnotations;
    @Nullable
    private FieldAnnotation[] fieldAnnotations;
    @Nullable
    private MethodAnnotation[] methodAnnotations;
    @Nullable
    private ParameterAnnotation[] parameterAnnotations;

    protected AnnotationDirectoryItem(DexFile dexFile) {
        super(dexFile);
    }

    private AnnotationDirectoryItem(DexFile dexFile, @Nullable AnnotationSetItem classAnnotations, @Nullable List<FieldAnnotation> fieldAnnotations, @Nullable List<MethodAnnotation> methodAnnotations, @Nullable List<ParameterAnnotation> parameterAnnotations) {
        super(dexFile);
        this.classAnnotations = classAnnotations;
        if (fieldAnnotations == null || fieldAnnotations.size() == 0) {
            this.fieldAnnotations = null;
        } else {
            this.fieldAnnotations = new FieldAnnotation[fieldAnnotations.size()];
            this.fieldAnnotations = fieldAnnotations.toArray(this.fieldAnnotations);
            Arrays.sort(this.fieldAnnotations);
        }
        if (methodAnnotations == null || methodAnnotations.size() == 0) {
            this.methodAnnotations = null;
        } else {
            this.methodAnnotations = new MethodAnnotation[methodAnnotations.size()];
            this.methodAnnotations = methodAnnotations.toArray(this.methodAnnotations);
            Arrays.sort(this.methodAnnotations);
        }
        if (parameterAnnotations == null || parameterAnnotations.size() == 0) {
            this.parameterAnnotations = null;
        } else {
            this.parameterAnnotations = new ParameterAnnotation[parameterAnnotations.size()];
            this.parameterAnnotations = parameterAnnotations.toArray(this.parameterAnnotations);
            Arrays.sort(this.parameterAnnotations);
        }
    }

    public static AnnotationDirectoryItem internAnnotationDirectoryItem(DexFile dexFile, AnnotationSetItem classAnnotations, List<FieldAnnotation> fieldAnnotations, List<MethodAnnotation> methodAnnotations, List<ParameterAnnotation> parameterAnnotations) {
        AnnotationDirectoryItem annotationDirectoryItem = new AnnotationDirectoryItem(dexFile, classAnnotations, fieldAnnotations, methodAnnotations, parameterAnnotations);
        return dexFile.AnnotationDirectoriesSection.intern(annotationDirectoryItem);
    }

    @Override
    protected void readItem(Input in, ReadContext readContext) {
        MethodIdItem methodIdItem;
        int i;
        this.classAnnotations = (AnnotationSetItem)readContext.getOptionalOffsettedItemByOffset(ItemType.TYPE_ANNOTATION_SET_ITEM, in.readInt());
        int fieldAnnotationCount = in.readInt();
        this.fieldAnnotations = fieldAnnotationCount > 0 ? new FieldAnnotation[fieldAnnotationCount] : null;
        int methodAnnotationCount = in.readInt();
        this.methodAnnotations = methodAnnotationCount > 0 ? new MethodAnnotation[methodAnnotationCount] : null;
        int parameterAnnotationCount = in.readInt();
        this.parameterAnnotations = parameterAnnotationCount > 0 ? new ParameterAnnotation[parameterAnnotationCount] : null;
        if (this.fieldAnnotations != null) {
            for (i = 0; i < this.fieldAnnotations.length; ++i) {
                try {
                    FieldIdItem fieldIdItem = this.dexFile.FieldIdsSection.getItemByIndex(in.readInt());
                    AnnotationSetItem fieldAnnotationSet = (AnnotationSetItem)readContext.getOffsettedItemByOffset(ItemType.TYPE_ANNOTATION_SET_ITEM, in.readInt());
                    this.fieldAnnotations[i] = new FieldAnnotation(fieldIdItem, fieldAnnotationSet);
                    continue;
                }
                catch (Exception ex) {
                    throw ExceptionWithContext.withContext(ex, "Error occured while reading FieldAnnotation at index " + i);
                }
            }
        }
        if (this.methodAnnotations != null) {
            for (i = 0; i < this.methodAnnotations.length; ++i) {
                try {
                    methodIdItem = this.dexFile.MethodIdsSection.getItemByIndex(in.readInt());
                    AnnotationSetItem methodAnnotationSet = (AnnotationSetItem)readContext.getOffsettedItemByOffset(ItemType.TYPE_ANNOTATION_SET_ITEM, in.readInt());
                    this.methodAnnotations[i] = new MethodAnnotation(methodIdItem, methodAnnotationSet);
                    continue;
                }
                catch (Exception ex) {
                    throw ExceptionWithContext.withContext(ex, "Error occured while reading MethodAnnotation at index " + i);
                }
            }
        }
        if (this.parameterAnnotations != null) {
            for (i = 0; i < this.parameterAnnotations.length; ++i) {
                try {
                    methodIdItem = this.dexFile.MethodIdsSection.getItemByIndex(in.readInt());
                    AnnotationSetRefList paramaterAnnotationSet = (AnnotationSetRefList)readContext.getOffsettedItemByOffset(ItemType.TYPE_ANNOTATION_SET_REF_LIST, in.readInt());
                    this.parameterAnnotations[i] = new ParameterAnnotation(methodIdItem, paramaterAnnotationSet);
                    continue;
                }
                catch (Exception ex) {
                    throw ExceptionWithContext.withContext(ex, "Error occured while reading ParameterAnnotation at index " + i);
                }
            }
        }
    }

    @Override
    protected int placeItem(int offset) {
        return offset + 16 + ((this.fieldAnnotations == null ? 0 : this.fieldAnnotations.length) + (this.methodAnnotations == null ? 0 : this.methodAnnotations.length) + (this.parameterAnnotations == null ? 0 : this.parameterAnnotations.length)) * 8;
    }

    @Override
    protected void writeItem(AnnotatedOutput out) {
        if (out.annotates()) {
            int index;
            TypeIdItem parentType = this.getParentType();
            if (parentType != null) {
                out.annotate(0, parentType.getTypeDescriptor());
            }
            if (this.classAnnotations != null) {
                out.annotate(4, "class_annotations_off: 0x" + Integer.toHexString(this.classAnnotations.getOffset()));
            } else {
                out.annotate(4, "class_annotations_off:");
            }
            int length = this.fieldAnnotations == null ? 0 : this.fieldAnnotations.length;
            out.annotate(4, "annotated_fields_size: 0x" + Integer.toHexString(length) + " (" + length + ")");
            length = this.methodAnnotations == null ? 0 : this.methodAnnotations.length;
            out.annotate(4, "annotated_methods_size: 0x" + Integer.toHexString(length) + " (" + length + ")");
            length = this.parameterAnnotations == null ? 0 : this.parameterAnnotations.length;
            out.annotate(4, "annotated_parameters_size: 0x" + Integer.toHexString(length) + " (" + length + ")");
            if (this.fieldAnnotations != null) {
                index = 0;
                for (FieldAnnotation fieldAnnotation : this.fieldAnnotations) {
                    out.annotate(0, "[" + index++ + "] field_annotation");
                    out.indent();
                    out.annotate(4, "field: " + fieldAnnotation.field.getFieldName().getStringValue() + ":" + fieldAnnotation.field.getFieldType().getTypeDescriptor());
                    out.annotate(4, "annotations_off: 0x" + Integer.toHexString(fieldAnnotation.annotationSet.getOffset()));
                    out.deindent();
                }
            }
            if (this.methodAnnotations != null) {
                index = 0;
                for (MethodAnnotation methodAnnotation : this.methodAnnotations) {
                    out.annotate(0, "[" + index++ + "] method_annotation");
                    out.indent();
                    out.annotate(4, "method: " + methodAnnotation.method.getMethodString());
                    out.annotate(4, "annotations_off: 0x" + Integer.toHexString(methodAnnotation.annotationSet.getOffset()));
                    out.deindent();
                }
            }
            if (this.parameterAnnotations != null) {
                index = 0;
                for (ParameterAnnotation parameterAnnotation : this.parameterAnnotations) {
                    out.annotate(0, "[" + index++ + "] parameter_annotation");
                    out.indent();
                    out.annotate(4, "method: " + parameterAnnotation.method.getMethodString());
                    out.annotate(4, "annotations_off: 0x" + Integer.toHexString(parameterAnnotation.annotationSet.getOffset()));
                }
            }
        }
        out.writeInt(this.classAnnotations == null ? 0 : this.classAnnotations.getOffset());
        out.writeInt(this.fieldAnnotations == null ? 0 : this.fieldAnnotations.length);
        out.writeInt(this.methodAnnotations == null ? 0 : this.methodAnnotations.length);
        out.writeInt(this.parameterAnnotations == null ? 0 : this.parameterAnnotations.length);
        if (this.fieldAnnotations != null) {
            for (Comparable<Convertible<FieldIdItem>> comparable : this.fieldAnnotations) {
                out.writeInt(((FieldAnnotation)comparable).field.getIndex());
                out.writeInt(((FieldAnnotation)comparable).annotationSet.getOffset());
            }
        }
        if (this.methodAnnotations != null) {
            for (Comparable<Convertible<FieldIdItem>> comparable : this.methodAnnotations) {
                out.writeInt(((MethodAnnotation)comparable).method.getIndex());
                out.writeInt(((MethodAnnotation)comparable).annotationSet.getOffset());
            }
        }
        if (this.parameterAnnotations != null) {
            for (Comparable<Convertible<FieldIdItem>> comparable : this.parameterAnnotations) {
                out.writeInt(((ParameterAnnotation)comparable).method.getIndex());
                out.writeInt(((ParameterAnnotation)comparable).annotationSet.getOffset());
            }
        }
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_ANNOTATIONS_DIRECTORY_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        TypeIdItem parentType = this.getParentType();
        if (parentType == null) {
            return "annotation_directory_item @0x" + Integer.toHexString(this.getOffset());
        }
        return "annotation_directory_item @0x" + Integer.toHexString(this.getOffset()) + " (" + parentType.getTypeDescriptor() + ")";
    }

    @Override
    public int compareTo(AnnotationDirectoryItem o) {
        Preconditions.checkNotNull((Object)o);
        TypeIdItem parentType = this.getParentType();
        TypeIdItem otherParentType = o.getParentType();
        if (parentType != null) {
            if (otherParentType != null) {
                return parentType.compareTo(otherParentType);
            }
            return 1;
        }
        if (otherParentType != null) {
            return -1;
        }
        if (this.classAnnotations != null) {
            if (o.classAnnotations != null) {
                return this.classAnnotations.compareTo(o.classAnnotations);
            }
            return 1;
        }
        return -1;
    }

    @Nullable
    public TypeIdItem getParentType() {
        if (this.fieldAnnotations != null && this.fieldAnnotations.length > 0) {
            return this.fieldAnnotations[0].field.getContainingClass();
        }
        if (this.methodAnnotations != null && this.methodAnnotations.length > 0) {
            return this.methodAnnotations[0].method.getContainingClass();
        }
        if (this.parameterAnnotations != null && this.parameterAnnotations.length > 0) {
            return this.parameterAnnotations[0].method.getContainingClass();
        }
        return null;
    }

    @Nullable
    public AnnotationSetItem getClassAnnotations() {
        return this.classAnnotations;
    }

    @Nonnull
    public List<FieldAnnotation> getFieldAnnotations() {
        if (this.fieldAnnotations == null) {
            return Collections.emptyList();
        }
        return ReadOnlyArrayList.of(this.fieldAnnotations);
    }

    @Nonnull
    public List<MethodAnnotation> getMethodAnnotations() {
        if (this.methodAnnotations == null) {
            return Collections.emptyList();
        }
        return ReadOnlyArrayList.of(this.methodAnnotations);
    }

    @Nonnull
    public List<ParameterAnnotation> getParameterAnnotations() {
        if (this.parameterAnnotations == null) {
            return Collections.emptyList();
        }
        return ReadOnlyArrayList.of(this.parameterAnnotations);
    }

    @Nullable
    public AnnotationSetItem getFieldAnnotations(FieldIdItem fieldIdItem) {
        if (this.fieldAnnotations == null) {
            return null;
        }
        int index = Arrays.binarySearch(this.fieldAnnotations, fieldIdItem);
        if (index < 0) {
            return null;
        }
        return this.fieldAnnotations[index].annotationSet;
    }

    @Nullable
    public AnnotationSetItem getMethodAnnotations(MethodIdItem methodIdItem) {
        if (this.methodAnnotations == null) {
            return null;
        }
        int index = Arrays.binarySearch(this.methodAnnotations, methodIdItem);
        if (index < 0) {
            return null;
        }
        return this.methodAnnotations[index].annotationSet;
    }

    @Nullable
    public AnnotationSetRefList getParameterAnnotations(MethodIdItem methodIdItem) {
        if (this.parameterAnnotations == null) {
            return null;
        }
        int index = Arrays.binarySearch(this.parameterAnnotations, methodIdItem);
        if (index < 0) {
            return null;
        }
        return this.parameterAnnotations[index].annotationSet;
    }

    public int getClassAnnotationCount() {
        if (this.classAnnotations == null) {
            return 0;
        }
        AnnotationItem[] annotations = this.classAnnotations.getAnnotations();
        return annotations.length;
    }

    public int getFieldAnnotationCount() {
        if (this.fieldAnnotations == null) {
            return 0;
        }
        return this.fieldAnnotations.length;
    }

    public int getMethodAnnotationCount() {
        if (this.methodAnnotations == null) {
            return 0;
        }
        return this.methodAnnotations.length;
    }

    public int getParameterAnnotationCount() {
        if (this.parameterAnnotations == null) {
            return 0;
        }
        return this.parameterAnnotations.length;
    }

    public int hashCode() {
        TypeIdItem parentType = this.getParentType();
        if (parentType != null) {
            return parentType.hashCode();
        }
        if (this.classAnnotations != null) {
            return this.classAnnotations.hashCode();
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        AnnotationDirectoryItem other = (AnnotationDirectoryItem)o;
        return this.compareTo(other) == 0;
    }

    public static class ParameterAnnotation
    implements Comparable<Convertible<MethodIdItem>>,
    Convertible<MethodIdItem> {
        public final MethodIdItem method;
        public final AnnotationSetRefList annotationSet;

        public ParameterAnnotation(MethodIdItem method, AnnotationSetRefList annotationSet) {
            this.method = method;
            this.annotationSet = annotationSet;
        }

        @Override
        public int compareTo(Convertible<MethodIdItem> other) {
            return this.method.compareTo(other.convert());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.compareTo((ParameterAnnotation)o) == 0;
        }

        public int hashCode() {
            return this.method.hashCode() + 31 * this.annotationSet.hashCode();
        }

        @Override
        public MethodIdItem convert() {
            return this.method;
        }
    }

    public static class MethodAnnotation
    implements Comparable<Convertible<MethodIdItem>>,
    Convertible<MethodIdItem> {
        public final MethodIdItem method;
        public final AnnotationSetItem annotationSet;

        public MethodAnnotation(MethodIdItem method, AnnotationSetItem annotationSet) {
            this.method = method;
            this.annotationSet = annotationSet;
        }

        @Override
        public int compareTo(Convertible<MethodIdItem> other) {
            return this.method.compareTo(other.convert());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.compareTo((MethodAnnotation)o) == 0;
        }

        public int hashCode() {
            return this.method.hashCode() + 31 * this.annotationSet.hashCode();
        }

        @Override
        public MethodIdItem convert() {
            return this.method;
        }
    }

    public static class FieldAnnotation
    implements Comparable<Convertible<FieldIdItem>>,
    Convertible<FieldIdItem> {
        public final FieldIdItem field;
        public final AnnotationSetItem annotationSet;

        public FieldAnnotation(FieldIdItem field, AnnotationSetItem annotationSet) {
            this.field = field;
            this.annotationSet = annotationSet;
        }

        @Override
        public int compareTo(Convertible<FieldIdItem> other) {
            return this.field.compareTo(other.convert());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.compareTo((FieldAnnotation)o) == 0;
        }

        public int hashCode() {
            return this.field.hashCode() + 31 * this.annotationSet.hashCode();
        }

        @Override
        public FieldIdItem convert() {
            return this.field;
        }
    }
}

