/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import com.google.common.collect.Range;
import docking.widgets.table.GTableHeaderRenderer;
import docking.widgets.table.RangedRenderer;
import ghidra.util.datastruct.ListenerSet;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class RangeCursorTableHeaderRenderer<N extends Number>
extends GTableHeaderRenderer
implements RangedRenderer<N> {
    protected static final int ARROW_SIZE = 10;
    protected static final Polygon ARROW = new Polygon(new int[]{0, -10, -10}, new int[]{0, 10, -10}, 3);
    protected Range<Double> fullRangeDouble = Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0));
    protected double span = 1.0;
    protected Range<N> fullRange;
    protected N pos;
    protected double doublePos;
    private JTable savedTable;
    private int savedViewColumn;
    private final ForSeekMouseListener forSeekMouseListener = new ForSeekMouseListener();
    private final ListenerSet<SeekListener> listeners = new ListenerSet<SeekListener>(SeekListener.class);

    @Override
    public void setFullRange(Range<N> fullRange) {
        this.fullRangeDouble = RangedRenderer.validateViewRange(fullRange);
        this.span = (Double)this.fullRangeDouble.upperEndpoint() - (Double)this.fullRangeDouble.lowerEndpoint();
    }

    public void setCursorPosition(N pos) {
        this.pos = pos;
        this.doublePos = ((Number)pos).doubleValue();
    }

    protected void setSavedTable(JTable table) {
        JTableHeader header;
        if (this.savedTable != null) {
            header = this.savedTable.getTableHeader();
            header.removeMouseListener(this.forSeekMouseListener);
            header.removeMouseMotionListener(this.forSeekMouseListener);
        }
        this.savedTable = table;
        if (this.savedTable != null) {
            header = this.savedTable.getTableHeader();
            header.addMouseListener(this.forSeekMouseListener);
            header.addMouseMotionListener(this.forSeekMouseListener);
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setSavedTable(table);
        this.savedViewColumn = column;
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        this.paintCursor(g);
    }

    protected void paintCursor(Graphics parentG) {
        Graphics2D g = (Graphics2D)parentG.create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double x = (this.doublePos - (Double)this.fullRangeDouble.lowerEndpoint()) / this.span * (double)this.getWidth();
        g.translate(x, (double)this.getHeight());
        g.rotate(1.5707963267948966);
        g.setColor(this.getForeground());
        g.fillPolygon(ARROW);
    }

    public void addSeekListener(SeekListener listener) {
        this.listeners.add(listener);
    }

    public N getCursorPosition() {
        return this.pos;
    }

    @Override
    public Range<N> getFullRange() {
        return this.fullRange;
    }

    @Override
    public Range<Double> getFullRangeDouble() {
        return this.fullRangeDouble;
    }

    @Override
    public double getSpan() {
        return this.span;
    }

    protected class ForSeekMouseListener
    extends MouseAdapter {
        protected ForSeekMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if ((e.getModifiersEx() & 0x40) != 0) {
                return;
            }
            if (e.getButton() != 1) {
                return;
            }
            this.doSeek(e);
            e.consume();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int onmask = 1024;
            int offmask = 64;
            if ((e.getModifiersEx() & (onmask | offmask)) != onmask) {
                return;
            }
            this.doSeek(e);
            e.consume();
        }

        protected void doSeek(MouseEvent e) {
            TableColumnModel colModel = RangeCursorTableHeaderRenderer.this.savedTable.getColumnModel();
            JTableHeader header = RangeCursorTableHeaderRenderer.this.savedTable.getTableHeader();
            TableColumn myViewCol = colModel.getColumn(RangeCursorTableHeaderRenderer.this.savedViewColumn);
            if (header.getResizingColumn() != null) {
                return;
            }
            int clickedViewColIdx = colModel.getColumnIndexAtX(e.getX());
            if (clickedViewColIdx != RangeCursorTableHeaderRenderer.this.savedViewColumn) {
                return;
            }
            TableColumn draggedViewCol = header.getDraggedColumn();
            if (draggedViewCol == myViewCol) {
                header.setDraggedColumn(null);
            } else if (draggedViewCol != null) {
                return;
            }
            int colX = 0;
            for (int i = 0; i < clickedViewColIdx; ++i) {
                colX += colModel.getColumn(i).getWidth();
            }
            double pos = RangeCursorTableHeaderRenderer.this.span * (double)(e.getX() - colX) / (double)myViewCol.getWidth() + (Double)RangeCursorTableHeaderRenderer.this.fullRangeDouble.lowerEndpoint();
            ((SeekListener)RangeCursorTableHeaderRenderer.this.listeners.fire).accept(pos);
        }
    }

    public static interface SeekListener
    extends Consumer<Double> {
    }
}

