/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.struct;

import ghidra.pcode.struct.Expr;
import ghidra.pcode.struct.StructuredSleigh;
import ghidra.program.model.data.DataType;

class LiteralExpr
extends Expr {
    private final long val;
    private final int size;

    protected LiteralExpr(StructuredSleigh ctx, long val, int size, DataType type) {
        super(ctx, type);
        this.val = val;
        this.size = size;
    }

    @Override
    public StructuredSleigh.RVal cast(DataType type) {
        return new LiteralExpr(this.ctx, this.val, this.size, type);
    }

    public String toString() {
        return "<Literal " + this.val + ":" + this.size + ">";
    }

    @Override
    public String generate() {
        return "0x" + Long.toHexString(this.val) + ":" + this.size;
    }
}

