/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import db.util.ErrorHandler;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DirectedIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;

public class DBCachedObjectStoreValueCollection<T extends DBAnnotatedObject>
implements Collection<T> {
    protected final DBCachedObjectStore<T> store;
    protected final ErrorHandler errHandler;
    protected final ReadWriteLock lock;
    protected final DirectedIterator.Direction direction;

    public DBCachedObjectStoreValueCollection(DBCachedObjectStore<T> store, ErrorHandler errHandler, ReadWriteLock lock, DirectedIterator.Direction direction) {
        this.store = store;
        this.errHandler = errHandler;
        this.lock = lock;
        this.direction = direction;
    }

    @Override
    public int size() {
        return this.store.getRecordCount();
    }

    @Override
    public boolean isEmpty() {
        return this.store.getRecordCount() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.store.safe(this.lock.readLock(), () -> this.store.objects.contains(o));
    }

    @Override
    public Iterator<T> iterator() {
        return this.store.objects.iterator(this.direction, null);
    }

    @Override
    public Object[] toArray() {
        return this.store.objects.toArray(this.direction, null);
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.store.objects.toArray(this.direction, null, a, this.store.getRecordCount());
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        return this.store.safe(this.lock.writeLock(), () -> this.store.objects.remove(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.store.safe(this.lock.readLock(), () -> this.store.objects.containsAll(c));
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.store.safe(this.lock.writeLock(), () -> this.store.objects.removeAll(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.store.objects.retain(c, null);
    }

    @Override
    public void clear() {
        this.store.deleteAll();
    }
}

