/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.io.IOException;

public interface DirectedIterator<T> {
    public static long toIteratorMin(Range<Long> range) {
        if (range == null) {
            return Long.MIN_VALUE;
        }
        if (!range.hasLowerBound()) {
            return Long.MIN_VALUE;
        }
        if (range.lowerBoundType() == BoundType.CLOSED) {
            return (Long)range.lowerEndpoint();
        }
        return (Long)range.lowerEndpoint() + 1L;
    }

    public static long toIteratorMax(Range<Long> range) {
        if (range == null) {
            return Long.MAX_VALUE;
        }
        if (!range.hasUpperBound()) {
            return Long.MAX_VALUE;
        }
        if (range.upperBoundType() == BoundType.CLOSED) {
            return (Long)range.upperEndpoint();
        }
        return (Long)range.upperEndpoint() - 1L;
    }

    public static long clampLowerBound(Range<Long> range, long bound, boolean inclusive) {
        return Math.max(DirectedIterator.toIteratorMin(range), inclusive ? bound : bound + 1L);
    }

    public static long clampUpperBound(Range<Long> range, long bound, boolean inclusive) {
        return Math.min(DirectedIterator.toIteratorMax(range), inclusive ? bound : bound - 1L);
    }

    public boolean hasNext() throws IOException;

    public T next() throws IOException;

    public boolean delete() throws IOException;

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Direction {
        FORWARD{

            @Override
            Direction reverse() {
                return BACKWARD;
            }
        }
        ,
        BACKWARD{

            @Override
            Direction reverse() {
                return FORWARD;
            }
        };


        abstract Direction reverse();

        static Direction reverse(Direction direction) {
            return direction.reverse();
        }
    }
}

