/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.Table;
import ghidra.util.database.AbstractDirectedRecordIterator;
import ghidra.util.database.BackwardRecordIterator;
import ghidra.util.database.DirectedIterator;
import ghidra.util.database.ForwardRecordIterator;
import java.io.IOException;

public interface DirectedRecordIterator
extends DirectedIterator<DBRecord> {
    public static AbstractDirectedRecordIterator getIterator(Table table, Range<Long> keyRange, DirectedIterator.Direction direction) throws IOException {
        long min = DirectedIterator.toIteratorMin(keyRange);
        long max = DirectedIterator.toIteratorMax(keyRange);
        if (direction == DirectedIterator.Direction.FORWARD) {
            return new ForwardRecordIterator(table.iterator(min, max, min));
        }
        return new BackwardRecordIterator(table.iterator(min, max, max));
    }

    private static DirectedRecordIterator applyBegFilter(final DirectedRecordIterator it, final int columnIndex, final Field exclude) throws IOException {
        return new DirectedRecordIterator(){
            DBRecord next = this.findFirst();

            private DBRecord findFirst() throws IOException {
                DBRecord r = null;
                while (it.hasNext()) {
                    r = (DBRecord)it.next();
                    if (r.getFieldValue(columnIndex).equals((Object)exclude)) continue;
                    return r;
                }
                return null;
            }

            @Override
            public DBRecord next() throws IOException {
                DBRecord ret = this.next;
                this.next = (DBRecord)it.next();
                return ret;
            }

            @Override
            public boolean hasNext() throws IOException {
                return this.next != null;
            }

            @Override
            public boolean delete() throws IOException {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static DirectedRecordIterator applyEndFilter(final DirectedRecordIterator it, final int columnIndex, final Field exclude) throws IOException {
        return new DirectedRecordIterator(){
            DBRecord next;
            {
                this.next = (DBRecord)it.next();
            }

            @Override
            public DBRecord next() throws IOException {
                DBRecord ret = this.next;
                this.next = (DBRecord)it.next();
                return ret;
            }

            @Override
            public boolean hasNext() throws IOException {
                return this.next != null && !this.next.getFieldValue(columnIndex).equals((Object)exclude);
            }

            @Override
            public boolean delete() throws IOException {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static DirectedRecordIterator applyFilters(DirectedRecordIterator it, int columnIndex, Field beg, Field end) throws IOException {
        if (beg != null) {
            it = DirectedRecordIterator.applyBegFilter(it, columnIndex, beg);
        }
        if (end != null) {
            it = DirectedRecordIterator.applyEndFilter(it, columnIndex, end);
        }
        return it;
    }

    public static DirectedRecordIterator getIndexIterator(Table table, int columnIndex, Range<Field> fieldRange, DirectedIterator.Direction direction) throws IOException {
        Field excludeUpper;
        Field lower = fieldRange.hasLowerBound() ? (Field)fieldRange.lowerEndpoint() : null;
        Field upper = fieldRange.hasUpperBound() ? (Field)fieldRange.upperEndpoint() : null;
        RecordIterator it = table.indexIterator(columnIndex, lower, upper, direction == DirectedIterator.Direction.FORWARD);
        Field excludeLower = fieldRange.hasLowerBound() && fieldRange.lowerBoundType() == BoundType.OPEN ? lower : null;
        Field field = excludeUpper = fieldRange.hasUpperBound() && fieldRange.upperBoundType() == BoundType.OPEN ? upper : null;
        if (direction == DirectedIterator.Direction.FORWARD) {
            return DirectedRecordIterator.applyFilters(new ForwardRecordIterator(it), columnIndex, excludeLower, excludeUpper);
        }
        return DirectedRecordIterator.applyFilters(new BackwardRecordIterator(it), columnIndex, excludeUpper, excludeLower);
    }
}

