/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.CustomOption;
import ghidra.framework.options.SaveState;
import ghidra.util.Msg;
import ghidra.util.xml.GenericXMLOutputter;
import ghidra.util.xml.XmlUtilities;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Date;
import javax.swing.KeyStroke;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public enum OptionType {
    INT_TYPE(Integer.class, new IntStringAdapter()),
    LONG_TYPE(Long.class, new LongStringAdapter()),
    STRING_TYPE(String.class, new StringStringAdapter()),
    DOUBLE_TYPE(Double.class, new DoubleStringAdapter()),
    BOOLEAN_TYPE(Boolean.class, new BooleanStringAdapter()),
    DATE_TYPE(Date.class, new DateStringAdapter()),
    NO_TYPE(null, new NoTypeStringAdapter()),
    FLOAT_TYPE(Float.class, new FloatStringAdapter()),
    ENUM_TYPE(Enum.class, new EnumStringAdapter()),
    CUSTOM_TYPE(CustomOption.class, new CustomStringAdapter()),
    BYTE_ARRAY_TYPE(byte[].class, new ByteArrayStringAdapter()),
    FILE_TYPE(File.class, new FileStringAdapter()),
    COLOR_TYPE(Color.class, new ColorStringAdapter()),
    FONT_TYPE(Font.class, new FontStringAdapter()),
    KEYSTROKE_TYPE(KeyStroke.class, new KeyStrokeStringAdapter());

    private Class<?> clazz;
    private StringAdapter stringAdapter;

    public Object convertStringToObject(String string) {
        if (string == null) {
            return null;
        }
        return this.stringAdapter.stringToObject(string);
    }

    public String convertObjectToString(Object object) {
        if (object == null) {
            return null;
        }
        return this.stringAdapter.objectToString(object);
    }

    public Class<?> getValueClass() {
        return this.clazz;
    }

    private OptionType(Class<?> clazz, StringAdapter adapter) {
        this.clazz = clazz;
        this.stringAdapter = adapter;
    }

    public static OptionType getOptionType(Object obj) {
        if (obj == null) {
            return NO_TYPE;
        }
        Class<?> objClass = obj.getClass();
        for (OptionType type : OptionType.values()) {
            if (type == NO_TYPE || !type.clazz.isAssignableFrom(objClass)) continue;
            return type;
        }
        return NO_TYPE;
    }

    private static String saveToXmlString(SaveState saveState) {
        Element element = saveState.saveToXml();
        StringWriter stringWriter = new StringWriter();
        GenericXMLOutputter xmlout = new GenericXMLOutputter();
        try {
            xmlout.output(element, stringWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    private static SaveState getSaveStateFromXmlString(String xmlString) {
        SAXBuilder saxBuilder = XmlUtilities.createSecureSAXBuilder(false, false);
        try {
            Document doc = saxBuilder.build((Reader)new StringReader(xmlString));
            Element rootElement = doc.getRootElement();
            return new SaveState(rootElement);
        }
        catch (JDOMException e) {
            Msg.showError(SaveState.class, null, (String)"XML Error", (Object)"Error in xml in saved property", (Throwable)e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new SaveState();
    }

    static abstract class StringAdapter {
        StringAdapter() {
        }

        abstract Object stringToObject(String var1);

        String objectToString(Object object) {
            return object.toString();
        }
    }

    static class IntStringAdapter
    extends StringAdapter {
        IntStringAdapter() {
        }

        @Override
        Object stringToObject(String string) {
            return Integer.valueOf(string);
        }
    }

    static class LongStringAdapter
    extends StringAdapter {
        LongStringAdapter() {
        }

        @Override
        Object stringToObject(String string) {
            return Long.valueOf(string);
        }
    }

    static class StringStringAdapter
    extends StringAdapter {
        StringStringAdapter() {
        }

        @Override
        Object stringToObject(String string) {
            return string;
        }
    }

    static class DoubleStringAdapter
    extends StringAdapter {
        DoubleStringAdapter() {
        }

        @Override
        Object stringToObject(String string) {
            return Double.valueOf(string);
        }
    }

    static class BooleanStringAdapter
    extends StringAdapter {
        BooleanStringAdapter() {
        }

        @Override
        Object stringToObject(String string) {
            return Boolean.valueOf(string);
        }
    }

    static class DateStringAdapter
    extends StringAdapter {
        DateStringAdapter() {
        }

        @Override
        Object stringToObject(String string) {
            return new Date(Long.parseLong(string));
        }

        @Override
        String objectToString(Object object) {
            Date date = (Date)object;
            return Long.toString(date.getTime());
        }
    }

    static class NoTypeStringAdapter
    extends StringAdapter {
        NoTypeStringAdapter() {
        }

        @Override
        Object stringToObject(String string) {
            return null;
        }
    }

    static class FloatStringAdapter
    extends StringAdapter {
        FloatStringAdapter() {
        }

        @Override
        Object stringToObject(String string) {
            return Float.valueOf(string);
        }
    }

    static class EnumStringAdapter
    extends StringAdapter {
        EnumStringAdapter() {
        }

        @Override
        Object stringToObject(String string) {
            SaveState saveState = OptionType.getSaveStateFromXmlString(string);
            Enum nullDummy = null;
            return saveState.getEnum("ENUM", nullDummy);
        }

        @Override
        String objectToString(Object object) {
            Enum enuum = (Enum)object;
            SaveState saveState = new SaveState();
            saveState.putEnum("ENUM", enuum);
            return OptionType.saveToXmlString(saveState);
        }
    }

    static class CustomStringAdapter
    extends StringAdapter {
        CustomStringAdapter() {
        }

        @Override
        Object stringToObject(String string) {
            SaveState saveState = OptionType.getSaveStateFromXmlString(string);
            String customOptionClassName = saveState.getString("CUSTOM_OPTION_CLASS", null);
            try {
                Class<?> c = Class.forName(customOptionClassName);
                CustomOption option = (CustomOption)c.getConstructor(new Class[0]).newInstance(new Object[0]);
                option.readState(saveState);
                return option;
            }
            catch (ClassNotFoundException e) {
                Msg.warn((Object)this, (Object)("Ignoring unsupported customOption instance for: " + customOptionClassName));
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("Can't create customOption instance for: " + customOptionClassName + e));
            }
            return null;
        }

        @Override
        String objectToString(Object object) {
            CustomOption customOption = (CustomOption)object;
            SaveState saveState = new SaveState();
            saveState.putString("CUSTOM_OPTION_CLASS", object.getClass().getName());
            customOption.writeState(saveState);
            return OptionType.saveToXmlString(saveState);
        }
    }

    public static class ByteArrayStringAdapter
    extends StringAdapter {
        @Override
        Object stringToObject(String string) {
            SaveState saveState = OptionType.getSaveStateFromXmlString(string);
            return saveState.getBytes("BYTES", null);
        }

        @Override
        String objectToString(Object object) {
            byte[] bytes = (byte[])object;
            SaveState saveState = new SaveState();
            saveState.putBytes("BYTES", bytes);
            return OptionType.saveToXmlString(saveState);
        }
    }

    static class FileStringAdapter
    extends StringAdapter {
        FileStringAdapter() {
        }

        @Override
        Object stringToObject(String string) {
            return new File(string);
        }

        @Override
        String objectToString(Object object) {
            return ((File)object).getAbsolutePath();
        }
    }

    static class ColorStringAdapter
    extends StringAdapter {
        ColorStringAdapter() {
        }

        @Override
        Object stringToObject(String string) {
            return new Color(Integer.decode(string));
        }

        @Override
        String objectToString(Object object) {
            return Integer.toString(((Color)object).getRGB());
        }
    }

    static class FontStringAdapter
    extends StringAdapter {
        private static final String[] STYLES = new String[]{"PLAIN", "BOLD", "ITALIC", "BOLDITALIC"};

        FontStringAdapter() {
        }

        @Override
        Object stringToObject(String string) {
            return Font.decode(string);
        }

        @Override
        String objectToString(Object object) {
            Font font = (Font)object;
            String fontName = font.getFamily();
            int style = font.getStyle();
            int size = font.getSize();
            StringBuffer buf = new StringBuffer();
            buf.append(fontName);
            buf.append("-");
            buf.append(STYLES[style]);
            buf.append("-");
            buf.append(size);
            return buf.toString();
        }
    }

    static class KeyStrokeStringAdapter
    extends StringAdapter {
        KeyStrokeStringAdapter() {
        }

        @Override
        Object stringToObject(String string) {
            return KeyStroke.getKeyStroke(string);
        }
    }

    static final class DUMMY
    extends Enum<DUMMY> {
        private static final /* synthetic */ DUMMY[] $VALUES;

        public static DUMMY[] values() {
            return (DUMMY[])$VALUES.clone();
        }

        public static DUMMY valueOf(String name) {
            return Enum.valueOf(DUMMY.class, name);
        }

        private static /* synthetic */ DUMMY[] $values() {
            return new DUMMY[0];
        }

        static {
            $VALUES = DUMMY.$values();
        }
    }
}

