/*
 * Decompiled with CFR 0.152.
 */
package ghidra.net;

import generic.random.SecureRandomFactory;
import ghidra.framework.ModuleInitializer;
import ghidra.net.ApplicationKeyManagerFactory;
import ghidra.net.ApplicationTrustManagerFactory;
import ghidra.net.HttpClients;
import ghidra.util.Msg;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;

public class SSLContextInitializer
implements ModuleInitializer {
    private static final String DEFAULT_SSL_PROTOCOL = "TLS";
    private static SSLContext sslContext;

    public static synchronized boolean initialize(boolean reset) {
        if (reset) {
            sslContext = null;
            ApplicationTrustManagerFactory.invalidateTrustManagers();
            ApplicationKeyManagerFactory.invalidateKeyManagers();
        }
        return SSLContextInitializer.initialize();
    }

    public static synchronized boolean initialize() {
        if (sslContext != null) {
            SSLContext.setDefault(sslContext);
            return true;
        }
        Msg.info(SSLContextInitializer.class, (Object)"Initializing SSL Context");
        KeyManager[] keyManagers = ApplicationKeyManagerFactory.getInstance().getKeyManagers();
        try {
            sslContext = SSLContext.getInstance(DEFAULT_SSL_PROTOCOL);
            SecureRandom random = SecureRandomFactory.getSecureRandom();
            sslContext.init(keyManagers, ApplicationTrustManagerFactory.getTrustManagers(), random);
            SSLContext.setDefault(sslContext);
            HostnameVerifier originalVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
            if (!(originalVerifier instanceof HttpsHostnameVerifier)) {
                HttpsURLConnection.setDefaultHostnameVerifier(new HttpsHostnameVerifier());
            }
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            HttpClients.clearHttpClient();
            return true;
        }
        catch (Exception e) {
            Msg.error(SSLContextInitializer.class, (Object)("SSL Context initialization failed: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    @Override
    public void run() {
        SSLContextInitializer.initialize();
    }

    @Override
    public String getName() {
        return "SSL Context";
    }

    public static class HttpsHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String hostname, SSLSession session) {
            return false;
        }
    }
}

