/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import generic.text.TextLayoutGraphics;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import ghidra.util.Swing;
import ghidra.util.html.HtmlLineSplitter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import utilities.util.reflection.ReflectionUtilities;

public class HTMLUtilities {
    private static final int DEFAULT_MAX_LINE_LENGTH = 75;
    private static final int DEFAULT_TOOLTIP_MAX_LINE_LENGTH = 100;
    private static final int MAX_TOOLTIP_LENGTH = 2000;
    private static final int TAB_SIZE = 4;
    public static final String HTML = "<HTML>";
    public static final String HTML_CLOSE = "</HTML>";
    public static final String BR = "<BR>";
    public static final String PRE = "<PRE>";
    public static final String PRE_CLOSE = "</PRE>";
    private static final String LINK_PLACEHOLDER_CONTENT = "__CONTENT__";
    public static final String LINK_PLACEHOLDER_OPEN = "<!-- LINK __CONTENT__ -->";
    public static final String LINK_PLACEHOLDER_CLOSE = "<!-- /LINK -->";
    public static String HTML_SPACE = "&nbsp;";
    public static String HTML_NEW_LINE = "<BR>";
    public static final String MAROON = "#990000";
    public static final String GREEN = "#009900";
    public static final String BLUE = "#000099";
    public static final String PURPLE = "#990099";
    public static final String DARK_CYAN = "#009999";
    public static final String OLIVE = "#999900";
    public static final String ORANGE = "#FF9900";
    public static final String PINK = "#FF9999";
    public static final String YELLOW = "#FFFF00";
    public static final String GRAY = "#888888";

    public static String wrapAsHTML(String text) {
        return HTML + HTMLUtilities.fixupHTMLRenderingIssues(text);
    }

    private static String fixupHTMLRenderingIssues(String text) {
        if (((String)text).startsWith("/")) {
            text = HTML_SPACE + (String)text;
        }
        return text;
    }

    public static String colorString(Color color, String text) {
        String rgb = HTMLUtilities.toHexString(color);
        return "<FONT COLOR=\"" + rgb + "\">" + text + "</FONT>";
    }

    public static String colorString(String rgbColor, String text) {
        return "<FONT COLOR=\"" + rgbColor + "\">" + text + "</FONT>";
    }

    public static String colorString(String rgbColor, int value) {
        return "<FONT COLOR=\"" + rgbColor + "\">" + value + "</FONT>";
    }

    public static String spaces(int num) {
        StringBuilder buf = new StringBuilder(HTML_SPACE.length() * num);
        for (int i = 0; i < num; ++i) {
            buf.append(HTML_SPACE);
        }
        return buf.toString();
    }

    public static String bold(String text) {
        return "<b>" + text + "</b>";
    }

    public static String underline(String text) {
        return "<u>" + text + "</u>";
    }

    public static String italic(String text) {
        return "<i>" + text + "</i>";
    }

    public static boolean isHTML(String text) {
        if (text == null) {
            return false;
        }
        String testText = text.trim();
        return BasicHTML.isHTMLString(testText);
    }

    public static boolean isUnbreakableHTML(String text) {
        if (text.contains(HTML_SPACE) && !text.contains(" ")) {
            return true;
        }
        return text.contains(HTML_NEW_LINE);
    }

    private static void logUnbreakableHTMLWarning() {
        Throwable t = ReflectionUtilities.createJavaFilteredThrowable();
        Msg.error(HTMLUtilities.class, (Object)"Cannot reliably wrap HTML; not changing text.  Update the call to this method", (Throwable)t);
    }

    public static String setFontSize(String text, int ptSize) {
        int start = 0;
        if (StringUtilities.startsWithIgnoreCase(text, HTML)) {
            start = HTML.length();
        }
        StringBuilder buffy = new StringBuilder(text);
        buffy.insert(start, "<SPAN STYLE=\"font-size: " + ptSize + "pt\">");
        int end = buffy.length();
        if (StringUtilities.endsWithIgnoreCase(text, HTML_CLOSE)) {
            end -= HTML_CLOSE.length();
        }
        buffy.insert(end, "</SPAN>");
        return buffy.toString();
    }

    public static String setFont(String text, Color color, int ptSize) {
        String rgb = HTMLUtilities.toHexString(color);
        int start = 0;
        if (StringUtilities.startsWithIgnoreCase(text, HTML)) {
            start = HTML.length();
        }
        StringBuilder buffy = new StringBuilder(text);
        buffy.insert(start, "<SPAN STYLE=\"font-size: " + ptSize + "pt; color: " + rgb + "\">");
        int end = buffy.length();
        if (StringUtilities.endsWithIgnoreCase(text, HTML_CLOSE)) {
            end -= HTML_CLOSE.length();
        }
        buffy.insert(end, "</SPAN>");
        return buffy.toString();
    }

    public static String wrapWithLinkPlaceholder(String htmlText, String content) {
        String openTag = LINK_PLACEHOLDER_OPEN.replace(LINK_PLACEHOLDER_CONTENT, "CONTENT=\"" + content + "\"");
        return openTag + htmlText + LINK_PLACEHOLDER_CLOSE;
    }

    public static String convertLinkPlaceholdersToHyperlinks(String text) {
        Pattern p = Pattern.compile("<!-- LINK CONTENT=\"(.*?)\" -->");
        StringBuffer buffy = new StringBuffer();
        Matcher matcher = p.matcher(text);
        while (matcher.find()) {
            String content = matcher.group(1);
            String escaped = content.replace("$", "\\$");
            String updated = "<A HREF=\"" + escaped + "\">";
            matcher.appendReplacement(buffy, updated);
        }
        matcher.appendTail(buffy);
        String pass1 = buffy.toString();
        String pass2 = pass1.replaceAll(LINK_PLACEHOLDER_CLOSE, "</A>");
        return pass2;
    }

    public static String toHTML(String text) {
        int noMax = 0;
        String html = HTMLUtilities.toWrappedHTML(text, noMax);
        return html;
    }

    public static String toWrappedHTML(String text) {
        return HTMLUtilities.toWrappedHTML(text, 75);
    }

    public static String toWrappedHTML(String text, int maxLineLength) {
        if (text == null) {
            return null;
        }
        String wrappedLine = HTMLUtilities.lineWrapWithHTMLLineBreaks(text, maxLineLength);
        if (HTMLUtilities.isHTML(text)) {
            return wrappedLine;
        }
        return HTML + HTMLUtilities.fixupHTMLRenderingIssues(wrappedLine);
    }

    public static String toLiteralHTMLForTooltip(String text) {
        if (((String)text).length() > 2000) {
            text = ((String)text).substring(0, 2000) + "...";
        }
        String html = HTMLUtilities.toHTMLWithLineWrappingAndEncoding((String)text, 100, false);
        return html;
    }

    public static String friendlyEncodeHTML(String text) {
        return HTMLUtilities.friendlyEncodeHTML(text, true);
    }

    public static String friendlyEncodeHTML(String text, boolean skipLeadingWhitespace) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        int col = 0;
        if (skipLeadingWhitespace) {
            for (i = 0; i < text.length() && Character.isWhitespace(text.charAt(i)); ++i) {
            }
        }
        while (i < text.length()) {
            block16: {
                block20: {
                    char c;
                    block19: {
                        block18: {
                            block17: {
                                block15: {
                                    c = text.charAt(i);
                                    if (c != '\r') break block15;
                                    col = 0;
                                    break block16;
                                }
                                if (c != '\n') break block17;
                                buffer.append(c);
                                col = 0;
                                break block16;
                            }
                            if (c != '\t') break block18;
                            int cnt = 4 - col % 4;
                            for (int k = 0; k < cnt; ++k) {
                                buffer.append(HTML_SPACE);
                            }
                            col = 0;
                            break block16;
                        }
                        if (c != ' ') break block19;
                        buffer.append(HTML_SPACE);
                        break block20;
                    }
                    if (c < ' ') break block16;
                    if (c > '\u007f') {
                        buffer.append("&#x");
                        buffer.append(Integer.toString(c, 16).toUpperCase());
                        buffer.append(";");
                    } else {
                        switch (c) {
                            case '&': {
                                buffer.append("&amp;");
                                break;
                            }
                            case '<': {
                                buffer.append("&lt;");
                                break;
                            }
                            case '>': {
                                buffer.append("&gt;");
                                break;
                            }
                            case '\u007f': {
                                break;
                            }
                            default: {
                                buffer.append(c);
                            }
                        }
                    }
                }
                ++col;
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String escapeHTML(String text) {
        StringBuilder buffer = new StringBuilder(text.length());
        text.codePoints().forEach(cp -> {
            switch (cp) {
                case 38: {
                    buffer.append("&amp;");
                    break;
                }
                case 60: {
                    buffer.append("&lt;");
                    break;
                }
                case 62: {
                    buffer.append("&gt;");
                    break;
                }
                default: {
                    if (HTMLUtilities.charNeedsHTMLEscaping(cp)) {
                        buffer.append("&#x");
                        buffer.append(Integer.toString(cp, 16).toUpperCase());
                        buffer.append(";");
                        break;
                    }
                    buffer.appendCodePoint(cp);
                }
            }
        });
        return buffer.toString();
    }

    public static boolean charNeedsHTMLEscaping(int codePoint) {
        return codePoint != 10 && codePoint != 9 && (32 > codePoint || codePoint >= 127);
    }

    public static String toLiteralHTML(String text, int maxLineLength) {
        String html = HTMLUtilities.toHTMLWithLineWrappingAndEncoding(text, maxLineLength, true);
        return html;
    }

    private static String toHTMLWithLineWrappingAndEncoding(String text, int maxLineLength, boolean preserveLeadingWhitespace) {
        StringBuilder buffy = new StringBuilder();
        List<String> lines = HtmlLineSplitter.split(text, maxLineLength, preserveLeadingWhitespace);
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            buffy.append(HTMLUtilities.friendlyEncodeHTML(line, !preserveLeadingWhitespace));
            if (i + 1 >= lines.size()) continue;
            buffy.append(BR).append('\n');
        }
        String html = HTMLUtilities.wrapAsHTML(buffy.toString());
        return html;
    }

    public static String lineWrapWithHTMLLineBreaks(String text) {
        return HTMLUtilities.lineWrapWithHTMLLineBreaks(text, 0);
    }

    public static String lineWrapWithHTMLLineBreaks(String text, int maxLineLength) {
        if (HTMLUtilities.isUnbreakableHTML(text)) {
            HTMLUtilities.logUnbreakableHTMLWarning();
            return text;
        }
        List<String> lines = HtmlLineSplitter.split(text, maxLineLength);
        StringBuilder buffer = new StringBuilder();
        for (int n = 0; n < lines.size(); ++n) {
            String line = lines.get(n);
            buffer.append(line);
            if (n == lines.size() - 1) continue;
            buffer.append(BR);
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public static String fromHTML(String text) {
        if (text == null) {
            return null;
        }
        if (!BasicHTML.isHTMLString(text)) {
            return text;
        }
        Swing.assertSwingThread((String)"This method must be called on the Swing thread");
        JLabel label = new JLabel(text){

            @Override
            public void paint(Graphics g) {
                super.paintComponent(g);
            }
        };
        View v = (View)label.getClientProperty("html");
        if (v == null) {
            return text;
        }
        Dimension size = label.getPreferredSize();
        label.setBounds(new Rectangle(0, 0, size.width, size.height));
        Rectangle bounds = new Rectangle(-size.width, -size.height, size.width * 2, size.height * 10);
        TextLayoutGraphics g = new TextLayoutGraphics();
        g.setClip(bounds);
        label.paint(g);
        g.flush();
        String raw = g.getBuffer();
        raw = raw.trim();
        String updated = HTMLUtilities.replaceKnownSpecialCharacters(raw);
        return updated;
    }

    private static String replaceKnownSpecialCharacters(String s) {
        StringBuilder buffy = new StringBuilder();
        s.chars().forEach(c -> {
            switch (c) {
                case 160: {
                    buffy.append(' ');
                    break;
                }
                default: {
                    buffy.append((char)c);
                }
            }
        });
        return buffy.toString();
    }

    public static String toRGBString(Color color) {
        StringBuilder buffy = new StringBuilder();
        buffy.append(StringUtilities.pad(Integer.toString(color.getRed()), '0', 3));
        buffy.append(StringUtilities.pad(Integer.toString(color.getGreen()), '0', 3));
        buffy.append(StringUtilities.pad(Integer.toString(color.getBlue()), '0', 3));
        return buffy.toString();
    }

    public static String toHexString(Color color) {
        return String.format("#%06X", color.getRGB() & 0xFFFFFF);
    }
}

