/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Prime;
import ghidra.util.datastruct.ShortKeyIndexer;
import java.io.Serializable;

public class ShortStringHashtable
implements Serializable {
    private ShortKeyIndexer indexer;
    private String[] values;
    private int capacity;

    public ShortStringHashtable() {
        this(3);
    }

    public ShortStringHashtable(short capacity) {
        capacity = (short)Prime.nextPrime(capacity);
        this.capacity = capacity;
        this.indexer = new ShortKeyIndexer(capacity);
        this.values = new String[capacity];
    }

    public void put(short key, String value) {
        short index = this.indexer.put(key);
        if (index >= this.capacity) {
            this.grow();
        }
        this.values[index] = value;
    }

    public String get(short key) {
        short index = this.indexer.get(key);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    public boolean remove(short key) {
        return this.indexer.remove(key) >= 0;
    }

    public void removeAll() {
        this.indexer.clear();
    }

    public boolean contains(short key) {
        return this.indexer.get(key) >= 0;
    }

    public int size() {
        return this.indexer.getSize();
    }

    public short[] getKeys() {
        return this.indexer.getKeys();
    }

    private void grow() {
        this.capacity = this.indexer.getCapacity();
        String[] oldValues = this.values;
        this.values = new String[this.capacity];
        System.arraycopy(oldValues, 0, this.values, 0, oldValues.length);
    }
}

