/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.exporter;

import ghidra.graph.exporter.AbstractAttributedGraphExporter;
import ghidra.service.graph.Attributed;
import ghidra.service.graph.AttributedGraph;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.nio.AttributeType;
import org.jgrapht.nio.DefaultAttribute;
import org.jgrapht.nio.graphml.GraphMLExporter;

public class GraphMlGraphExporter
extends AbstractAttributedGraphExporter {
    public void exportGraph(AttributedGraph graph, File file) throws IOException {
        GraphMLExporter exporter = new GraphMLExporter(this.vertexIdProvider);
        exporter.setEdgeIdProvider(this.edgeIdProvider);
        exporter.setVertexAttributeProvider(vertex -> vertex.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new DefaultAttribute(entry.getValue(), AttributeType.STRING))));
        exporter.setEdgeAttributeProvider(edge -> edge.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new DefaultAttribute((Object)((String)entry.getValue()), AttributeType.STRING))));
        graph.vertexSet().stream().map(Attributed::getAttributes).flatMap(m -> m.entrySet().stream()).map(Map.Entry::getKey).forEach(key -> exporter.registerAttribute(key, GraphMLExporter.AttributeCategory.NODE, AttributeType.STRING));
        graph.edgeSet().stream().map(Attributed::getAttributes).flatMap(m -> m.entrySet().stream()).map(Map.Entry::getKey).forEach(key -> exporter.registerAttribute(key, GraphMLExporter.AttributeCategory.EDGE, AttributeType.STRING));
        try {
            exporter.exportGraph((Graph)graph, file);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public String getFileExtension() {
        return "graphml";
    }

    public String getName() {
        return "GRAPHML";
    }

    public String getDesciption() {
        return "JGraphT library export of a graph to a GRAPHML file";
    }
}

