/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.ConstantPropagationAnalyzer;
import ghidra.app.plugin.core.analysis.ConstantPropagationContextEvaluator;
import ghidra.app.plugin.core.disassembler.AddressTable;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.disassemble.Disassembler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.SymbolicPropogator;
import ghidra.program.util.VarnodeContext;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;

public class MipsAddressAnalyzer
extends ConstantPropagationAnalyzer {
    private static final int MAX_UNIQUE_GP_SYMBOLS = 50;
    private static final String OPTION_NAME_SWITCH_TABLE = "Attempt to recover switch tables";
    private static final String OPTION_DESCRIPTION_SWITCH_TABLE = "";
    private static final String OPTION_NAME_MARK_DUAL_INSTRUCTION = "Mark dual instruction references";
    private static final String OPTION_DESCRIPTION_MARK_DUAL_INSTRUCTION = "Turn on to mark all potential dual instruction refs,\n(lis - addi/orri/subi)\n even if they are not seen to be used as a reference.";
    private static final String OPTION_NAME_ASSUME_T9_ENTRY = "Assume T9 set to Function entry";
    private static final String OPTION_DESCRIPTION_ASSUME_T9_ENTRY = "Turn on to assume that T9 is set to the entry address of a function when unset T9 register usage encountered";
    private static final String OPTION_NAME_RECOVER_GP = "Recover global GP register writes";
    private static final String OPTION_DESCRIPTION_RECOVER_GP = "Discover writes to the global GP register and assume as constant at the start of functions if only one value has been discovered.";
    private static final boolean OPTION_DEFAULT_SWITCH_TABLE = false;
    private static final boolean OPTION_DEFAULT_MARK_DUAL_INSTRUCTION = false;
    private static final boolean OPTION_DEFAULT_ASSUME_T9_ENTRY = true;
    private static final boolean OPTION_DEFAULT_RECOVER_GP = true;
    private boolean trySwitchTables = false;
    private boolean markupDualInstructionOption = false;
    private boolean assumeT9EntryAddress = true;
    private boolean discoverGlobalGPSetting = true;
    private String[] strLoadStore = new String[]{"addiu", "daddiu", "lw", "_lw", "sw", "_sw", "sh", "_sh", "sd", "_sd", "lbu", "lhu"};
    private HashSet<String> targetLoadStore = new HashSet<String>(Arrays.asList(this.strLoadStore));
    private Register t9;
    private Register gp;
    private Register rareg;
    private Register isamode;
    private Register ismbit;
    private Address gp_assumption_value = null;
    private static final String PROCESSOR_NAME = "MIPS";

    public MipsAddressAnalyzer() {
        super(PROCESSOR_NAME);
    }

    public boolean canAnalyze(Program program) {
        boolean canAnalyze = program.getLanguage().getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)PROCESSOR_NAME));
        if (!canAnalyze) {
            return false;
        }
        this.t9 = program.getRegister("t9");
        this.gp = program.getRegister("gp");
        this.rareg = program.getRegister("ra");
        this.isamode = program.getProgramContext().getRegister("ISA_MODE");
        this.ismbit = program.getProgramContext().getRegister("ISAModeSwitch");
        return true;
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        this.gp_assumption_value = null;
        this.checkForGlobalGP(program, set, monitor);
        return super.added(program, set, monitor, log);
    }

    private void checkForGlobalGP(Program program, AddressSetView set, TaskMonitor monitor) {
        Symbol s1;
        if (!this.discoverGlobalGPSetting) {
            return;
        }
        Symbol symbol = SymbolUtilities.getLabelOrFunctionSymbol((Program)program, (String)"_mips_gp_value", err -> Msg.error((Object)((Object)this), (Object)err));
        if (symbol != null) {
            this.gp_assumption_value = symbol.getAddress();
            return;
        }
        if (set != null && !set.isEmpty()) {
            AddressRangeIterator registerValueAddressRanges = program.getProgramContext().getRegisterValueAddressRanges(this.gp);
            while (registerValueAddressRanges.hasNext()) {
                AddressRange next = (AddressRange)registerValueAddressRanges.next();
                if (!set.contains(next.getMinAddress(), next.getMaxAddress())) continue;
                RegisterValue registerValue = program.getProgramContext().getRegisterValue(this.gp, next.getMinAddress());
                this.gp_assumption_value = next.getMinAddress().getNewAddress(registerValue.getUnsignedValue().longValue());
                return;
            }
        }
        if ((symbol = SymbolUtilities.getLabelOrFunctionSymbol((Program)program, (String)"_gp", err -> Msg.error((Object)((Object)this), (Object)err))) == null) {
            symbol = SymbolUtilities.getLabelOrFunctionSymbol((Program)program, (String)"_GP", err -> Msg.error((Object)((Object)this), (Object)err));
        }
        if (symbol != null) {
            this.gp_assumption_value = symbol.getAddress();
        }
        if ((s1 = SymbolUtilities.getLabelOrFunctionSymbol((Program)program, (String)"_gp_1", err -> Msg.error((Object)((Object)this), (Object)err))) == null) {
            return;
        }
        if (this.gp_assumption_value != null && s1.getAddress().equals((Object)this.gp_assumption_value)) {
            this.gp_assumption_value = null;
            return;
        }
        Symbol s2 = SymbolUtilities.getLabelOrFunctionSymbol((Program)program, (String)"_gp_2", err -> Msg.error((Object)((Object)this), (Object)err));
        if (s2 == null) {
            this.gp_assumption_value = s1.getAddress();
        }
    }

    public Symbol setGPSymbol(Program program, Address toAddr) {
        int index = 1;
        while (index < 50) {
            try {
                String symname = "_gp_" + index++;
                Symbol existingSymbol = SymbolUtilities.getLabelOrFunctionSymbol((Program)program, (String)symname, err -> {});
                if (existingSymbol != null) {
                    if (!existingSymbol.getAddress().equals((Object)toAddr)) continue;
                    return existingSymbol;
                }
                Symbol createSymbol = program.getSymbolTable().createLabel(toAddr, symname, SourceType.ANALYSIS);
                return createSymbol;
            }
            catch (InvalidInputException e) {
                break;
            }
        }
        return null;
    }

    public AddressSetView flowConstants(final Program program, Address flowStart, AddressSetView flowSet, final SymbolicPropogator symEval, final TaskMonitor monitor) throws CancelledException {
        final Function func = program.getFunctionManager().getFunctionContaining(flowStart);
        final AddressSet coveredSet = new AddressSet();
        final Address currentGPAssumptionValue = this.gp_assumption_value;
        if (func != null) {
            ProgramContext programContext;
            RegisterValue gpVal;
            flowStart = func.getEntryPoint();
            if (!(currentGPAssumptionValue == null || (gpVal = (programContext = program.getProgramContext()).getRegisterValue(this.gp, flowStart)) != null && gpVal.hasValue())) {
                gpVal = new RegisterValue(this.gp, BigInteger.valueOf(currentGPAssumptionValue.getOffset()));
                try {
                    program.getProgramContext().setRegisterValue(func.getEntryPoint(), func.getEntryPoint(), gpVal);
                }
                catch (ContextChangeException e) {
                    throw new AssertException("unexpected", (Throwable)e);
                }
            }
        }
        ConstantPropagationContextEvaluator eval = new ConstantPropagationContextEvaluator(this.trustWriteMemOption){
            private Address localGPAssumptionValue;
            private boolean mustStopNow;
            {
                super(arg0);
                this.localGPAssumptionValue = currentGPAssumptionValue;
                this.mustStopNow = false;
            }

            public boolean evaluateContextBefore(VarnodeContext context, Instruction instr) {
                return this.mustStopNow;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean evaluateContext(VarnodeContext context, Instruction instr) {
                RegisterValue registerValue;
                Address addr;
                long target;
                Varnode raVal;
                if (MipsAddressAnalyzer.this.markupDualInstructionOption) {
                    this.markupDualInstructions(context, instr);
                }
                if ((raVal = context.getRegisterVarnodeValue(MipsAddressAnalyzer.this.rareg)) != null && raVal.isConstant() && (target = raVal.getAddress().getOffset()) == (addr = instr.getMaxAddress()).getOffset() + 1L && !instr.getFlowType().isCall()) {
                    instr.setFlowOverride(FlowOverride.CALL);
                    MipsAddressAnalyzer.this.mipsExtDisassembly(program, instr, context, addr.add(1L), monitor);
                    Function f = program.getFunctionManager().getFunctionContaining(instr.getMinAddress());
                    if (f != null) {
                        try {
                            CreateFunctionCmd.fixupFunctionBody((Program)program, (Function)f, (TaskMonitor)monitor);
                        }
                        catch (CancelledException e) {
                            return true;
                        }
                    }
                }
                FlowType flowType = instr.getFlowType();
                if (MipsAddressAnalyzer.this.discoverGlobalGPSetting && (flowType.isCall() || flowType.isTerminal()) && (registerValue = context.getRegisterValue(MipsAddressAnalyzer.this.gp)) != null) {
                    BigInteger value = registerValue.getUnsignedValue();
                    long unsignedValue = value.longValue();
                    if (this.localGPAssumptionValue == null || unsignedValue != this.localGPAssumptionValue.getOffset()) {
                        Register register = MipsAddressAnalyzer.this.gp;
                        synchronized (register) {
                            Instruction instructionAt;
                            Address gpRefAddr = instr.getMinAddress().getNewAddress(unsignedValue);
                            MipsAddressAnalyzer.this.setGPSymbol(program, gpRefAddr);
                            Address lastSetAddr = context.getLastSetLocation(MipsAddressAnalyzer.this.gp, value);
                            Instruction lastSetInstr = instr;
                            if (lastSetAddr != null && (instructionAt = program.getListing().getInstructionContaining(lastSetAddr)) != null) {
                                lastSetInstr = instructionAt;
                            }
                            symEval.makeReference(context, lastSetInstr, -1, (long)instr.getMinAddress().getAddressSpace().getSpaceID(), unsignedValue, 1, RefType.DATA, 0, true, monitor);
                            if (this.localGPAssumptionValue == null) {
                                program.getBookmarkManager().setBookmark(lastSetInstr.getMinAddress(), "Warning", "GP Global Register Set", "Global GP Register is set here.");
                            }
                            if (this.localGPAssumptionValue != null && !this.localGPAssumptionValue.equals((Object)gpRefAddr)) {
                                MipsAddressAnalyzer.this.gp_assumption_value = null;
                                this.localGPAssumptionValue = null;
                            } else {
                                this.localGPAssumptionValue = MipsAddressAnalyzer.this.gp_assumption_value = gpRefAddr;
                            }
                        }
                    }
                }
                return this.mustStopNow;
            }

            private void markupDualInstructions(VarnodeContext context, Instruction instr) {
                BigInteger val;
                Register reg;
                String mnemonic = instr.getMnemonicString();
                if (MipsAddressAnalyzer.this.targetLoadStore.contains(mnemonic) && (reg = instr.getRegister(0)) != null && (val = context.getValue(reg, false)) != null) {
                    int opCheck;
                    long lval = val.longValue();
                    Address refAddr = null;
                    try {
                        refAddr = instr.getMinAddress().getNewAddress(lval);
                    }
                    catch (AddressOutOfBoundsException e) {
                        return;
                    }
                    if ((lval > 4096L || lval < 0L) && lval != 65535L && program.getMemory().contains(refAddr) && instr.getOperandReferences(opCheck = 0).length == 0) {
                        instr.addOperandReference(opCheck, refAddr, RefType.DATA, SourceType.ANALYSIS);
                    }
                }
            }

            public boolean evaluateReference(VarnodeContext context, Instruction instr, int pcodeop, Address address, int size, RefType refType) {
                BigInteger val;
                Register reg;
                Address addr = address;
                if (instr.getMnemonicString().endsWith("lui")) {
                    return false;
                }
                if ((refType.isJump() || refType.isCall()) & refType.isComputed() && (addr = MipsAddressAnalyzer.this.mipsExtDisassembly(program, instr, context, address, monitor)) == null) {
                    addr = address;
                }
                if (refType.isCall() && !addr.isExternalAddress() && instr.getFlowType().isComputed() && (reg = instr.getRegister(0)) != null && MipsAddressAnalyzer.this.t9.equals((Object)reg) && MipsAddressAnalyzer.this.assumeT9EntryAddress && (val = context.getValue(reg, false)) != null) {
                    try {
                        context.clearRegister(reg);
                        instr.addOperandReference(0, addr, refType, SourceType.ANALYSIS);
                        ProgramContext progContext = program.getProgramContext();
                        if (progContext.getValue(reg, addr, false) == null) {
                            progContext.setValue(reg, addr, addr, val);
                            AutoAnalysisManager amgr = AutoAnalysisManager.getAnalysisManager((Program)program);
                            amgr.codeDefined((AddressSetView)new AddressSet(addr));
                        }
                    }
                    catch (ContextChangeException contextChangeException) {
                        // empty catch block
                    }
                }
                return super.evaluateReference(context, instr, pcodeop, address, size, refType);
            }

            public boolean evaluateDestination(VarnodeContext context, Instruction instruction) {
                String mnemonic;
                FlowType flowtype = instruction.getFlowType();
                if (!flowtype.isJump()) {
                    return false;
                }
                if (MipsAddressAnalyzer.this.trySwitchTables && (mnemonic = instruction.getMnemonicString()).equals("jr")) {
                    MipsAddressAnalyzer.this.fixJumpTable(program, instruction, monitor);
                }
                return false;
            }

            public Long unknownValue(VarnodeContext context, Instruction instruction, Varnode node) {
                if (MipsAddressAnalyzer.this.assumeT9EntryAddress && node.isRegister() && context.getRegisterVarnode(MipsAddressAnalyzer.this.t9).contains(node.getAddress())) {
                    if (func != null) {
                        Address funcAddr = func.getEntryPoint();
                        Long value = new Long(funcAddr.getOffset());
                        try {
                            ProgramContext progContext = program.getProgramContext();
                            if (progContext.getValue(MipsAddressAnalyzer.this.t9, funcAddr, false) == null) {
                                progContext.setRegisterValue(funcAddr, funcAddr, new RegisterValue(MipsAddressAnalyzer.this.t9, BigInteger.valueOf(value)));
                                AutoAnalysisManager amgr = AutoAnalysisManager.getAnalysisManager((Program)program);
                                coveredSet.add(func.getBody());
                                amgr.codeDefined((AddressSetView)coveredSet);
                            }
                        }
                        catch (ContextChangeException e) {
                            throw new AssertException("Unexpected Exception", (Throwable)e);
                        }
                    }
                    this.mustStopNow = true;
                }
                return null;
            }
        };
        AddressSet resultSet = symEval.flowConstants(flowStart, null, (ContextEvaluator)eval, true, monitor);
        resultSet.add((AddressSetView)coveredSet);
        return resultSet;
    }

    Address mipsExtDisassembly(Program program, Instruction instruction, VarnodeContext context, Address target, TaskMonitor monitor) {
        if (target == null || target.isExternalAddress()) {
            return null;
        }
        Address addr = this.flowISA(program, instruction, context, target);
        if (addr != null) {
            MemoryBlock block = program.getMemory().getBlock(addr);
            if (block == null || !block.isExecute() || !block.isInitialized() || block.isExternalBlock()) {
                return addr;
            }
            Disassembler dis = Disassembler.getDisassembler((Program)program, (TaskMonitor)monitor, null);
            AddressSet disassembleAddrs = dis.disassemble(addr, null);
            AutoAnalysisManager.getAnalysisManager((Program)program).codeDefined((AddressSetView)disassembleAddrs);
        }
        return addr;
    }

    Address flowISA(Program program, Instruction instruction, VarnodeContext context, Address target) {
        if (target == null) {
            return null;
        }
        Address addr = instruction.getMinAddress().getNewAddress(target.getOffset() & 0xFFFFFFFFFFFFFFFEL);
        Listing listing = program.getListing();
        if (this.isamode != null && listing.getUndefinedDataAt(addr) != null) {
            RegisterValue tbvalue;
            boolean inM16Mode = false;
            RegisterValue curvalue = context.getRegisterValue(this.isamode, instruction.getMinAddress());
            if (curvalue != null && curvalue.hasValue()) {
                boolean bl = inM16Mode = curvalue.getUnsignedValue().intValue() == 1;
            }
            if ((tbvalue = context.getRegisterValue(this.ismbit)) != null && tbvalue.hasValue()) {
                inM16Mode = tbvalue.getUnsignedValue().intValue() == 1;
            }
            BigInteger m16ModeValue = BigInteger.valueOf(inM16Mode ? 1L : 0L);
            try {
                program.getProgramContext().setValue(this.isamode, addr, addr, m16ModeValue);
            }
            catch (ContextChangeException e) {
                throw new AssertException("Unexpected Exception", (Throwable)e);
            }
            return addr;
        }
        return null;
    }

    private void fixJumpTable(Program program, Instruction startInstr, TaskMonitor monitor) {
        AddressTable table;
        int tableLen = -1;
        Address tableAddr = null;
        int valueSize = -1;
        Register target = null;
        Address addr = startInstr.getMinAddress();
        if (this.checkAlreadyRecovered(program, addr)) {
            return;
        }
        Instruction curInstr = startInstr;
        while (tableLen == -1 || target != null && tableAddr == null) {
            Reference ref;
            ReferenceIterator iter;
            Address fallAddr = curInstr.getFallFrom();
            Instruction prevInstr = null;
            if (fallAddr != null) {
                prevInstr = program.getListing().getInstructionContaining(fallAddr);
            }
            if (prevInstr == null && (iter = curInstr.getReferenceIteratorTo()).hasNext() && !(ref = iter.next()).getReferenceType().isCall()) {
                prevInstr = program.getListing().getInstructionContaining(ref.getFromAddress());
            }
            if (!curInstr.isInDelaySlot() && prevInstr != null && prevInstr.getPrototype().hasDelaySlots()) {
                prevInstr = prevInstr.getNext();
            }
            if (prevInstr == null) {
                return;
            }
            if (prevInstr.getMinAddress().compareTo((Object)curInstr.getMinAddress()) >= 0) {
                return;
            }
            curInstr = prevInstr;
            if (tableLen == -1 && (curInstr.getMnemonicString().equals("sltiu") || curInstr.getMnemonicString().equals("_sltiu"))) {
                Scalar scalar = curInstr.getScalar(2);
                if (scalar == null) {
                    return;
                }
                tableLen = (int)scalar.getUnsignedValue();
                if (tableLen <= 255 && tableLen >= 2) continue;
                return;
            }
            if (tableAddr == null && curInstr.getMnemonicString().equals("addiu") && (target == null || target.equals((Object)curInstr.getRegister(0)))) {
                Reference[] refs = curInstr.getReferencesFrom();
                if (refs == null || refs.length == 0) {
                    return;
                }
                tableAddr = refs[0].getToAddress();
            }
            if (tableLen != -1) continue;
            if (valueSize == -1 && (curInstr.getMnemonicString().equals("sll") || curInstr.getMnemonicString().equals("_sll"))) {
                valueSize = 1 << (int)curInstr.getScalar(2).getUnsignedValue();
            }
            if (tableAddr != null) continue;
            if (valueSize == -1 && curInstr.getMnemonicString().equals("lw")) {
                valueSize = 4;
            }
            if (!curInstr.getMnemonicString().equals("addu")) continue;
            target = curInstr.getRegister(2);
        }
        if (tableAddr == null) {
            return;
        }
        if (tableLen <= 0) {
            return;
        }
        if (valueSize == -1) {
            valueSize = program.getDefaultPointerSize();
        }
        if ((table = AddressTable.getEntry((Program)program, tableAddr, (TaskMonitor)monitor, (boolean)false, (int)tableLen, (int)valueSize, (int)0, (long)1024L, (boolean)true)) == null) {
            table = AddressTable.getEntry((Program)program, tableAddr, (TaskMonitor)monitor, (boolean)false, (int)3, (int)valueSize, (int)0, (long)1024L, (boolean)true);
            if (table != null) {
                Msg.error((Object)((Object)this), (Object)("**** MIPS Analyzer: SHOULD be a table of size " + tableLen + " at " + tableAddr + " got " + table.getNumberAddressEntries() + " from instruction at " + startInstr.getMinAddress()));
            } else {
                Msg.error((Object)((Object)this), (Object)("**** MIPS Analyzer: SHOULD be a table of size " + tableLen + " at " + tableAddr + " from instruction at " + startInstr.getMinAddress()));
                return;
            }
        }
        if (tableLen < table.getNumberAddressEntries()) {
            table.truncate(tableLen);
        }
        if (table.getIndexLength() != 0) {
            table = new AddressTable(table.getTopAddress(), table.getTableElements(), null, 0, valueSize, 0, false);
        }
        table.createSwitchTable(program, startInstr, 1, false, monitor);
    }

    private boolean checkAlreadyRecovered(Program program, Address addr) {
        int referenceCountFrom = program.getReferenceManager().getReferenceCountFrom(addr);
        if (referenceCountFrom > 1) {
            return true;
        }
        Reference[] refs = program.getReferenceManager().getReferencesFrom(addr);
        return refs.length == 1 && !refs[0].getReferenceType().isData();
    }

    public void registerOptions(Options options, Program program) {
        super.registerOptions(options, program);
        options.registerOption(OPTION_NAME_SWITCH_TABLE, (Object)this.trySwitchTables, null, OPTION_DESCRIPTION_SWITCH_TABLE);
        options.registerOption(OPTION_NAME_MARK_DUAL_INSTRUCTION, (Object)this.markupDualInstructionOption, null, OPTION_DESCRIPTION_MARK_DUAL_INSTRUCTION);
        options.registerOption(OPTION_NAME_ASSUME_T9_ENTRY, (Object)this.assumeT9EntryAddress, null, OPTION_DESCRIPTION_ASSUME_T9_ENTRY);
        options.registerOption(OPTION_NAME_RECOVER_GP, (Object)this.discoverGlobalGPSetting, null, OPTION_DESCRIPTION_RECOVER_GP);
    }

    public void optionsChanged(Options options, Program program) {
        super.optionsChanged(options, program);
        this.trySwitchTables = options.getBoolean(OPTION_NAME_SWITCH_TABLE, this.trySwitchTables);
        this.markupDualInstructionOption = options.getBoolean(OPTION_NAME_MARK_DUAL_INSTRUCTION, this.markupDualInstructionOption);
        this.assumeT9EntryAddress = options.getBoolean(OPTION_NAME_ASSUME_T9_ENTRY, this.assumeT9EntryAddress);
        this.discoverGlobalGPSetting = options.getBoolean(OPTION_NAME_RECOVER_GP, this.discoverGlobalGPSetting);
    }
}

